/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.commands;

import java.net.URI;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyAgentConfig;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyServant;
import ru.yandex.cloud.ml.platform.lzy.servant.commands.LzyCommand;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFS;

public class Start
implements LzyCommand {
    private static final Logger LOG = LogManager.getLogger(Start.class);

    @Override
    public int execute(CommandLine parse) throws Exception {
        if (!parse.hasOption('z')) {
            throw new RuntimeException("Provide lzy server address with -z option to start a task.");
        }
        Object serverAddress = parse.getOptionValue('z');
        if (!((String)serverAddress).contains("//")) {
            serverAddress = "http://" + (String)serverAddress;
        }
        int port = Integer.parseInt(parse.getOptionValue('p', "9999"));
        Path path = Path.of(parse.getOptionValue('m', System.getenv("HOME") + "/.lzy"), new String[0]);
        String host = parse.getOptionValue('h', LzyFS.lineCmd("hostname"));
        String internalHost = parse.getOptionValue('i', host);
        LzyServant agent = new LzyServant(LzyAgentConfig.builder().serverAddress(URI.create((String)serverAddress)).task(System.getenv("LZYTASK")).token(System.getenv("LZYTOKEN")).agentName(host).agentInternalName(internalHost).agentPort(port).root(path).build());
        LOG.info("Starting servant at " + host + ":" + port + path);
        agent.start();
        agent.awaitTermination();
        return 0;
    }
}

