/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.commands;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import org.apache.commons.cli.CommandLine;
import ru.yandex.cloud.ml.platform.lzy.servant.commands.LzyCommand;
import ru.yandex.cloud.ml.platform.lzy.servant.commands.Update;
import yandex.cloud.priv.datasphere.v2.lzy.IAM;
import yandex.cloud.priv.datasphere.v2.lzy.Lzy;
import yandex.cloud.priv.datasphere.v2.lzy.LzyKharonGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;

public class Publish
implements LzyCommand {
    @Override
    public int execute(CommandLine command) throws Exception {
        if (command.getArgs().length < 2) {
            throw new IllegalArgumentException("Please specify the name of the zygote to publish");
        }
        if (command.getArgs().length < 3) {
            throw new IllegalArgumentException("Please specify zygote declaration file in JSON format");
        }
        URI serverAddr = URI.create(command.getOptionValue('z'));
        ManagedChannel channel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(serverAddr.getHost(), serverAddr.getPort()).usePlaintext()).build();
        LzyKharonGrpc.LzyKharonBlockingStub server = LzyKharonGrpc.newBlockingStub(channel);
        Operations.Zygote.Builder zbuilder = Operations.Zygote.newBuilder();
        JsonFormat.parser().merge(Files.newBufferedReader(Paths.get(command.getArgs()[2], new String[0])), (Message.Builder)zbuilder);
        Operations.RegisteredZygote registered = server.publish(Lzy.PublishRequest.newBuilder().setAuth(IAM.Auth.parseFrom(Base64.getDecoder().decode(command.getOptionValue('a'))).getUser()).setName(command.getArgs()[1]).setOperation(zbuilder.build()).build());
        new Update().execute(command);
        System.out.println("Registered " + registered.getName());
        return 0;
    }
}

