/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.agents;

import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.JsonUtils;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyOutputSlot;
import yandex.cloud.priv.datasphere.v2.lzy.Kharon;
import yandex.cloud.priv.datasphere.v2.lzy.LzyKharonGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;

public class TerminalSlotSender {
    private static final Logger LOG = LogManager.getLogger(TerminalSlotSender.class);
    private final LzyKharonGrpc.LzyKharonStub connectedSlotController;

    public TerminalSlotSender(LzyKharonGrpc.LzyKharonStub kharonStub) {
        this.connectedSlotController = kharonStub;
    }

    public void connect(LzyOutputSlot lzySlot, URI slotUri) {
        LOG.info("TerminalOutputSlot::connect " + slotUri);
        SlotWriter writer = new SlotWriter(lzySlot, slotUri);
        writer.run();
    }

    private static Kharon.SendSlotDataMessage createChunkMessage(ByteString chunk) {
        return Kharon.SendSlotDataMessage.newBuilder().setMessage(Servant.Message.newBuilder().setChunk(chunk).build()).build();
    }

    private static Kharon.SendSlotDataMessage createEosMessage() {
        return Kharon.SendSlotDataMessage.newBuilder().setMessage(Servant.Message.newBuilder().setControl(Servant.Message.Controls.EOS).build()).build();
    }

    private class SlotWriter {
        private final LzyOutputSlot lzySlot;
        private final URI slotUri;
        private long offset = 0L;
        private final StreamObserver<Kharon.SendSlotDataMessage> responseObserver;

        SlotWriter(final LzyOutputSlot lzySlot, URI slotUri) {
            this.lzySlot = lzySlot;
            this.slotUri = slotUri;
            StreamObserver<Kharon.ReceivedDataStatus> statusReceiver = new StreamObserver<Kharon.ReceivedDataStatus>(){

                @Override
                public void onNext(Kharon.ReceivedDataStatus receivedDataStatus) {
                    LOG.info("Got response for slot " + lzySlot + " sending " + JsonUtils.printRequest(receivedDataStatus));
                    SlotWriter.this.offset = receivedDataStatus.getOffset();
                }

                @Override
                public void onError(Throwable throwable) {
                    LOG.error("Exception while sending chunks from slot " + lzySlot + ": " + throwable);
                }

                @Override
                public void onCompleted() {
                    LOG.info("Sending chunks from slot " + lzySlot + " was finished");
                }
            };
            this.responseObserver = TerminalSlotSender.this.connectedSlotController.writeToInputSlot(statusReceiver);
        }

        public void run() {
            try {
                LOG.info("Starting sending bytes slot:: " + this.lzySlot);
                this.responseObserver.onNext(Kharon.SendSlotDataMessage.newBuilder().setRequest(Servant.SlotRequest.newBuilder().setSlot(this.slotUri.getPath()).setOffset(this.offset).setSlotUri(this.slotUri.toString()).build()).build());
                this.lzySlot.readFromPosition(this.offset).forEach(chunk -> this.responseObserver.onNext(TerminalSlotSender.createChunkMessage(chunk)));
                LOG.info("Completed sending bytes slot:: " + this.lzySlot);
                this.responseObserver.onNext(TerminalSlotSender.createEosMessage());
                this.responseObserver.onCompleted();
            }
            catch (IOException iae) {
                LOG.error("Got exception while sending bytes slot:: " + this.lzySlot + " exception:" + iae);
                this.responseObserver.onError(iae);
            }
        }
    }
}

