/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.agents;

import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ForkJoinPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.JsonUtils;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.AgentStatus;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyAgent;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyAgentConfig;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyExecution;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.TerminalSlotSender;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyInputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyOutputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzySlot;
import yandex.cloud.priv.datasphere.v2.lzy.IAM;
import yandex.cloud.priv.datasphere.v2.lzy.Kharon;
import yandex.cloud.priv.datasphere.v2.lzy.LzyKharonGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.LzyServantGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;

public class LzyTerminal
extends LzyAgent
implements Closeable {
    private static final Logger LOG = LogManager.getLogger(LzyTerminal.class);
    private final Server agentServer;
    private final ManagedChannel channel;
    private final LzyKharonGrpc.LzyKharonStub kharon;
    private final LzyKharonGrpc.LzyKharonBlockingStub kharonBlockingStub;
    private CommandHandler commandHandler;
    private LzyExecution currentExecution;

    public LzyTerminal(LzyAgentConfig config) throws URISyntaxException {
        super(config);
        Impl impl = new Impl();
        this.agentServer = ((ServerBuilder)ServerBuilder.forPort(config.getAgentPort()).addService(impl)).build();
        this.channel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(this.serverAddress.getHost(), this.serverAddress.getPort()).usePlaintext()).build();
        this.kharon = LzyKharonGrpc.newStub(this.channel);
        this.kharonBlockingStub = LzyKharonGrpc.newBlockingStub(this.channel);
    }

    @Override
    protected Server server() {
        return this.agentServer;
    }

    @Override
    protected void onStartUp() {
        this.commandHandler = new CommandHandler();
        this.status.set(AgentStatus.PREPARING_EXECUTION);
        this.currentExecution = new LzyExecution(null, null, this.agentInternalAddress);
        this.status.set(AgentStatus.EXECUTING);
        Context.current().addListener(context -> {
            if (this.currentExecution != null) {
                LOG.info("Execution terminated from server ");
                System.exit(1);
            }
        }, Runnable::run);
        this.currentExecution.onProgress(progress -> {
            LOG.info("LzyTerminal::progress {} {}", (Object)this.agentAddress, (Object)JsonUtils.printRequest(progress));
            if (progress.hasAttach()) {
                Kharon.TerminalState terminalState = Kharon.TerminalState.newBuilder().setAttach(progress.getAttach()).build();
                this.commandHandler.onNext(terminalState);
            } else if (progress.hasDetach()) {
                Kharon.TerminalState terminalState = Kharon.TerminalState.newBuilder().setDetach(progress.getDetach()).build();
                this.commandHandler.onNext(terminalState);
            } else {
                LOG.info("Skipping to send progress from terminal to server :" + JsonUtils.printRequest(progress));
            }
            if (progress.hasExit()) {
                LOG.info("LzyTerminal::exit {}", (Object)this.agentAddress);
                this.currentExecution = null;
                this.commandHandler.onCompleted();
            }
        });
    }

    @Override
    protected LzyAgent.LzyServerApi lzyServerApi() {
        return this.kharonBlockingStub::zygotes;
    }

    @Override
    public void close() {
        super.close();
        this.commandHandler.onCompleted();
        this.channel.shutdown();
    }

    private class Impl
    extends LzyServantGrpc.LzyServantImplBase {
        private Impl() {
        }

        @Override
        public void configureSlot(Servant.SlotCommand request, StreamObserver<Servant.SlotCommandStatus> responseObserver) {
            LOG.info("LzyTerminal configureSlot " + JsonUtils.printRequest(request));
            LzyTerminal.this.configureSlot(LzyTerminal.this.currentExecution, request, responseObserver);
        }

        @Override
        public void update(IAM.Auth request, StreamObserver<Servant.ExecutionStarted> responseObserver) {
            LzyTerminal.this.update(request, responseObserver);
        }

        @Override
        public void status(IAM.Empty request, StreamObserver<Servant.ServantStatus> responseObserver) {
            LzyTerminal.this.status(LzyTerminal.this.currentExecution, request, responseObserver);
        }
    }

    private class CommandHandler {
        private final StreamObserver<Kharon.TerminalState> responseObserver;
        private final TerminalSlotSender slotSender;

        CommandHandler() {
            this.slotSender = new TerminalSlotSender(LzyTerminal.this.kharon);
            StreamObserver<Kharon.TerminalCommand> supplier = new StreamObserver<Kharon.TerminalCommand>(){

                @Override
                public void onNext(Kharon.TerminalCommand terminalCommand) {
                    LOG.info("TerminalCommand::onNext " + JsonUtils.printRequest(terminalCommand));
                    String commandId = terminalCommand.getCommandId();
                    if (terminalCommand.getCommandCase() != Kharon.TerminalCommand.CommandCase.SLOTCOMMAND) {
                        CommandHandler.this.onError(Status.INVALID_ARGUMENT.asException());
                    }
                    Servant.SlotCommand slotCommand = terminalCommand.getSlotCommand();
                    try {
                        LzySlot slot = LzyTerminal.this.currentExecution.slot(slotCommand.getSlot());
                        if (slotCommand.hasConnect()) {
                            URI slotUri = URI.create(slotCommand.getConnect().getSlotUri());
                            ForkJoinPool.commonPool().execute(() -> {
                                if (slot instanceof LzyOutputSlot) {
                                    CommandHandler.this.slotSender.connect((LzyOutputSlot)slot, slotUri);
                                } else if (slot instanceof LzyInputSlot) {
                                    ((LzyInputSlot)slot).connect(slotUri, LzyTerminal.this.kharonBlockingStub::openOutputSlot);
                                }
                            });
                            CommandHandler.this.onNext(Kharon.TerminalState.newBuilder().setCommandId(commandId).setSlotStatus(Servant.SlotCommandStatus.newBuilder().setRc(Servant.SlotCommandStatus.RC.newBuilder().setCodeValue(0).build()).build()).build());
                            return;
                        }
                        Servant.SlotCommandStatus slotCommandStatus = LzyTerminal.this.configureSlot(LzyTerminal.this.currentExecution, slotCommand);
                        Kharon.TerminalState terminalState = Kharon.TerminalState.newBuilder().setCommandId(commandId).setSlotStatus(slotCommandStatus).build();
                        LOG.info("CommandHandler::onNext " + JsonUtils.printRequest(terminalState));
                        CommandHandler.this.onNext(terminalState);
                    }
                    catch (StatusException e) {
                        LOG.info("CommandHandler::onError " + e);
                        CommandHandler.this.onError(e);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    LOG.error("Exception during terminal <-> server: " + throwable);
                    System.exit(-1);
                }

                @Override
                public void onCompleted() {
                    LOG.warn("Terminal was detached from server");
                    System.exit(0);
                }
            };
            this.responseObserver = LzyTerminal.this.kharon.attachTerminal(supplier);
            LzyTerminal.this.status.set(AgentStatus.REGISTERING);
            this.responseObserver.onNext(Kharon.TerminalState.newBuilder().setAttachTerminal(Kharon.AttachTerminal.newBuilder().setAuth(LzyTerminal.this.auth.getUser()).build()).build());
            LzyTerminal.this.status.set(AgentStatus.REGISTERED);
        }

        public synchronized void onNext(Kharon.TerminalState terminalState) {
            this.responseObserver.onNext(terminalState);
        }

        public void onError(Throwable th) {
            this.responseObserver.onError(th);
        }

        public void onCompleted() {
            this.responseObserver.onCompleted();
        }
    }
}

