/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.agents;

import com.google.protobuf.ByteString;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.JsonUtils;
import ru.yandex.cloud.ml.platform.lzy.model.gRPCConverter;
import ru.yandex.cloud.ml.platform.lzy.model.graph.AtomicZygote;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.AgentStatus;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyAgent;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyAgentConfig;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyExecution;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyOutputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzySlot;
import yandex.cloud.priv.datasphere.v2.lzy.IAM;
import yandex.cloud.priv.datasphere.v2.lzy.Lzy;
import yandex.cloud.priv.datasphere.v2.lzy.LzyServantGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.LzyServerGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;
import yandex.cloud.priv.datasphere.v2.lzy.Tasks;

public class LzyServant
extends LzyAgent {
    private static final Logger LOG = LogManager.getLogger(LzyServant.class);
    private final LzyServerGrpc.LzyServerBlockingStub server;
    private final Server agentServer;

    public LzyServant(LzyAgentConfig config) throws URISyntaxException {
        super(config);
        Impl impl = new Impl();
        ManagedChannel channel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(this.serverAddress.getHost(), this.serverAddress.getPort()).usePlaintext()).build();
        this.server = LzyServerGrpc.newBlockingStub(channel);
        this.agentServer = ((ServerBuilder)ServerBuilder.forPort(config.getAgentPort()).addService(impl)).build();
    }

    @Override
    protected Server server() {
        return this.agentServer;
    }

    @Override
    protected void onStartUp() {
        this.status.set(AgentStatus.REGISTERING);
        Lzy.AttachServant.Builder commandBuilder = Lzy.AttachServant.newBuilder();
        commandBuilder.setAuth(this.auth);
        commandBuilder.setServantURI(this.agentAddress.toString());
        this.server.registerServant(commandBuilder.build());
        this.status.set(AgentStatus.REGISTERED);
    }

    @Override
    protected LzyAgent.LzyServerApi lzyServerApi() {
        return this.server::zygotes;
    }

    private class Impl
    extends LzyServantGrpc.LzyServantImplBase {
        private LzyExecution currentExecution;

        private Impl() {
        }

        @Override
        public void execute(Tasks.TaskSpec request, StreamObserver<Servant.ExecutionProgress> responseObserver) {
            LzyServant.this.status.set(AgentStatus.PREPARING_EXECUTION);
            LOG.info("LzyServant::execute " + JsonUtils.printRequest(request));
            if (this.currentExecution != null) {
                responseObserver.onError(Status.RESOURCE_EXHAUSTED.asException());
                return;
            }
            String tid = request.getAuth().getTask().getTaskId();
            this.currentExecution = new LzyExecution(tid, (AtomicZygote)gRPCConverter.from(request.getZygote()), LzyServant.this.agentInternalAddress);
            this.currentExecution.onProgress(progress -> {
                LOG.info("LzyServant::progress {} {}", (Object)LzyServant.this.agentAddress, (Object)JsonUtils.printRequest(progress));
                responseObserver.onNext((Servant.ExecutionProgress)progress);
                if (progress.hasExit()) {
                    LOG.info("LzyServant::exit {}", (Object)LzyServant.this.agentAddress);
                    this.currentExecution = null;
                    responseObserver.onCompleted();
                }
            });
            Context.current().addListener(context -> {
                if (this.currentExecution != null) {
                    LOG.info("Execution terminated from server ");
                    System.exit(1);
                }
            }, Runnable::run);
            for (Tasks.SlotAssignment spec : request.getAssignmentsList()) {
                LzySlot lzySlot = this.currentExecution.configureSlot(gRPCConverter.from(spec.getSlot()), spec.getBinding());
                if (!(lzySlot instanceof LzyFileSlot)) continue;
                LOG.info("lzyFS::addSlot " + lzySlot.name());
                LzyServant.this.lzyFS.addSlot((LzyFileSlot)lzySlot);
                LOG.info("lzyFS::slot added " + lzySlot.name());
            }
            this.currentExecution.start();
            LzyServant.this.status.set(AgentStatus.EXECUTING);
        }

        @Override
        public void openOutputSlot(Servant.SlotRequest request, StreamObserver<Servant.Message> responseObserver) {
            LOG.info("LzyServant::openOutputSlot " + JsonUtils.printRequest(request));
            if (this.currentExecution == null || this.currentExecution.slot(request.getSlot()) == null) {
                LOG.info("Not found slot: " + request.getSlot());
                responseObserver.onError(Status.NOT_FOUND.asException());
                return;
            }
            LzyOutputSlot slot = (LzyOutputSlot)this.currentExecution.slot(request.getSlot());
            try {
                slot.readFromPosition(request.getOffset()).forEach(chunk -> responseObserver.onNext(Servant.Message.newBuilder().setChunk((ByteString)chunk).build()));
                responseObserver.onNext(Servant.Message.newBuilder().setControl(Servant.Message.Controls.EOS).build());
                responseObserver.onCompleted();
            }
            catch (IOException iae) {
                responseObserver.onError(iae);
            }
        }

        @Override
        public void configureSlot(Servant.SlotCommand request, StreamObserver<Servant.SlotCommandStatus> responseObserver) {
            LzyServant.this.configureSlot(this.currentExecution, request, responseObserver);
        }

        @Override
        public void signal(Tasks.TaskSignal request, StreamObserver<Servant.ExecutionStarted> responseObserver) {
            if (this.currentExecution == null) {
                responseObserver.onError(Status.NOT_FOUND.asException());
                return;
            }
            this.currentExecution.signal(request.getSigValue());
            responseObserver.onNext(Servant.ExecutionStarted.newBuilder().build());
            responseObserver.onCompleted();
        }

        @Override
        public void update(IAM.Auth request, StreamObserver<Servant.ExecutionStarted> responseObserver) {
            LzyServant.this.update(request, responseObserver);
        }

        @Override
        public void status(IAM.Empty request, StreamObserver<Servant.ServantStatus> responseObserver) {
            LzyServant.this.status(this.currentExecution, request, responseObserver);
        }

        @Override
        public void stop(IAM.Empty request, StreamObserver<IAM.Empty> responseObserver) {
            LOG.info("Servant::stop {}", (Object)LzyServant.this.agentAddress);
            responseObserver.onNext(IAM.Empty.newBuilder().build());
            responseObserver.onCompleted();
            System.exit(0);
        }
    }
}

