/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.agents;

import java.net.URI;
import java.nio.file.Path;

public class LzyAgentConfig {
    private final URI serverAddress;
    private final String agentName;
    private final String agentInternalName;
    private final String token;
    private final Path root;
    private final String tokenSign;
    private final String user;
    private final String task;
    private final int agentPort;

    private LzyAgentConfig(URI serverAddress, String agentName, String agentInternalName, String token, Path root, String tokenSign, String user, String task, int agentPort) {
        this.serverAddress = serverAddress;
        this.agentName = agentName;
        this.agentInternalName = agentInternalName;
        this.token = token;
        this.root = root;
        this.tokenSign = tokenSign;
        this.user = user;
        this.task = task;
        this.agentPort = agentPort;
    }

    public static LzyAgentConfigBuilder builder() {
        return new LzyAgentConfigBuilder();
    }

    public URI getServerAddress() {
        return this.serverAddress;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentInternalName() {
        return this.agentInternalName;
    }

    public String getToken() {
        return this.token;
    }

    public Path getRoot() {
        return this.root;
    }

    public String getTokenSign() {
        return this.tokenSign;
    }

    public String getUser() {
        return this.user;
    }

    public String getTask() {
        return this.task;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public static class LzyAgentConfigBuilder {
        private URI serverAddress;
        private String agentName;
        private String agentInternalName;
        private String token;
        private Path root;
        private String tokenSign;
        private String user;
        private String task;
        private int agentPort;

        public LzyAgentConfigBuilder agentInternalName(String agentInternalName) {
            this.agentInternalName = agentInternalName;
            return this;
        }

        public LzyAgentConfigBuilder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public LzyAgentConfigBuilder agentPort(int agentPort) {
            this.agentPort = agentPort;
            return this;
        }

        public LzyAgentConfigBuilder root(Path root) {
            this.root = root;
            return this;
        }

        public LzyAgentConfigBuilder serverAddress(URI serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public LzyAgentConfigBuilder task(String task) {
            this.task = task;
            return this;
        }

        public LzyAgentConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public LzyAgentConfigBuilder tokenSign(String tokenSign) {
            this.tokenSign = tokenSign;
            return this;
        }

        public LzyAgentConfigBuilder user(String user) {
            this.user = user;
            return this;
        }

        public LzyAgentConfig build() {
            return new LzyAgentConfig(this.serverAddress, this.agentName, this.agentInternalName, this.token, this.root, this.tokenSign, this.user, this.task, this.agentPort);
        }
    }
}

