/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.agents;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.JsonUtils;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.model.Zygote;
import ru.yandex.cloud.ml.platform.lzy.model.gRPCConverter;
import ru.yandex.cloud.ml.platform.lzy.servant.BashApi;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.AgentStatus;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyAgentConfig;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyExecution;
import ru.yandex.cloud.ml.platform.lzy.servant.commands.LzyCommand;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFS;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyInputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyScript;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzySlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.SlotConnectionManager;
import yandex.cloud.priv.datasphere.v2.lzy.IAM;
import yandex.cloud.priv.datasphere.v2.lzy.LzyServantGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;

public abstract class LzyAgent
implements Closeable {
    private static final Logger LOG = LogManager.getLogger(LzyAgent.class);
    protected final URI serverAddress;
    protected final Path mount;
    protected final IAM.Auth auth;
    protected final LzyFS lzyFS;
    protected final URI agentAddress;
    protected final URI agentInternalAddress;
    protected final AtomicReference<AgentStatus> status = new AtomicReference<AgentStatus>(AgentStatus.STARTED);
    protected final SlotConnectionManager slotConnectionManager = new SlotConnectionManager();

    protected LzyAgent(LzyAgentConfig config) throws URISyntaxException {
        this.mount = config.getRoot();
        this.serverAddress = config.getServerAddress();
        this.lzyFS = new LzyFS();
        this.createFsDirectories();
        this.lzyFS.mount(this.mount, false, false);
        this.auth = LzyAgent.getAuth(config);
        this.agentAddress = new URI("http", null, config.getAgentName(), config.getAgentPort(), null, null, null);
        this.agentInternalAddress = config.getAgentInternalName() == null ? this.agentAddress : new URI("http", null, config.getAgentInternalName(), config.getAgentPort(), null, null, null);
    }

    protected abstract void onStartUp();

    protected abstract Server server();

    protected abstract LzyServerApi lzyServerApi();

    private static IAM.Auth getAuth(LzyAgentConfig config) {
        IAM.Auth.Builder authBuilder = IAM.Auth.newBuilder();
        if (config.getUser() != null) {
            String tokenSign = config.getTokenSign() != null ? config.getTokenSign() : "";
            String signedToken = config.getToken() + "." + tokenSign;
            IAM.UserCredentials.Builder credBuilder = IAM.UserCredentials.newBuilder().setUserId(config.getUser()).setToken(signedToken);
            authBuilder.setUser(credBuilder.build());
        } else {
            authBuilder.setTask(IAM.TaskCredentials.newBuilder().setTaskId(config.getTask()).setToken(config.getToken()).build());
        }
        return authBuilder.build();
    }

    public void start() throws IOException {
        Server agentServer = this.server();
        agentServer.start();
        for (LzyCommand.Commands command : LzyCommand.Commands.values()) {
            this.publishTool(null, Paths.get(command.name(), new String[0]), command.name());
        }
        Operations.ZygoteList zygotes = this.lzyServerApi().zygotes(this.auth);
        for (Operations.RegisteredZygote zygote : zygotes.getZygoteList()) {
            this.publishTool(zygote.getWorkload(), Paths.get(zygote.getName(), new String[0]), "run");
        }
        this.onStartUp();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("Shutdown hook in lzy-agent {}", (Object)this.agentAddress);
            agentServer.shutdown();
            try {
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public void awaitTermination() throws InterruptedException {
        this.server().awaitTermination();
    }

    private void createFsDirectories() {
        try {
            Files.createDirectories(this.mount, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.lzyFS.umount();
    }

    public void publishTool(final Operations.Zygote z, final Path to, String ... servantArgs) {
        LOG.info("publish tool " + z + " to " + to);
        try {
            String zygoteJson = z != null ? JsonFormat.printer().print(z) : null;
            String logConfFile = System.getProperty("log4j.configurationFile");
            ArrayList<Object> commandParts = new ArrayList<Object>();
            commandParts.add(System.getProperty("java.home") + "/bin/java");
            commandParts.add("-Xmx1g");
            commandParts.add("-Dcustom.log.file=" + to.getFileName() + "_$(($RANDOM % 10000))");
            if (logConfFile != null) {
                commandParts.add("-Dlog4j.configurationFile=" + logConfFile);
            }
            commandParts.add("-classpath");
            commandParts.add("\"" + System.getProperty("java.class.path") + "\"");
            commandParts.add(BashApi.class.getCanonicalName());
            commandParts.addAll(List.of("--port", Integer.toString(this.agentAddress.getPort())));
            commandParts.addAll(List.of("--lzy-address", this.serverAddress.toString()));
            commandParts.addAll(List.of("--lzy-mount", this.mount.toAbsolutePath().toString()));
            commandParts.addAll(List.of("--auth", new String(Base64.getEncoder().encode(this.auth.toByteString().toByteArray()))));
            commandParts.addAll(Arrays.asList(servantArgs));
            commandParts.add("$@");
            StringBuilder scriptBuilder = new StringBuilder();
            if (zygoteJson != null) {
                scriptBuilder.append("export ZYGOTE=").append('\"').append(zygoteJson.replaceAll("\"", "\\\\\"").replaceAll("\\R", "\\\\\n")).append('\"').append("\n\n");
            }
            scriptBuilder.append(String.join((CharSequence)" ", commandParts)).append("\n");
            final String script = scriptBuilder.toString();
            this.lzyFS.addScript(new LzyScript(){

                @Override
                public Zygote operation() {
                    return gRPCConverter.from(z);
                }

                @Override
                public Path location() {
                    return to;
                }

                @Override
                public CharSequence scriptText() {
                    return script;
                }
            }, z == null);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
    }

    public void configureSlot(@Nullable LzyExecution execution, Servant.SlotCommand request, StreamObserver<Servant.SlotCommandStatus> responseObserver) {
        try {
            Servant.SlotCommandStatus slotCommandStatus = this.configureSlot(execution, request);
            responseObserver.onNext(slotCommandStatus);
            responseObserver.onCompleted();
        }
        catch (StatusException e) {
            responseObserver.onError(e);
        }
    }

    public Servant.SlotCommandStatus configureSlot(@Nullable LzyExecution currentExecution, Servant.SlotCommand request) throws StatusException {
        LOG.info("Agent::configureSlot " + JsonUtils.printRequest(request));
        if (currentExecution == null) {
            LOG.error("Agent::configureSlot NO_LZY_EXECUTION");
            throw Status.NOT_FOUND.asException();
        }
        LzySlot slot = currentExecution.slot(request.getSlot());
        if (slot == null && request.getCommandCase() != Servant.SlotCommand.CommandCase.CREATE) {
            return Servant.SlotCommandStatus.newBuilder().setRc(Servant.SlotCommandStatus.RC.newBuilder().setCodeValue(1).setDescription("Slot " + request.getSlot() + " is not found in LzyExecution").build()).build();
        }
        switch (request.getCommandCase()) {
            case CREATE: {
                Servant.CreateSlotCommand create = request.getCreate();
                Slot slotSpec = gRPCConverter.from(create.getSlot());
                LzySlot lzySlot = currentExecution.configureSlot(slotSpec, create.getChannelId());
                if (!(lzySlot instanceof LzyFileSlot)) break;
                LOG.info("lzyFS::addSlot " + lzySlot.name());
                this.lzyFS.addSlot((LzyFileSlot)lzySlot);
                LOG.info("lzyFS:: slot added " + lzySlot.name());
                break;
            }
            case CONNECT: {
                Servant.ConnectSlotCommand connect = request.getConnect();
                URI slotUri = URI.create(connect.getSlotUri());
                SlotConnectionManager.SlotController slotController = this.slotConnectionManager.getOrCreate(slot.name(), slotUri, channel -> {
                    LzyServantGrpc.LzyServantBlockingStub stub = LzyServantGrpc.newBlockingStub(channel);
                    return stub::openOutputSlot;
                });
                ((LzyInputSlot)slot).connect(slotUri, slotController);
                break;
            }
            case DISCONNECT: {
                if (slot instanceof LzyInputSlot) {
                    this.slotConnectionManager.shutdownConnections(slot.name());
                }
                slot.suspend();
                break;
            }
            case STATUS: {
                Operations.SlotStatus.Builder status = Operations.SlotStatus.newBuilder(slot.status());
                if (this.auth.hasUser()) {
                    status.setUser(this.auth.getUser().getUserId());
                }
                return Servant.SlotCommandStatus.newBuilder().setStatus(status.build()).build();
            }
            case DESTROY: {
                slot.destroy();
                this.lzyFS.removeSlot(slot.name());
                LOG.info("Agent::Explicitly closing slot " + slot.name());
                break;
            }
            default: {
                throw Status.INVALID_ARGUMENT.asException();
            }
        }
        return Servant.SlotCommandStatus.newBuilder().build();
    }

    public void update(IAM.Auth request, StreamObserver<Servant.ExecutionStarted> responseObserver) {
        Operations.ZygoteList zygotes = this.lzyServerApi().zygotes(this.auth);
        for (Operations.RegisteredZygote zygote : zygotes.getZygoteList()) {
            this.publishTool(zygote.getWorkload(), Paths.get(zygote.getName(), new String[0]), "run", zygote.getName());
        }
        responseObserver.onNext(Servant.ExecutionStarted.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void status(@Nullable LzyExecution currentExecution, IAM.Empty request, StreamObserver<Servant.ServantStatus> responseObserver) {
        Servant.ServantStatus.Builder builder = Servant.ServantStatus.newBuilder();
        builder.setStatus(this.status.get().toGrpcServantStatus());
        if (currentExecution != null) {
            builder.addAllConnections(currentExecution.slots().map(slot -> {
                Operations.SlotStatus.Builder status = Operations.SlotStatus.newBuilder(slot.status());
                if (this.auth.hasUser()) {
                    status.setUser(this.auth.getUser().getUserId());
                }
                return status.build();
            }).collect(Collectors.toList()));
        }
        responseObserver.onNext(builder.build());
        responseObserver.onCompleted();
    }

    public static interface LzyServerApi {
        public Operations.ZygoteList zygotes(IAM.Auth var1);
    }
}

