/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegistry.class);
    private static volatile MBeanRegistry instance = new MBeanRegistry();
    private final Object LOCK = new Object();
    private Map<ZKMBeanInfo, String> mapBean2Path = new ConcurrentHashMap<ZKMBeanInfo, String>();
    private MBeanServer mBeanServer;

    public static void setInstance(MBeanRegistry instance) {
        MBeanRegistry.instance = instance;
    }

    public static MBeanRegistry getInstance() {
        return instance;
    }

    public MBeanRegistry() {
        try {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Error e) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
        }
    }

    public MBeanServer getPlatformMBeanServer() {
        return this.mBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ZKMBeanInfo bean2, ZKMBeanInfo parent) throws JMException {
        assert (bean2 != null);
        String path = null;
        if (parent != null) {
            path = this.mapBean2Path.get(parent);
            assert (path != null);
        }
        path = this.makeFullPath(path, parent);
        if (bean2.isHidden()) {
            return;
        }
        ObjectName oname = this.makeObjectName(path, bean2);
        try {
            Object object = this.LOCK;
            synchronized (object) {
                this.mBeanServer.registerMBean(bean2, oname);
                this.mapBean2Path.put(bean2, path);
            }
        }
        catch (JMException e) {
            LOG.warn("Failed to register MBean " + bean2.getName());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(String path, ZKMBeanInfo bean2) throws JMException {
        if (path == null) {
            return;
        }
        if (!bean2.isHidden()) {
            ObjectName objName = this.makeObjectName(path, bean2);
            if (LOG.isInfoEnabled()) {
                LOG.info("Unregister MBean [{}]", (Object)objName);
            }
            Object object = this.LOCK;
            synchronized (object) {
                this.mBeanServer.unregisterMBean(objName);
            }
        }
    }

    public Set<ZKMBeanInfo> getRegisteredBeans() {
        return new HashSet<ZKMBeanInfo>(this.mapBean2Path.keySet());
    }

    public void unregister(ZKMBeanInfo bean2) {
        if (bean2 == null) {
            return;
        }
        String path = this.mapBean2Path.remove(bean2);
        try {
            this.unregister(path, bean2);
        }
        catch (JMException e) {
            LOG.warn("Error during unregister of [{}]", (Object)bean2.getName(), (Object)e);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception during unregister of [{}]. It should be reviewed and fixed.", (Object)bean2.getName(), (Object)t);
        }
    }

    public String makeFullPath(String prefix, String ... name) {
        StringBuilder sb = new StringBuilder(prefix == null ? "/" : (prefix.equals("/") ? prefix : prefix + "/"));
        boolean first = true;
        for (String s2 : name) {
            if (s2 == null) continue;
            if (!first) {
                sb.append("/");
            } else {
                first = false;
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    protected String makeFullPath(String prefix, ZKMBeanInfo bean2) {
        return this.makeFullPath(prefix, bean2 == null ? null : bean2.getName());
    }

    private int tokenize(StringBuilder sb, String path, int index) {
        String[] tokens;
        for (String s2 : tokens = path.split("/")) {
            if (s2.length() == 0) continue;
            sb.append("name").append(index++).append("=").append(s2).append(",");
        }
        return index;
    }

    protected ObjectName makeObjectName(String path, ZKMBeanInfo bean2) throws MalformedObjectNameException {
        if (path == null) {
            return null;
        }
        StringBuilder beanName = new StringBuilder("org.apache.ZooKeeperService:");
        int counter = 0;
        counter = this.tokenize(beanName, path, counter);
        this.tokenize(beanName, bean2.getName(), counter);
        beanName.deleteCharAt(beanName.length() - 1);
        try {
            return new ObjectName(beanName.toString());
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Invalid name \"" + beanName.toString() + "\" for class " + bean2.getClass().toString());
            throw e;
        }
    }
}

