/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import org.apache.curator.framework.recipes.locks.PredicateResults;
import org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;

public class LockPathInterProcessReadWriteLock {
    private final InternalInterProcessMutex readMutex;
    private final InternalInterProcessMutex writeMutex;
    private static final String READ_LOCK_NAME = "__READ__";
    private static final String WRITE_LOCK_NAME = "__WRIT__";

    public LockPathInterProcessReadWriteLock(CuratorFramework client, String basePath) {
        this(client, basePath, null);
    }

    public LockPathInterProcessReadWriteLock(CuratorFramework client, String basePath, byte[] lockData) {
        lockData = lockData == null ? null : Arrays.copyOf(lockData, lockData.length);
        this.writeMutex = new InternalInterProcessMutex(client, basePath, WRITE_LOCK_NAME, lockData, 1, new SortingLockInternalsDriver(){

            @Override
            public PredicateResults getsTheLock(CuratorFramework client, List<String> children, String sequenceNodeName, int maxLeases) throws Exception {
                return super.getsTheLock(client, children, sequenceNodeName, maxLeases);
            }
        });
        this.readMutex = new InternalInterProcessMutex(client, basePath, READ_LOCK_NAME, lockData, Integer.MAX_VALUE, new SortingLockInternalsDriver(){

            @Override
            public PredicateResults getsTheLock(CuratorFramework client, List<String> children, String sequenceNodeName, int maxLeases) throws Exception {
                return LockPathInterProcessReadWriteLock.this.readLockPredicate(children, sequenceNodeName);
            }
        });
    }

    public InterProcessMutex readLock() {
        return this.readMutex;
    }

    public InterProcessMutex writeLock() {
        return this.writeMutex;
    }

    private PredicateResults readLockPredicate(List<String> children, String sequenceNodeName) throws Exception {
        if (this.writeMutex.isOwnedByCurrentThread()) {
            return new PredicateResults(null, true);
        }
        int index = 0;
        int firstWriteIndex = Integer.MAX_VALUE;
        int ourIndex = -1;
        for (String node : children) {
            if (node.contains(WRITE_LOCK_NAME)) {
                firstWriteIndex = Math.min(index, firstWriteIndex);
            } else if (node.startsWith(sequenceNodeName)) {
                ourIndex = index;
                break;
            }
            ++index;
        }
        StandardLockInternalsDriver.validateOurIndex(sequenceNodeName, ourIndex);
        boolean getsTheLock = ourIndex < firstWriteIndex;
        String pathToWatch = getsTheLock ? null : children.get(firstWriteIndex);
        return new PredicateResults(pathToWatch, getsTheLock);
    }

    public String getLockPath() {
        String lockPath = this.readMutex.getLockPath();
        if (lockPath != null) {
            return lockPath;
        }
        return this.writeMutex.getLockPath();
    }

    private static class InternalInterProcessMutex
    extends InterProcessMutex {
        private final String lockName;
        private final byte[] lockData;

        InternalInterProcessMutex(CuratorFramework client, String path, String lockName, byte[] lockData, int maxLeases, LockInternalsDriver driver) {
            super(client, path, lockName, maxLeases, driver);
            this.lockName = lockName;
            this.lockData = lockData;
        }

        @Override
        public Collection<String> getParticipantNodes() throws Exception {
            Collection<String> nodes = super.getParticipantNodes();
            Iterable<String> filtered = Iterables.filter(nodes, new Predicate<String>(){

                @Override
                public boolean apply(String node) {
                    return node.contains(lockName);
                }
            });
            return ImmutableList.copyOf(filtered);
        }

        @Override
        protected byte[] getLockNodeBytes() {
            return this.lockData;
        }

        @Override
        public String getLockPath() {
            return super.getLockPath();
        }
    }

    private static class SortingLockInternalsDriver
    extends StandardLockInternalsDriver {
        private SortingLockInternalsDriver() {
        }

        @Override
        public final String fixForSorting(String str, String lockName) {
            str = super.fixForSorting(str, LockPathInterProcessReadWriteLock.READ_LOCK_NAME);
            str = super.fixForSorting(str, LockPathInterProcessReadWriteLock.WRITE_LOCK_NAME);
            return str;
        }
    }
}

