r"""This file is generated by setuptools-generate.
The information comes from pyproject.toml.
It provide some metainfo for docs/conf.py to build documents and
help2man to build man pages.
"""
from . import __version__  # type: ignore

# For docs/conf.py
project = r"{{ data['project']['name'] }}"
author = r"""{% for author in data['project']['authors'] -%}
{{ author['name'] }} <{{ author['email'] }}> {% endfor -%}
"""
copyright = r"2022-{{ year }}"

# For help2man
DESCRIPTION = r"{{ data['project']['description'] }}"
EPILOG = r"""Environment:
    LANG                When target_lang is "auto", will use LANG as target_lang. If LANG is empty, will use zh_CN.
    XDG_CONFIG_HOME     See https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html
    XDG_DATA_HOME       Same as above.
    XDG_DATA_DIR        Same as above.
    HOME                User's home directory.
    SHELL               User's shell.

Files:
    .../config.py       Config file can be seen by:

                        trans --print-setting config_file
    .../history.txt     History file can be seen by:

                        trans --print-setting history_file
    .../stardict/dic/   stardict dictionary directory
                        like STARDICT_DATA_DIR of sdcv(1) can be seen by:

                        trans --print-setting stardict_dirs

Examples:
    clipper | trans     Translate clipboard. Clipper can be seen by

                        trans --print-setting clipper
    trans Free as in Freedom
                        Translate by CLI.
    trans               Translate by REPL.

Report bugs to {{ data['project']['urls']['Bug Report'] -}}
"""
VERSION = (
    r"{{ data['project']['name'] }} "
    + __version__
    + r"""
Copyright (C) {{ year }}
Written by {% for author in data['project']['authors'] -%}
{{ author['name'] }} <{{ author['email'] }}> {% endfor -%}
"""
)
