import os
here = os.path.abspath(os.path.dirname(__file__))
os.environ['CLASSPATH'] = os.path.join(here, "sdk-2.17.2-uber.jar")
from jnius import autoclass, PythonJavaClass, java_method

JString = autoclass("java.lang.String")
JStandardCharsets = autoclass("java.nio.charset.StandardCharsets")

HederaReceiptStatusException = autoclass('com.hedera.hashgraph.sdk.HederaReceiptStatusException')
Delayer = autoclass('com.hedera.hashgraph.sdk.Delayer')
MaxAttemptsExceededException = autoclass('com.hedera.hashgraph.sdk.MaxAttemptsExceededException')
AccountAllowanceDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.AccountAllowanceDeleteTransaction')
EthereumTransactionData = autoclass('com.hedera.hashgraph.sdk.EthereumTransactionData')
EthereumTransactionDataEip1559 = autoclass('com.hedera.hashgraph.sdk.EthereumTransactionDataEip1559')
NftId = autoclass('com.hedera.hashgraph.sdk.NftId')
LedgerId = autoclass('com.hedera.hashgraph.sdk.LedgerId')
ContractDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.ContractDeleteTransaction')
EvmAddress = autoclass('com.hedera.hashgraph.sdk.EvmAddress')
WithExecute = autoclass('com.hedera.hashgraph.sdk.WithExecute')
TokenDissociateTransaction = autoclass('com.hedera.hashgraph.sdk.TokenDissociateTransaction')
TokenMintTransaction = autoclass('com.hedera.hashgraph.sdk.TokenMintTransaction')
FeeSchedule = autoclass('com.hedera.hashgraph.sdk.FeeSchedule')
TokenAssociation = autoclass('com.hedera.hashgraph.sdk.TokenAssociation')
AccountInfoQuery = autoclass('com.hedera.hashgraph.sdk.AccountInfoQuery')
MirrorNode = autoclass('com.hedera.hashgraph.sdk.MirrorNode')
TokenPauseTransaction = autoclass('com.hedera.hashgraph.sdk.TokenPauseTransaction')
TokenUpdateTransaction = autoclass('com.hedera.hashgraph.sdk.TokenUpdateTransaction')
SemanticVersion = autoclass('com.hedera.hashgraph.sdk.SemanticVersion')
ContractFunctionParameters = autoclass('com.hedera.hashgraph.sdk.ContractFunctionParameters')
TokenRevokeKycTransaction = autoclass('com.hedera.hashgraph.sdk.TokenRevokeKycTransaction')
PrecheckStatusException = autoclass('com.hedera.hashgraph.sdk.PrecheckStatusException')
AccountBalanceQuery = autoclass('com.hedera.hashgraph.sdk.AccountBalanceQuery')
ScheduleCreateTransaction = autoclass('com.hedera.hashgraph.sdk.ScheduleCreateTransaction')
ExecutionState = autoclass('com.hedera.hashgraph.sdk.ExecutionState')
ProxyStaker = autoclass('com.hedera.hashgraph.sdk.ProxyStaker')
WithGetCost = autoclass('com.hedera.hashgraph.sdk.WithGetCost')
TopicInfo = autoclass('com.hedera.hashgraph.sdk.TopicInfo')
TransactionReceiptQuery = autoclass('com.hedera.hashgraph.sdk.TransactionReceiptQuery')
IPv4Address = autoclass('com.hedera.hashgraph.sdk.IPv4Address')
InstantConverter = autoclass('com.hedera.hashgraph.sdk.InstantConverter')
Network = autoclass('com.hedera.hashgraph.sdk.Network')
EntityIdHelper = autoclass('com.hedera.hashgraph.sdk.EntityIdHelper')
FeeSchedules = autoclass('com.hedera.hashgraph.sdk.FeeSchedules')
PublicKeyED25519 = autoclass('com.hedera.hashgraph.sdk.PublicKeyED25519')
TokenInfoQuery = autoclass('com.hedera.hashgraph.sdk.TokenInfoQuery')
MaxQueryPaymentExceededException = autoclass('com.hedera.hashgraph.sdk.MaxQueryPaymentExceededException')
AccountUpdateTransaction = autoclass('com.hedera.hashgraph.sdk.AccountUpdateTransaction')
LiveHashAddTransaction = autoclass('com.hedera.hashgraph.sdk.LiveHashAddTransaction')
TransactionRecordQuery = autoclass('com.hedera.hashgraph.sdk.TransactionRecordQuery')
FreezeType = autoclass('com.hedera.hashgraph.sdk.FreezeType')
ThreadLocalSecureRandom = autoclass('com.hedera.hashgraph.sdk.ThreadLocalSecureRandom')
Executable = autoclass('com.hedera.hashgraph.sdk.Executable')
ContractInfo = autoclass('com.hedera.hashgraph.sdk.ContractInfo')
ContractByteCodeQuery = autoclass('com.hedera.hashgraph.sdk.ContractByteCodeQuery')
AccountId = autoclass('com.hedera.hashgraph.sdk.AccountId')
Node = autoclass('com.hedera.hashgraph.sdk.Node')
TransactionResponse = autoclass('com.hedera.hashgraph.sdk.TransactionResponse')
LockableList = autoclass('com.hedera.hashgraph.sdk.LockableList')
Query = autoclass('com.hedera.hashgraph.sdk.Query')
ManagedNodeAddress = autoclass('com.hedera.hashgraph.sdk.ManagedNodeAddress')
TokenFreezeTransaction = autoclass('com.hedera.hashgraph.sdk.TokenFreezeTransaction')
Pem = autoclass('com.hedera.hashgraph.sdk.Pem')
BadMnemonicReason = autoclass('com.hedera.hashgraph.sdk.BadMnemonicReason')
LiveHash = autoclass('com.hedera.hashgraph.sdk.LiveHash')
KeyList = autoclass('com.hedera.hashgraph.sdk.KeyList')
ContractId = autoclass('com.hedera.hashgraph.sdk.ContractId')
ContractExecuteTransaction = autoclass('com.hedera.hashgraph.sdk.ContractExecuteTransaction')
NetworkVersionInfoQuery = autoclass('com.hedera.hashgraph.sdk.NetworkVersionInfoQuery')
TopicDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.TopicDeleteTransaction')
AccountAllowanceAdjustTransaction = autoclass('com.hedera.hashgraph.sdk.AccountAllowanceAdjustTransaction')
TopicId = autoclass('com.hedera.hashgraph.sdk.TopicId')
TokenNftAllowance = autoclass('com.hedera.hashgraph.sdk.TokenNftAllowance')
WithGetRecord = autoclass('com.hedera.hashgraph.sdk.WithGetRecord')
ContractCreateFlow = autoclass('com.hedera.hashgraph.sdk.ContractCreateFlow')
TokenGrantKycTransaction = autoclass('com.hedera.hashgraph.sdk.TokenGrantKycTransaction')
SystemUndeleteTransaction = autoclass('com.hedera.hashgraph.sdk.SystemUndeleteTransaction')
FeeDataType = autoclass('com.hedera.hashgraph.sdk.FeeDataType')
PrivateKeyED25519 = autoclass('com.hedera.hashgraph.sdk.PrivateKeyED25519')
TokenCreateTransaction = autoclass('com.hedera.hashgraph.sdk.TokenCreateTransaction')
ScheduleId = autoclass('com.hedera.hashgraph.sdk.ScheduleId')
WithGetReceipt = autoclass('com.hedera.hashgraph.sdk.WithGetReceipt')
ChunkedTransaction = autoclass('com.hedera.hashgraph.sdk.ChunkedTransaction')
ContractFunctionSelector = autoclass('com.hedera.hashgraph.sdk.ContractFunctionSelector')
Crypto = autoclass('com.hedera.hashgraph.sdk.Crypto')
FileInfo = autoclass('com.hedera.hashgraph.sdk.FileInfo')
TokenTransfer = autoclass('com.hedera.hashgraph.sdk.TokenTransfer')
BadEntityIdException = autoclass('com.hedera.hashgraph.sdk.BadEntityIdException')
WithPingAll = autoclass('com.hedera.hashgraph.sdk.WithPingAll')
HederaTrustManager = autoclass('com.hedera.hashgraph.sdk.HederaTrustManager')
HederaPreCheckStatusException = autoclass('com.hedera.hashgraph.sdk.HederaPreCheckStatusException')
NetworkName = autoclass('com.hedera.hashgraph.sdk.NetworkName')
StakingInfo = autoclass('com.hedera.hashgraph.sdk.StakingInfo')
FileInfoQuery = autoclass('com.hedera.hashgraph.sdk.FileInfoQuery')
NodeAddressBook = autoclass('com.hedera.hashgraph.sdk.NodeAddressBook')
AssessedCustomFee = autoclass('com.hedera.hashgraph.sdk.AssessedCustomFee')
TokenDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.TokenDeleteTransaction')
Keystore = autoclass('com.hedera.hashgraph.sdk.Keystore')
TransferTransaction = autoclass('com.hedera.hashgraph.sdk.TransferTransaction')
EthereumTransactionDataLegacy = autoclass('com.hedera.hashgraph.sdk.EthereumTransactionDataLegacy')
TopicInfoQuery = autoclass('com.hedera.hashgraph.sdk.TopicInfoQuery')
BadKeyException = autoclass('com.hedera.hashgraph.sdk.BadKeyException')
AddressBookQuery = autoclass('com.hedera.hashgraph.sdk.AddressBookQuery')
ContractInfoQuery = autoclass('com.hedera.hashgraph.sdk.ContractInfoQuery')
ScheduleInfoQuery = autoclass('com.hedera.hashgraph.sdk.ScheduleInfoQuery')
FileDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.FileDeleteTransaction')
ContractStateChange = autoclass('com.hedera.hashgraph.sdk.ContractStateChange')
IPv4AddressPart = autoclass('com.hedera.hashgraph.sdk.IPv4AddressPart')
TokenNftTransfer = autoclass('com.hedera.hashgraph.sdk.TokenNftTransfer')
ExchangeRates = autoclass('com.hedera.hashgraph.sdk.ExchangeRates')
TopicMessageChunk = autoclass('com.hedera.hashgraph.sdk.TopicMessageChunk')
FileContentsQuery = autoclass('com.hedera.hashgraph.sdk.FileContentsQuery')
BadMnemonicException = autoclass('com.hedera.hashgraph.sdk.BadMnemonicException')
AccountBalance = autoclass('com.hedera.hashgraph.sdk.AccountBalance')
TransactionFeeSchedule = autoclass('com.hedera.hashgraph.sdk.TransactionFeeSchedule')
HbarAllowance = autoclass('com.hedera.hashgraph.sdk.HbarAllowance')
AccountCreateTransaction = autoclass('com.hedera.hashgraph.sdk.AccountCreateTransaction')
PublicKey = autoclass('com.hedera.hashgraph.sdk.PublicKey')
CustomFixedFee = autoclass('com.hedera.hashgraph.sdk.CustomFixedFee')
EthereumTransaction = autoclass('com.hedera.hashgraph.sdk.EthereumTransaction')
TokenId = autoclass('com.hedera.hashgraph.sdk.TokenId')
PrngTransaction = autoclass('com.hedera.hashgraph.sdk.PrngTransaction')
ReceiptStatusException = autoclass('com.hedera.hashgraph.sdk.ReceiptStatusException')
Endpoint = autoclass('com.hedera.hashgraph.sdk.Endpoint')
ContractCallQuery = autoclass('com.hedera.hashgraph.sdk.ContractCallQuery')
FileId = autoclass('com.hedera.hashgraph.sdk.FileId')
TokenBurnTransaction = autoclass('com.hedera.hashgraph.sdk.TokenBurnTransaction')
Client = autoclass('com.hedera.hashgraph.sdk.Client')
TokenWipeTransaction = autoclass('com.hedera.hashgraph.sdk.TokenWipeTransaction')
PrivateKeyECDSA = autoclass('com.hedera.hashgraph.sdk.PrivateKeyECDSA')
FileAppendTransaction = autoclass('com.hedera.hashgraph.sdk.FileAppendTransaction')
SystemDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.SystemDeleteTransaction')
WithPing = autoclass('com.hedera.hashgraph.sdk.WithPing')
AccountAllowanceApproveTransaction = autoclass('com.hedera.hashgraph.sdk.AccountAllowanceApproveTransaction')
TransactionReceipt = autoclass('com.hedera.hashgraph.sdk.TransactionReceipt')
StorageChange = autoclass('com.hedera.hashgraph.sdk.StorageChange')
TokenNftInfoQuery = autoclass('com.hedera.hashgraph.sdk.TokenNftInfoQuery')
TokenAssociateTransaction = autoclass('com.hedera.hashgraph.sdk.TokenAssociateTransaction')
Transfer = autoclass('com.hedera.hashgraph.sdk.Transfer')
FeeData = autoclass('com.hedera.hashgraph.sdk.FeeData')
DurationConverter = autoclass('com.hedera.hashgraph.sdk.DurationConverter')
TransactionId = autoclass('com.hedera.hashgraph.sdk.TransactionId')
TokenUnpauseTransaction = autoclass('com.hedera.hashgraph.sdk.TokenUnpauseTransaction')
FutureConverter = autoclass('com.hedera.hashgraph.sdk.FutureConverter')
ExchangeRate = autoclass('com.hedera.hashgraph.sdk.ExchangeRate')
NodeAddress = autoclass('com.hedera.hashgraph.sdk.NodeAddress')
TransactionRecord = autoclass('com.hedera.hashgraph.sdk.TransactionRecord')
AccountStakersQuery = autoclass('com.hedera.hashgraph.sdk.AccountStakersQuery')
MirrorNetwork = autoclass('com.hedera.hashgraph.sdk.MirrorNetwork')
FileCreateTransaction = autoclass('com.hedera.hashgraph.sdk.FileCreateTransaction')
TokenRelationship = autoclass('com.hedera.hashgraph.sdk.TokenRelationship')
AccountInfoFlow = autoclass('com.hedera.hashgraph.sdk.AccountInfoFlow')
CustomFractionalFee = autoclass('com.hedera.hashgraph.sdk.CustomFractionalFee')
Transaction = autoclass('com.hedera.hashgraph.sdk.Transaction')
TokenType = autoclass('com.hedera.hashgraph.sdk.TokenType')
SubscriptionHandle = autoclass('com.hedera.hashgraph.sdk.SubscriptionHandle')
ContractFunctionResult = autoclass('com.hedera.hashgraph.sdk.ContractFunctionResult')
TokenSupplyType = autoclass('com.hedera.hashgraph.sdk.TokenSupplyType')
AccountInfo = autoclass('com.hedera.hashgraph.sdk.AccountInfo')
ContractUpdateTransaction = autoclass('com.hedera.hashgraph.sdk.ContractUpdateTransaction')
TopicUpdateTransaction = autoclass('com.hedera.hashgraph.sdk.TopicUpdateTransaction')
ContractLogInfo = autoclass('com.hedera.hashgraph.sdk.ContractLogInfo')
FeeComponents = autoclass('com.hedera.hashgraph.sdk.FeeComponents')
TokenNftInfo = autoclass('com.hedera.hashgraph.sdk.TokenNftInfo')
LiveHashDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.LiveHashDeleteTransaction')
DelegateContractId = autoclass('com.hedera.hashgraph.sdk.DelegateContractId')
Status = autoclass('com.hedera.hashgraph.sdk.Status')
HbarUnit = autoclass('com.hedera.hashgraph.sdk.HbarUnit')
ScheduleSignTransaction = autoclass('com.hedera.hashgraph.sdk.ScheduleSignTransaction')
Mnemonic = autoclass('com.hedera.hashgraph.sdk.Mnemonic')
ManagedNetwork = autoclass('com.hedera.hashgraph.sdk.ManagedNetwork')
ContractCreateTransaction = autoclass('com.hedera.hashgraph.sdk.ContractCreateTransaction')
WithExecuteAll = autoclass('com.hedera.hashgraph.sdk.WithExecuteAll')
TokenAllowance = autoclass('com.hedera.hashgraph.sdk.TokenAllowance')
TokenInfo = autoclass('com.hedera.hashgraph.sdk.TokenInfo')
CustomFee = autoclass('com.hedera.hashgraph.sdk.CustomFee')
RequestType = autoclass('com.hedera.hashgraph.sdk.RequestType')
ManagedNode = autoclass('com.hedera.hashgraph.sdk.ManagedNode')
LiveHashQuery = autoclass('com.hedera.hashgraph.sdk.LiveHashQuery')
PrivateKey = autoclass('com.hedera.hashgraph.sdk.PrivateKey')
AccountRecordsQuery = autoclass('com.hedera.hashgraph.sdk.AccountRecordsQuery')
TopicMessageQuery = autoclass('com.hedera.hashgraph.sdk.TopicMessageQuery')
FreezeTransaction = autoclass('com.hedera.hashgraph.sdk.FreezeTransaction')
FileUpdateTransaction = autoclass('com.hedera.hashgraph.sdk.FileUpdateTransaction')
Hbar = autoclass('com.hedera.hashgraph.sdk.Hbar')
TokenFeeScheduleUpdateTransaction = autoclass('com.hedera.hashgraph.sdk.TokenFeeScheduleUpdateTransaction')
NetworkVersionInfo = autoclass('com.hedera.hashgraph.sdk.NetworkVersionInfo')
ScheduleDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.ScheduleDeleteTransaction')
TopicMessage = autoclass('com.hedera.hashgraph.sdk.TopicMessage')
TopicCreateTransaction = autoclass('com.hedera.hashgraph.sdk.TopicCreateTransaction')
TokenUnfreezeTransaction = autoclass('com.hedera.hashgraph.sdk.TokenUnfreezeTransaction')
FeeAssessmentMethod = autoclass('com.hedera.hashgraph.sdk.FeeAssessmentMethod')
ScheduleInfo = autoclass('com.hedera.hashgraph.sdk.ScheduleInfo')
PublicKeyECDSA = autoclass('com.hedera.hashgraph.sdk.PublicKeyECDSA')
Key = autoclass('com.hedera.hashgraph.sdk.Key')
EthereumFlow = autoclass('com.hedera.hashgraph.sdk.EthereumFlow')
AccountDeleteTransaction = autoclass('com.hedera.hashgraph.sdk.AccountDeleteTransaction')
CustomRoyaltyFee = autoclass('com.hedera.hashgraph.sdk.CustomRoyaltyFee')
TopicMessageSubmitTransaction = autoclass('com.hedera.hashgraph.sdk.TopicMessageSubmitTransaction')


class PyConsumer(PythonJavaClass):
    __javainterfaces__ = ['java/util/function/Consumer']

    def __init__(self, fn):
        self.fn = fn

    @java_method('(Ljava/lang/Object;)V')
    def accept(self, msg):
        ts = msg.consensusTimestamp.toString()
        sn = msg.sequenceNumber
        contents = JString(msg.contents, JStandardCharsets.UTF_8).toString()
        self.fn(ts, sn, contents)
