/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Arrays;
import java8.util.concurrent.CountedCompleter;
import java8.util.concurrent.RecursiveTask;

final class DualPivotQuicksort {
    private static final int MAX_MIXED_INSERTION_SORT_SIZE = 65;
    private static final int MAX_INSERTION_SORT_SIZE = 44;
    private static final int MIN_PARALLEL_SORT_SIZE = 4096;
    private static final int MIN_TRY_MERGE_SIZE = 4096;
    private static final int MIN_FIRST_RUN_SIZE = 16;
    private static final int MIN_FIRST_RUNS_FACTOR = 7;
    private static final int MAX_RUN_CAPACITY = 5120;
    private static final int MIN_RUN_COUNT = 4;
    private static final int MIN_PARALLEL_MERGE_PARTS_SIZE = 4096;
    private static final int MIN_BYTE_COUNTING_SORT_SIZE = 64;
    private static final int MIN_SHORT_OR_CHAR_COUNTING_SORT_SIZE = 1750;
    private static final int DELTA = 6;
    private static final int MAX_RECURSION_DEPTH = 384;
    private static final int NUM_BYTE_VALUES = 256;
    private static final int MAX_BYTE_INDEX = 384;
    private static final int NUM_CHAR_VALUES = 65536;
    private static final int NUM_SHORT_VALUES = 65536;
    private static final int MAX_SHORT_INDEX = 98304;

    private DualPivotQuicksort() {
    }

    private static int getDepth(int parallelism, int size) {
        int depth = 0;
        while ((parallelism >>= 3) > 0 && (size >>= 2) > 0) {
            depth -= 2;
        }
        return depth;
    }

    static void sort(int[] a, int parallelism, int low, int high) {
        int size = high - low;
        if (parallelism > 1 && size > 4096) {
            int depth = DualPivotQuicksort.getDepth(parallelism, size >> 12);
            int[] b = depth == 0 ? null : new int[size];
            new Sorter(null, a, b, low, size, low, depth).invoke();
        } else {
            DualPivotQuicksort.sort(null, a, 0, low, high);
        }
    }

    static void sort(Sorter sorter, int[] a, int bits, int low, int high) {
        while (true) {
            int t;
            int end = high - 1;
            int size = high - low;
            if (size < 65 + bits && (bits & 1) > 0) {
                DualPivotQuicksort.mixedInsertionSort(a, low, high - 3 * (size >> 5 << 3), high);
                return;
            }
            if (size < 44) {
                DualPivotQuicksort.insertionSort(a, low, high);
                return;
            }
            if ((bits == 0 || size > 4096 && (bits & 1) > 0) && DualPivotQuicksort.tryMergeRuns(sorter, a, low, size)) {
                return;
            }
            if ((bits += 6) > 384) {
                DualPivotQuicksort.heapSort(a, low, high);
                return;
            }
            int step = (size >> 3) * 3 + 3;
            int e1 = low + step;
            int e5 = end - step;
            int e3 = e1 + e5 >>> 1;
            int e2 = e1 + e3 >>> 1;
            int e4 = e3 + e5 >>> 1;
            int a3 = a[e3];
            if (a[e5] < a[e2]) {
                t = a[e5];
                a[e5] = a[e2];
                a[e2] = t;
            }
            if (a[e4] < a[e1]) {
                t = a[e4];
                a[e4] = a[e1];
                a[e1] = t;
            }
            if (a[e5] < a[e4]) {
                t = a[e5];
                a[e5] = a[e4];
                a[e4] = t;
            }
            if (a[e2] < a[e1]) {
                t = a[e2];
                a[e2] = a[e1];
                a[e1] = t;
            }
            if (a[e4] < a[e2]) {
                t = a[e4];
                a[e4] = a[e2];
                a[e2] = t;
            }
            if (a3 < a[e2]) {
                if (a3 < a[e1]) {
                    a[e3] = a[e2];
                    a[e2] = a[e1];
                    a[e1] = a3;
                } else {
                    a[e3] = a[e2];
                    a[e2] = a3;
                }
            } else if (a3 > a[e4]) {
                if (a3 > a[e5]) {
                    a[e3] = a[e4];
                    a[e4] = a[e5];
                    a[e5] = a3;
                } else {
                    a[e3] = a[e4];
                    a[e4] = a3;
                }
            }
            int lower = low;
            int upper = end;
            if (a[e1] < a[e2] && a[e2] < a[e3] && a[e3] < a[e4] && a[e4] < a[e5]) {
                int pivot1 = a[e1];
                int pivot2 = a[e5];
                a[e1] = a[lower];
                a[e5] = a[upper];
                while (a[++lower] < pivot1) {
                }
                while (a[--upper] > pivot2) {
                }
                int unused = --lower;
                int k = ++upper;
                block3: while (--k > lower) {
                    int ak = a[k];
                    if (ak < pivot1) {
                        while (lower < k) {
                            if (a[++lower] < pivot1) continue;
                            if (a[lower] > pivot2) {
                                a[k] = a[--upper];
                                a[upper] = a[lower];
                            } else {
                                a[k] = a[lower];
                            }
                            a[lower] = ak;
                            continue block3;
                        }
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    a[k] = a[--upper];
                    a[upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot1;
                a[end] = a[upper];
                a[upper] = pivot2;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, lower + 1, upper);
                    sorter.forkSorter(bits | 1, upper + 1, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, lower + 1, upper);
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper + 1, high);
                }
            } else {
                int pivot = a[e3];
                a[e3] = a[lower];
                int k = ++upper;
                while (--k > lower) {
                    int ak = a[k];
                    if (ak == pivot) continue;
                    a[k] = pivot;
                    if (ak < pivot) {
                        while (a[++lower] < pivot) {
                        }
                        if (a[lower] > pivot) {
                            a[--upper] = a[lower];
                        }
                        a[lower] = ak;
                        continue;
                    }
                    a[--upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, upper, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper, high);
                }
            }
            high = lower;
        }
    }

    private static void mixedInsertionSort(int[] a, int low, int end, int high) {
        if (end == high) {
            while (++low < end) {
                int i = low;
                int ai = a[i];
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
        } else {
            int i;
            int pin = a[end];
            int p = high;
            while (++low < end) {
                i = low;
                int ai = a[i];
                if (ai < a[i - 1]) {
                    a[i--] = a[i];
                    while (ai < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = ai;
                    continue;
                }
                if (p <= i || ai <= pin) continue;
                while (a[--p] > pin) {
                }
                if (p > i) {
                    ai = a[p];
                    a[p] = a[i];
                }
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
            while (low < high) {
                int a2;
                int a1;
                if ((a1 = a[i = low++]) > (a2 = a[low])) {
                    while (a1 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a1;
                    while (a2 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a2;
                } else if (a1 < a[i - 1]) {
                    while (a2 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a2;
                    while (a1 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a1;
                }
                ++low;
            }
        }
    }

    private static void insertionSort(int[] a, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            int ai = a[i];
            if (ai >= a[i - 1]) continue;
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
            }
            a[i + 1] = ai;
        }
    }

    private static void heapSort(int[] a, int low, int high) {
        int k = low + high >>> 1;
        while (k > low) {
            DualPivotQuicksort.pushDown(a, --k, a[k], low, high);
        }
        while (--high > low) {
            int max = a[low];
            DualPivotQuicksort.pushDown(a, low, a[high], low, high);
            a[high] = max;
        }
    }

    private static void pushDown(int[] a, int p, int value, int low, int high) {
        int k;
        while ((k = (p << 1) - low + 2) <= high) {
            if (k == high || a[k] < a[k - 1]) {
                --k;
            }
            if (a[k] <= value) break;
            int n = p;
            p = k;
            a[n] = a[p];
        }
        a[p] = value;
    }

    private static boolean tryMergeRuns(Sorter sorter, int[] a, int low, int size) {
        int[] run = null;
        int high = low + size;
        int count = 1;
        int last = low;
        int k = low + 1;
        while (k < high) {
            if (a[k - 1] < a[k]) {
                while (++k < high && a[k - 1] <= a[k]) {
                }
            } else if (a[k - 1] > a[k]) {
                while (++k < high && a[k - 1] >= a[k]) {
                }
                int i = last - 1;
                int j = k;
                while (++i < --j && a[i] > a[j]) {
                    int ai = a[i];
                    a[i] = a[j];
                    a[j] = ai;
                }
            } else {
                int ak = a[k];
                while (++k < high && ak == a[k]) {
                }
                if (k < high) continue;
            }
            if (run == null) {
                if (k == high) {
                    return true;
                }
                if (k - low < 16) {
                    return false;
                }
                run = new int[(size >> 10 | 0x7F) & 0x3FF];
                run[0] = low;
            } else if (a[last - 1] > a[last]) {
                if (count > k - low >> 7) {
                    return false;
                }
                if (++count == 5120) {
                    return false;
                }
                if (count == run.length) {
                    run = Arrays.copyOf(run, count << 1);
                }
            }
            run[count] = last = k;
        }
        if (count > 1) {
            int[] b;
            int offset = low;
            if (sorter == null || (b = (int[])sorter.b) == null) {
                b = new int[size];
            } else {
                offset = sorter.offset;
            }
            DualPivotQuicksort.mergeRuns(a, b, offset, 1, sorter != null, run, 0, count);
        }
        return true;
    }

    static int[] mergeRuns(int[] a, int[] b, int offset, int aim, boolean parallel, int[] run, int lo, int hi) {
        int hi2;
        int[] a2;
        int[] a1;
        if (hi - lo == 1) {
            if (aim >= 0) {
                return a;
            }
            int i = run[hi];
            int j = i - offset;
            int low = run[lo];
            while (i > low) {
                b[--j] = a[--i];
            }
            return b;
        }
        int mi = lo;
        int rmi = run[lo] + run[hi] >>> 1;
        while (run[++mi + 1] <= rmi) {
        }
        if (parallel && hi - lo > 4) {
            RunMerger merger = new RunMerger(a, b, offset, 0, run, mi, hi).forkMe();
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, true, run, lo, mi);
            a2 = (int[])merger.getDestination();
        } else {
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, false, run, lo, mi);
            a2 = DualPivotQuicksort.mergeRuns(a, b, offset, 0, false, run, mi, hi);
        }
        int[] dst = a1 == a ? b : a;
        int k = a1 == a ? run[lo] - offset : run[lo];
        int lo1 = a1 == b ? run[lo] - offset : run[lo];
        int hi1 = a1 == b ? run[mi] - offset : run[mi];
        int lo2 = a2 == b ? run[mi] - offset : run[mi];
        int n = hi2 = a2 == b ? run[hi] - offset : run[hi];
        if (parallel) {
            new Merger(null, dst, k, a1, lo1, hi1, a2, lo2, hi2).invoke();
        } else {
            DualPivotQuicksort.mergeParts(null, dst, k, a1, lo1, hi1, a2, lo2, hi2);
        }
        return dst;
    }

    static void mergeParts(Merger merger, int[] dst, int k, int[] a1, int lo1, int hi1, int[] a2, int lo2, int hi2) {
        if (merger != null && a1 == a2) {
            while (true) {
                if (hi1 - lo1 < hi2 - lo2) {
                    int lo = lo1;
                    lo1 = lo2;
                    lo2 = lo;
                    int hi = hi1;
                    hi1 = hi2;
                    hi2 = hi;
                }
                if (hi1 - lo1 < 4096) break;
                int mi1 = lo1 + hi1 >>> 1;
                int key = a1[mi1];
                int mi2 = hi2;
                int loo = lo2;
                while (loo < mi2) {
                    int t = loo + mi2 >>> 1;
                    if (key > a2[t]) {
                        loo = t + 1;
                        continue;
                    }
                    mi2 = t;
                }
                int d = mi2 - lo2 + mi1 - lo1;
                merger.forkMerger(dst, k + d, a1, mi1, hi1, a2, mi2, hi2);
                hi1 = mi1;
                hi2 = mi2;
            }
        }
        while (lo1 < hi1 && lo2 < hi2) {
            dst[k++] = a1[lo1] < a2[lo2] ? a1[lo1++] : a2[lo2++];
        }
        if (dst != a1 || k < lo1) {
            while (lo1 < hi1) {
                dst[k++] = a1[lo1++];
            }
        }
        if (dst != a2 || k < lo2) {
            while (lo2 < hi2) {
                dst[k++] = a2[lo2++];
            }
        }
    }

    static void sort(long[] a, int parallelism, int low, int high) {
        int size = high - low;
        if (parallelism > 1 && size > 4096) {
            int depth = DualPivotQuicksort.getDepth(parallelism, size >> 12);
            long[] b = depth == 0 ? null : new long[size];
            new Sorter(null, a, b, low, size, low, depth).invoke();
        } else {
            DualPivotQuicksort.sort(null, a, 0, low, high);
        }
    }

    static void sort(Sorter sorter, long[] a, int bits, int low, int high) {
        while (true) {
            long t;
            int end = high - 1;
            int size = high - low;
            if (size < 65 + bits && (bits & 1) > 0) {
                DualPivotQuicksort.mixedInsertionSort(a, low, high - 3 * (size >> 5 << 3), high);
                return;
            }
            if (size < 44) {
                DualPivotQuicksort.insertionSort(a, low, high);
                return;
            }
            if ((bits == 0 || size > 4096 && (bits & 1) > 0) && DualPivotQuicksort.tryMergeRuns(sorter, a, low, size)) {
                return;
            }
            if ((bits += 6) > 384) {
                DualPivotQuicksort.heapSort(a, low, high);
                return;
            }
            int step = (size >> 3) * 3 + 3;
            int e1 = low + step;
            int e5 = end - step;
            int e3 = e1 + e5 >>> 1;
            int e2 = e1 + e3 >>> 1;
            int e4 = e3 + e5 >>> 1;
            long a3 = a[e3];
            if (a[e5] < a[e2]) {
                t = a[e5];
                a[e5] = a[e2];
                a[e2] = t;
            }
            if (a[e4] < a[e1]) {
                t = a[e4];
                a[e4] = a[e1];
                a[e1] = t;
            }
            if (a[e5] < a[e4]) {
                t = a[e5];
                a[e5] = a[e4];
                a[e4] = t;
            }
            if (a[e2] < a[e1]) {
                t = a[e2];
                a[e2] = a[e1];
                a[e1] = t;
            }
            if (a[e4] < a[e2]) {
                t = a[e4];
                a[e4] = a[e2];
                a[e2] = t;
            }
            if (a3 < a[e2]) {
                if (a3 < a[e1]) {
                    a[e3] = a[e2];
                    a[e2] = a[e1];
                    a[e1] = a3;
                } else {
                    a[e3] = a[e2];
                    a[e2] = a3;
                }
            } else if (a3 > a[e4]) {
                if (a3 > a[e5]) {
                    a[e3] = a[e4];
                    a[e4] = a[e5];
                    a[e5] = a3;
                } else {
                    a[e3] = a[e4];
                    a[e4] = a3;
                }
            }
            int lower = low;
            int upper = end;
            if (a[e1] < a[e2] && a[e2] < a[e3] && a[e3] < a[e4] && a[e4] < a[e5]) {
                long pivot1 = a[e1];
                long pivot2 = a[e5];
                a[e1] = a[lower];
                a[e5] = a[upper];
                while (a[++lower] < pivot1) {
                }
                while (a[--upper] > pivot2) {
                }
                int unused = --lower;
                int k = ++upper;
                block3: while (--k > lower) {
                    long ak = a[k];
                    if (ak < pivot1) {
                        while (lower < k) {
                            if (a[++lower] < pivot1) continue;
                            if (a[lower] > pivot2) {
                                a[k] = a[--upper];
                                a[upper] = a[lower];
                            } else {
                                a[k] = a[lower];
                            }
                            a[lower] = ak;
                            continue block3;
                        }
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    a[k] = a[--upper];
                    a[upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot1;
                a[end] = a[upper];
                a[upper] = pivot2;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, lower + 1, upper);
                    sorter.forkSorter(bits | 1, upper + 1, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, lower + 1, upper);
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper + 1, high);
                }
            } else {
                long pivot = a[e3];
                a[e3] = a[lower];
                int k = ++upper;
                while (--k > lower) {
                    long ak = a[k];
                    if (ak == pivot) continue;
                    a[k] = pivot;
                    if (ak < pivot) {
                        while (a[++lower] < pivot) {
                        }
                        if (a[lower] > pivot) {
                            a[--upper] = a[lower];
                        }
                        a[lower] = ak;
                        continue;
                    }
                    a[--upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, upper, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper, high);
                }
            }
            high = lower;
        }
    }

    private static void mixedInsertionSort(long[] a, int low, int end, int high) {
        if (end == high) {
            while (++low < end) {
                int i = low;
                long ai = a[i];
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
        } else {
            int i;
            long pin = a[end];
            int p = high;
            while (++low < end) {
                i = low;
                long ai = a[i];
                if (ai < a[i - 1]) {
                    a[i--] = a[i];
                    while (ai < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = ai;
                    continue;
                }
                if (p <= i || ai <= pin) continue;
                while (a[--p] > pin) {
                }
                if (p > i) {
                    ai = a[p];
                    a[p] = a[i];
                }
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
            while (low < high) {
                long a2;
                long a1;
                if ((a1 = a[i = low++]) > (a2 = a[low])) {
                    while (a1 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a1;
                    while (a2 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a2;
                } else if (a1 < a[i - 1]) {
                    while (a2 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a2;
                    while (a1 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a1;
                }
                ++low;
            }
        }
    }

    private static void insertionSort(long[] a, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            long ai = a[i];
            if (ai >= a[i - 1]) continue;
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
            }
            a[i + 1] = ai;
        }
    }

    private static void heapSort(long[] a, int low, int high) {
        int k = low + high >>> 1;
        while (k > low) {
            DualPivotQuicksort.pushDown(a, --k, a[k], low, high);
        }
        while (--high > low) {
            long max = a[low];
            DualPivotQuicksort.pushDown(a, low, a[high], low, high);
            a[high] = max;
        }
    }

    private static void pushDown(long[] a, int p, long value, int low, int high) {
        int k;
        while ((k = (p << 1) - low + 2) <= high) {
            if (k == high || a[k] < a[k - 1]) {
                --k;
            }
            if (a[k] <= value) break;
            int n = p;
            p = k;
            a[n] = a[p];
        }
        a[p] = value;
    }

    private static boolean tryMergeRuns(Sorter sorter, long[] a, int low, int size) {
        int[] run = null;
        int high = low + size;
        int count = 1;
        int last = low;
        int k = low + 1;
        while (k < high) {
            if (a[k - 1] < a[k]) {
                while (++k < high && a[k - 1] <= a[k]) {
                }
            } else if (a[k - 1] > a[k]) {
                while (++k < high && a[k - 1] >= a[k]) {
                }
                int i = last - 1;
                int j = k;
                while (++i < --j && a[i] > a[j]) {
                    long ai = a[i];
                    a[i] = a[j];
                    a[j] = ai;
                }
            } else {
                long ak = a[k];
                while (++k < high && ak == a[k]) {
                }
                if (k < high) continue;
            }
            if (run == null) {
                if (k == high) {
                    return true;
                }
                if (k - low < 16) {
                    return false;
                }
                run = new int[(size >> 10 | 0x7F) & 0x3FF];
                run[0] = low;
            } else if (a[last - 1] > a[last]) {
                if (count > k - low >> 7) {
                    return false;
                }
                if (++count == 5120) {
                    return false;
                }
                if (count == run.length) {
                    run = Arrays.copyOf(run, count << 1);
                }
            }
            run[count] = last = k;
        }
        if (count > 1) {
            long[] b;
            int offset = low;
            if (sorter == null || (b = (long[])sorter.b) == null) {
                b = new long[size];
            } else {
                offset = sorter.offset;
            }
            DualPivotQuicksort.mergeRuns(a, b, offset, 1, sorter != null, run, 0, count);
        }
        return true;
    }

    static long[] mergeRuns(long[] a, long[] b, int offset, int aim, boolean parallel, int[] run, int lo, int hi) {
        int hi2;
        long[] a2;
        long[] a1;
        if (hi - lo == 1) {
            if (aim >= 0) {
                return a;
            }
            int i = run[hi];
            int j = i - offset;
            int low = run[lo];
            while (i > low) {
                b[--j] = a[--i];
            }
            return b;
        }
        int mi = lo;
        int rmi = run[lo] + run[hi] >>> 1;
        while (run[++mi + 1] <= rmi) {
        }
        if (parallel && hi - lo > 4) {
            RunMerger merger = new RunMerger(a, b, offset, 0, run, mi, hi).forkMe();
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, true, run, lo, mi);
            a2 = (long[])merger.getDestination();
        } else {
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, false, run, lo, mi);
            a2 = DualPivotQuicksort.mergeRuns(a, b, offset, 0, false, run, mi, hi);
        }
        long[] dst = a1 == a ? b : a;
        int k = a1 == a ? run[lo] - offset : run[lo];
        int lo1 = a1 == b ? run[lo] - offset : run[lo];
        int hi1 = a1 == b ? run[mi] - offset : run[mi];
        int lo2 = a2 == b ? run[mi] - offset : run[mi];
        int n = hi2 = a2 == b ? run[hi] - offset : run[hi];
        if (parallel) {
            new Merger(null, dst, k, a1, lo1, hi1, a2, lo2, hi2).invoke();
        } else {
            DualPivotQuicksort.mergeParts(null, dst, k, a1, lo1, hi1, a2, lo2, hi2);
        }
        return dst;
    }

    static void mergeParts(Merger merger, long[] dst, int k, long[] a1, int lo1, int hi1, long[] a2, int lo2, int hi2) {
        if (merger != null && a1 == a2) {
            while (true) {
                if (hi1 - lo1 < hi2 - lo2) {
                    int lo = lo1;
                    lo1 = lo2;
                    lo2 = lo;
                    int hi = hi1;
                    hi1 = hi2;
                    hi2 = hi;
                }
                if (hi1 - lo1 < 4096) break;
                int mi1 = lo1 + hi1 >>> 1;
                long key = a1[mi1];
                int mi2 = hi2;
                int loo = lo2;
                while (loo < mi2) {
                    int t = loo + mi2 >>> 1;
                    if (key > a2[t]) {
                        loo = t + 1;
                        continue;
                    }
                    mi2 = t;
                }
                int d = mi2 - lo2 + mi1 - lo1;
                merger.forkMerger(dst, k + d, a1, mi1, hi1, a2, mi2, hi2);
                hi1 = mi1;
                hi2 = mi2;
            }
        }
        while (lo1 < hi1 && lo2 < hi2) {
            dst[k++] = a1[lo1] < a2[lo2] ? a1[lo1++] : a2[lo2++];
        }
        if (dst != a1 || k < lo1) {
            while (lo1 < hi1) {
                dst[k++] = a1[lo1++];
            }
        }
        if (dst != a2 || k < lo2) {
            while (lo2 < hi2) {
                dst[k++] = a2[lo2++];
            }
        }
    }

    static void sort(byte[] a, int low, int high) {
        if (high - low > 64) {
            DualPivotQuicksort.countingSort(a, low, high);
        } else {
            DualPivotQuicksort.insertionSort(a, low, high);
        }
    }

    private static void insertionSort(byte[] a, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            byte ai = a[i];
            if (ai >= a[i - 1]) continue;
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
            }
            a[i + 1] = ai;
        }
    }

    private static void countingSort(byte[] a, int low, int high) {
        int[] count = new int[256];
        int i = high;
        while (i > low) {
            int n = a[--i] & 0xFF;
            count[n] = count[n] + 1;
        }
        if (high - low > 256) {
            i = 384;
            while (--i > 127) {
                int value = i & 0xFF;
                low = high - count[value];
                while (high > low) {
                    a[--high] = (byte)value;
                }
            }
        } else {
            i = 384;
            while (high > low) {
                while (count[--i & 0xFF] == 0) {
                }
                int value = i & 0xFF;
                int c = count[value];
                do {
                    a[--high] = (byte)value;
                } while (--c > 0);
            }
        }
    }

    static void sort(char[] a, int low, int high) {
        if (high - low > 1750) {
            DualPivotQuicksort.countingSort(a, low, high);
        } else {
            DualPivotQuicksort.sort(a, 0, low, high);
        }
    }

    static void sort(char[] a, int bits, int low, int high) {
        while (true) {
            char t;
            int end = high - 1;
            int size = high - low;
            if (size < 44) {
                DualPivotQuicksort.insertionSort(a, low, high);
                return;
            }
            if ((bits += 6) > 384) {
                DualPivotQuicksort.countingSort(a, low, high);
                return;
            }
            int step = (size >> 3) * 3 + 3;
            int e1 = low + step;
            int e5 = end - step;
            int e3 = e1 + e5 >>> 1;
            int e2 = e1 + e3 >>> 1;
            int e4 = e3 + e5 >>> 1;
            char a3 = a[e3];
            if (a[e5] < a[e2]) {
                t = a[e5];
                a[e5] = a[e2];
                a[e2] = t;
            }
            if (a[e4] < a[e1]) {
                t = a[e4];
                a[e4] = a[e1];
                a[e1] = t;
            }
            if (a[e5] < a[e4]) {
                t = a[e5];
                a[e5] = a[e4];
                a[e4] = t;
            }
            if (a[e2] < a[e1]) {
                t = a[e2];
                a[e2] = a[e1];
                a[e1] = t;
            }
            if (a[e4] < a[e2]) {
                t = a[e4];
                a[e4] = a[e2];
                a[e2] = t;
            }
            if (a3 < a[e2]) {
                if (a3 < a[e1]) {
                    a[e3] = a[e2];
                    a[e2] = a[e1];
                    a[e1] = a3;
                } else {
                    a[e3] = a[e2];
                    a[e2] = a3;
                }
            } else if (a3 > a[e4]) {
                if (a3 > a[e5]) {
                    a[e3] = a[e4];
                    a[e4] = a[e5];
                    a[e5] = a3;
                } else {
                    a[e3] = a[e4];
                    a[e4] = a3;
                }
            }
            int lower = low;
            int upper = end;
            if (a[e1] < a[e2] && a[e2] < a[e3] && a[e3] < a[e4] && a[e4] < a[e5]) {
                char pivot1 = a[e1];
                char pivot2 = a[e5];
                a[e1] = a[lower];
                a[e5] = a[upper];
                while (a[++lower] < pivot1) {
                }
                while (a[--upper] > pivot2) {
                }
                int unused = --lower;
                int k = ++upper;
                block3: while (--k > lower) {
                    char ak = a[k];
                    if (ak < pivot1) {
                        while (lower < k) {
                            if (a[++lower] < pivot1) continue;
                            if (a[lower] > pivot2) {
                                a[k] = a[--upper];
                                a[upper] = a[lower];
                            } else {
                                a[k] = a[lower];
                            }
                            a[lower] = ak;
                            continue block3;
                        }
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    a[k] = a[--upper];
                    a[upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot1;
                a[end] = a[upper];
                a[upper] = pivot2;
                DualPivotQuicksort.sort(a, bits | 1, lower + 1, upper);
                DualPivotQuicksort.sort(a, bits | 1, upper + 1, high);
            } else {
                char pivot = a[e3];
                a[e3] = a[lower];
                int k = ++upper;
                while (--k > lower) {
                    char ak = a[k];
                    if (ak == pivot) continue;
                    a[k] = pivot;
                    if (ak < pivot) {
                        while (a[++lower] < pivot) {
                        }
                        if (a[lower] > pivot) {
                            a[--upper] = a[lower];
                        }
                        a[lower] = ak;
                        continue;
                    }
                    a[--upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot;
                DualPivotQuicksort.sort(a, bits | 1, upper, high);
            }
            high = lower;
        }
    }

    private static void insertionSort(char[] a, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            char ai = a[i];
            if (ai >= a[i - 1]) continue;
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
            }
            a[i + 1] = ai;
        }
    }

    private static void countingSort(char[] a, int low, int high) {
        int[] count = new int[65536];
        int i = high;
        while (i > low) {
            char c = a[--i];
            count[c] = count[c] + 1;
        }
        if (high - low > 65536) {
            i = 65536;
            while (i > 0) {
                low = high - count[--i];
                while (high > low) {
                    a[--high] = (char)i;
                }
            }
        } else {
            i = 65536;
            while (high > low) {
                while (count[--i] == 0) {
                }
                int c = count[i];
                do {
                    a[--high] = (char)i;
                } while (--c > 0);
            }
        }
    }

    static void sort(short[] a, int low, int high) {
        if (high - low > 1750) {
            DualPivotQuicksort.countingSort(a, low, high);
        } else {
            DualPivotQuicksort.sort(a, 0, low, high);
        }
    }

    static void sort(short[] a, int bits, int low, int high) {
        while (true) {
            short t;
            int end = high - 1;
            int size = high - low;
            if (size < 44) {
                DualPivotQuicksort.insertionSort(a, low, high);
                return;
            }
            if ((bits += 6) > 384) {
                DualPivotQuicksort.countingSort(a, low, high);
                return;
            }
            int step = (size >> 3) * 3 + 3;
            int e1 = low + step;
            int e5 = end - step;
            int e3 = e1 + e5 >>> 1;
            int e2 = e1 + e3 >>> 1;
            int e4 = e3 + e5 >>> 1;
            short a3 = a[e3];
            if (a[e5] < a[e2]) {
                t = a[e5];
                a[e5] = a[e2];
                a[e2] = t;
            }
            if (a[e4] < a[e1]) {
                t = a[e4];
                a[e4] = a[e1];
                a[e1] = t;
            }
            if (a[e5] < a[e4]) {
                t = a[e5];
                a[e5] = a[e4];
                a[e4] = t;
            }
            if (a[e2] < a[e1]) {
                t = a[e2];
                a[e2] = a[e1];
                a[e1] = t;
            }
            if (a[e4] < a[e2]) {
                t = a[e4];
                a[e4] = a[e2];
                a[e2] = t;
            }
            if (a3 < a[e2]) {
                if (a3 < a[e1]) {
                    a[e3] = a[e2];
                    a[e2] = a[e1];
                    a[e1] = a3;
                } else {
                    a[e3] = a[e2];
                    a[e2] = a3;
                }
            } else if (a3 > a[e4]) {
                if (a3 > a[e5]) {
                    a[e3] = a[e4];
                    a[e4] = a[e5];
                    a[e5] = a3;
                } else {
                    a[e3] = a[e4];
                    a[e4] = a3;
                }
            }
            int lower = low;
            int upper = end;
            if (a[e1] < a[e2] && a[e2] < a[e3] && a[e3] < a[e4] && a[e4] < a[e5]) {
                short pivot1 = a[e1];
                short pivot2 = a[e5];
                a[e1] = a[lower];
                a[e5] = a[upper];
                while (a[++lower] < pivot1) {
                }
                while (a[--upper] > pivot2) {
                }
                int unused = --lower;
                int k = ++upper;
                block3: while (--k > lower) {
                    short ak = a[k];
                    if (ak < pivot1) {
                        while (lower < k) {
                            if (a[++lower] < pivot1) continue;
                            if (a[lower] > pivot2) {
                                a[k] = a[--upper];
                                a[upper] = a[lower];
                            } else {
                                a[k] = a[lower];
                            }
                            a[lower] = ak;
                            continue block3;
                        }
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    a[k] = a[--upper];
                    a[upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot1;
                a[end] = a[upper];
                a[upper] = pivot2;
                DualPivotQuicksort.sort(a, bits | 1, lower + 1, upper);
                DualPivotQuicksort.sort(a, bits | 1, upper + 1, high);
            } else {
                short pivot = a[e3];
                a[e3] = a[lower];
                int k = ++upper;
                while (--k > lower) {
                    short ak = a[k];
                    if (ak == pivot) continue;
                    a[k] = pivot;
                    if (ak < pivot) {
                        while (a[++lower] < pivot) {
                        }
                        if (a[lower] > pivot) {
                            a[--upper] = a[lower];
                        }
                        a[lower] = ak;
                        continue;
                    }
                    a[--upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot;
                DualPivotQuicksort.sort(a, bits | 1, upper, high);
            }
            high = lower;
        }
    }

    private static void insertionSort(short[] a, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            short ai = a[i];
            if (ai >= a[i - 1]) continue;
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
            }
            a[i + 1] = ai;
        }
    }

    private static void countingSort(short[] a, int low, int high) {
        int[] count = new int[65536];
        int i = high;
        while (i > low) {
            int n = a[--i] & 0xFFFF;
            count[n] = count[n] + 1;
        }
        if (high - low > 65536) {
            i = 98304;
            while (--i > Short.MAX_VALUE) {
                int value = i & 0xFFFF;
                low = high - count[value];
                while (high > low) {
                    a[--high] = (short)value;
                }
            }
        } else {
            i = 98304;
            while (high > low) {
                while (count[--i & 0xFFFF] == 0) {
                }
                int value = i & 0xFFFF;
                int c = count[value];
                do {
                    a[--high] = (short)value;
                } while (--c > 0);
            }
        }
    }

    static void sort(float[] a, int parallelism, int low, int high) {
        int numNegativeZero = 0;
        int k = high;
        while (k > low) {
            float ak;
            if ((ak = a[--k]) == 0.0f && Float.floatToRawIntBits(ak) < 0) {
                ++numNegativeZero;
                a[k] = 0.0f;
                continue;
            }
            if (!Float.isNaN(ak)) continue;
            a[k] = a[--high];
            a[high] = ak;
        }
        int size = high - low;
        if (parallelism > 1 && size > 4096) {
            int depth = DualPivotQuicksort.getDepth(parallelism, size >> 12);
            float[] b = depth == 0 ? null : new float[size];
            new Sorter(null, a, b, low, size, low, depth).invoke();
        } else {
            DualPivotQuicksort.sort(null, a, 0, low, high);
        }
        if (++numNegativeZero == 1) {
            return;
        }
        while (low <= high) {
            int middle = low + high >>> 1;
            if (a[middle] < 0.0f) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        while (--numNegativeZero > 0) {
            a[++high] = -0.0f;
        }
    }

    static void sort(Sorter sorter, float[] a, int bits, int low, int high) {
        while (true) {
            float t;
            int end = high - 1;
            int size = high - low;
            if (size < 65 + bits && (bits & 1) > 0) {
                DualPivotQuicksort.mixedInsertionSort(a, low, high - 3 * (size >> 5 << 3), high);
                return;
            }
            if (size < 44) {
                DualPivotQuicksort.insertionSort(a, low, high);
                return;
            }
            if ((bits == 0 || size > 4096 && (bits & 1) > 0) && DualPivotQuicksort.tryMergeRuns(sorter, a, low, size)) {
                return;
            }
            if ((bits += 6) > 384) {
                DualPivotQuicksort.heapSort(a, low, high);
                return;
            }
            int step = (size >> 3) * 3 + 3;
            int e1 = low + step;
            int e5 = end - step;
            int e3 = e1 + e5 >>> 1;
            int e2 = e1 + e3 >>> 1;
            int e4 = e3 + e5 >>> 1;
            float a3 = a[e3];
            if (a[e5] < a[e2]) {
                t = a[e5];
                a[e5] = a[e2];
                a[e2] = t;
            }
            if (a[e4] < a[e1]) {
                t = a[e4];
                a[e4] = a[e1];
                a[e1] = t;
            }
            if (a[e5] < a[e4]) {
                t = a[e5];
                a[e5] = a[e4];
                a[e4] = t;
            }
            if (a[e2] < a[e1]) {
                t = a[e2];
                a[e2] = a[e1];
                a[e1] = t;
            }
            if (a[e4] < a[e2]) {
                t = a[e4];
                a[e4] = a[e2];
                a[e2] = t;
            }
            if (a3 < a[e2]) {
                if (a3 < a[e1]) {
                    a[e3] = a[e2];
                    a[e2] = a[e1];
                    a[e1] = a3;
                } else {
                    a[e3] = a[e2];
                    a[e2] = a3;
                }
            } else if (a3 > a[e4]) {
                if (a3 > a[e5]) {
                    a[e3] = a[e4];
                    a[e4] = a[e5];
                    a[e5] = a3;
                } else {
                    a[e3] = a[e4];
                    a[e4] = a3;
                }
            }
            int lower = low;
            int upper = end;
            if (a[e1] < a[e2] && a[e2] < a[e3] && a[e3] < a[e4] && a[e4] < a[e5]) {
                float pivot1 = a[e1];
                float pivot2 = a[e5];
                a[e1] = a[lower];
                a[e5] = a[upper];
                while (a[++lower] < pivot1) {
                }
                while (a[--upper] > pivot2) {
                }
                int unused = --lower;
                int k = ++upper;
                block3: while (--k > lower) {
                    float ak = a[k];
                    if (ak < pivot1) {
                        while (lower < k) {
                            if (!(a[++lower] >= pivot1)) continue;
                            if (a[lower] > pivot2) {
                                a[k] = a[--upper];
                                a[upper] = a[lower];
                            } else {
                                a[k] = a[lower];
                            }
                            a[lower] = ak;
                            continue block3;
                        }
                        continue;
                    }
                    if (!(ak > pivot2)) continue;
                    a[k] = a[--upper];
                    a[upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot1;
                a[end] = a[upper];
                a[upper] = pivot2;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, lower + 1, upper);
                    sorter.forkSorter(bits | 1, upper + 1, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, lower + 1, upper);
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper + 1, high);
                }
            } else {
                float pivot = a[e3];
                a[e3] = a[lower];
                int k = ++upper;
                while (--k > lower) {
                    float ak = a[k];
                    if (ak == pivot) continue;
                    a[k] = pivot;
                    if (ak < pivot) {
                        while (a[++lower] < pivot) {
                        }
                        if (a[lower] > pivot) {
                            a[--upper] = a[lower];
                        }
                        a[lower] = ak;
                        continue;
                    }
                    a[--upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, upper, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper, high);
                }
            }
            high = lower;
        }
    }

    private static void mixedInsertionSort(float[] a, int low, int end, int high) {
        if (end == high) {
            while (++low < end) {
                int i = low;
                float ai = a[i];
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
        } else {
            int i;
            float pin = a[end];
            int p = high;
            while (++low < end) {
                i = low;
                float ai = a[i];
                if (ai < a[i - 1]) {
                    a[i--] = a[i];
                    while (ai < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = ai;
                    continue;
                }
                if (p <= i || !(ai > pin)) continue;
                while (a[--p] > pin) {
                }
                if (p > i) {
                    ai = a[p];
                    a[p] = a[i];
                }
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
            while (low < high) {
                float a2;
                float a1;
                if ((a1 = a[i = low++]) > (a2 = a[low])) {
                    while (a1 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a1;
                    while (a2 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a2;
                } else if (a1 < a[i - 1]) {
                    while (a2 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a2;
                    while (a1 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a1;
                }
                ++low;
            }
        }
    }

    private static void insertionSort(float[] a, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            float ai = a[i];
            if (!(ai < a[i - 1])) continue;
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
            }
            a[i + 1] = ai;
        }
    }

    private static void heapSort(float[] a, int low, int high) {
        int k = low + high >>> 1;
        while (k > low) {
            DualPivotQuicksort.pushDown(a, --k, a[k], low, high);
        }
        while (--high > low) {
            float max = a[low];
            DualPivotQuicksort.pushDown(a, low, a[high], low, high);
            a[high] = max;
        }
    }

    private static void pushDown(float[] a, int p, float value, int low, int high) {
        int k;
        while ((k = (p << 1) - low + 2) <= high) {
            if (k == high || a[k] < a[k - 1]) {
                --k;
            }
            if (a[k] <= value) break;
            int n = p;
            p = k;
            a[n] = a[p];
        }
        a[p] = value;
    }

    private static boolean tryMergeRuns(Sorter sorter, float[] a, int low, int size) {
        int[] run = null;
        int high = low + size;
        int count = 1;
        int last = low;
        int k = low + 1;
        while (k < high) {
            if (a[k - 1] < a[k]) {
                while (++k < high && a[k - 1] <= a[k]) {
                }
            } else if (a[k - 1] > a[k]) {
                while (++k < high && a[k - 1] >= a[k]) {
                }
                int i = last - 1;
                int j = k;
                while (++i < --j && a[i] > a[j]) {
                    float ai = a[i];
                    a[i] = a[j];
                    a[j] = ai;
                }
            } else {
                float ak = a[k];
                while (++k < high && ak == a[k]) {
                }
                if (k < high) continue;
            }
            if (run == null) {
                if (k == high) {
                    return true;
                }
                if (k - low < 16) {
                    return false;
                }
                run = new int[(size >> 10 | 0x7F) & 0x3FF];
                run[0] = low;
            } else if (a[last - 1] > a[last]) {
                if (count > k - low >> 7) {
                    return false;
                }
                if (++count == 5120) {
                    return false;
                }
                if (count == run.length) {
                    run = Arrays.copyOf(run, count << 1);
                }
            }
            run[count] = last = k;
        }
        if (count > 1) {
            float[] b;
            int offset = low;
            if (sorter == null || (b = (float[])sorter.b) == null) {
                b = new float[size];
            } else {
                offset = sorter.offset;
            }
            DualPivotQuicksort.mergeRuns(a, b, offset, 1, sorter != null, run, 0, count);
        }
        return true;
    }

    static float[] mergeRuns(float[] a, float[] b, int offset, int aim, boolean parallel, int[] run, int lo, int hi) {
        int hi2;
        float[] a2;
        float[] a1;
        if (hi - lo == 1) {
            if (aim >= 0) {
                return a;
            }
            int i = run[hi];
            int j = i - offset;
            int low = run[lo];
            while (i > low) {
                b[--j] = a[--i];
            }
            return b;
        }
        int mi = lo;
        int rmi = run[lo] + run[hi] >>> 1;
        while (run[++mi + 1] <= rmi) {
        }
        if (parallel && hi - lo > 4) {
            RunMerger merger = new RunMerger(a, b, offset, 0, run, mi, hi).forkMe();
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, true, run, lo, mi);
            a2 = (float[])merger.getDestination();
        } else {
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, false, run, lo, mi);
            a2 = DualPivotQuicksort.mergeRuns(a, b, offset, 0, false, run, mi, hi);
        }
        float[] dst = a1 == a ? b : a;
        int k = a1 == a ? run[lo] - offset : run[lo];
        int lo1 = a1 == b ? run[lo] - offset : run[lo];
        int hi1 = a1 == b ? run[mi] - offset : run[mi];
        int lo2 = a2 == b ? run[mi] - offset : run[mi];
        int n = hi2 = a2 == b ? run[hi] - offset : run[hi];
        if (parallel) {
            new Merger(null, dst, k, a1, lo1, hi1, a2, lo2, hi2).invoke();
        } else {
            DualPivotQuicksort.mergeParts(null, dst, k, a1, lo1, hi1, a2, lo2, hi2);
        }
        return dst;
    }

    static void mergeParts(Merger merger, float[] dst, int k, float[] a1, int lo1, int hi1, float[] a2, int lo2, int hi2) {
        if (merger != null && a1 == a2) {
            while (true) {
                if (hi1 - lo1 < hi2 - lo2) {
                    int lo = lo1;
                    lo1 = lo2;
                    lo2 = lo;
                    int hi = hi1;
                    hi1 = hi2;
                    hi2 = hi;
                }
                if (hi1 - lo1 < 4096) break;
                int mi1 = lo1 + hi1 >>> 1;
                float key = a1[mi1];
                int mi2 = hi2;
                int loo = lo2;
                while (loo < mi2) {
                    int t = loo + mi2 >>> 1;
                    if (key > a2[t]) {
                        loo = t + 1;
                        continue;
                    }
                    mi2 = t;
                }
                int d = mi2 - lo2 + mi1 - lo1;
                merger.forkMerger(dst, k + d, a1, mi1, hi1, a2, mi2, hi2);
                hi1 = mi1;
                hi2 = mi2;
            }
        }
        while (lo1 < hi1 && lo2 < hi2) {
            dst[k++] = a1[lo1] < a2[lo2] ? a1[lo1++] : a2[lo2++];
        }
        if (dst != a1 || k < lo1) {
            while (lo1 < hi1) {
                dst[k++] = a1[lo1++];
            }
        }
        if (dst != a2 || k < lo2) {
            while (lo2 < hi2) {
                dst[k++] = a2[lo2++];
            }
        }
    }

    static void sort(double[] a, int parallelism, int low, int high) {
        int numNegativeZero = 0;
        int k = high;
        while (k > low) {
            double ak;
            if ((ak = a[--k]) == 0.0 && Double.doubleToRawLongBits(ak) < 0L) {
                ++numNegativeZero;
                a[k] = 0.0;
                continue;
            }
            if (!Double.isNaN(ak)) continue;
            a[k] = a[--high];
            a[high] = ak;
        }
        int size = high - low;
        if (parallelism > 1 && size > 4096) {
            int depth = DualPivotQuicksort.getDepth(parallelism, size >> 12);
            double[] b = depth == 0 ? null : new double[size];
            new Sorter(null, a, b, low, size, low, depth).invoke();
        } else {
            DualPivotQuicksort.sort(null, a, 0, low, high);
        }
        if (++numNegativeZero == 1) {
            return;
        }
        while (low <= high) {
            int middle = low + high >>> 1;
            if (a[middle] < 0.0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        while (--numNegativeZero > 0) {
            a[++high] = -0.0;
        }
    }

    static void sort(Sorter sorter, double[] a, int bits, int low, int high) {
        while (true) {
            double t;
            int end = high - 1;
            int size = high - low;
            if (size < 65 + bits && (bits & 1) > 0) {
                DualPivotQuicksort.mixedInsertionSort(a, low, high - 3 * (size >> 5 << 3), high);
                return;
            }
            if (size < 44) {
                DualPivotQuicksort.insertionSort(a, low, high);
                return;
            }
            if ((bits == 0 || size > 4096 && (bits & 1) > 0) && DualPivotQuicksort.tryMergeRuns(sorter, a, low, size)) {
                return;
            }
            if ((bits += 6) > 384) {
                DualPivotQuicksort.heapSort(a, low, high);
                return;
            }
            int step = (size >> 3) * 3 + 3;
            int e1 = low + step;
            int e5 = end - step;
            int e3 = e1 + e5 >>> 1;
            int e2 = e1 + e3 >>> 1;
            int e4 = e3 + e5 >>> 1;
            double a3 = a[e3];
            if (a[e5] < a[e2]) {
                t = a[e5];
                a[e5] = a[e2];
                a[e2] = t;
            }
            if (a[e4] < a[e1]) {
                t = a[e4];
                a[e4] = a[e1];
                a[e1] = t;
            }
            if (a[e5] < a[e4]) {
                t = a[e5];
                a[e5] = a[e4];
                a[e4] = t;
            }
            if (a[e2] < a[e1]) {
                t = a[e2];
                a[e2] = a[e1];
                a[e1] = t;
            }
            if (a[e4] < a[e2]) {
                t = a[e4];
                a[e4] = a[e2];
                a[e2] = t;
            }
            if (a3 < a[e2]) {
                if (a3 < a[e1]) {
                    a[e3] = a[e2];
                    a[e2] = a[e1];
                    a[e1] = a3;
                } else {
                    a[e3] = a[e2];
                    a[e2] = a3;
                }
            } else if (a3 > a[e4]) {
                if (a3 > a[e5]) {
                    a[e3] = a[e4];
                    a[e4] = a[e5];
                    a[e5] = a3;
                } else {
                    a[e3] = a[e4];
                    a[e4] = a3;
                }
            }
            int lower = low;
            int upper = end;
            if (a[e1] < a[e2] && a[e2] < a[e3] && a[e3] < a[e4] && a[e4] < a[e5]) {
                double pivot1 = a[e1];
                double pivot2 = a[e5];
                a[e1] = a[lower];
                a[e5] = a[upper];
                while (a[++lower] < pivot1) {
                }
                while (a[--upper] > pivot2) {
                }
                int unused = --lower;
                int k = ++upper;
                block3: while (--k > lower) {
                    double ak = a[k];
                    if (ak < pivot1) {
                        while (lower < k) {
                            if (!(a[++lower] >= pivot1)) continue;
                            if (a[lower] > pivot2) {
                                a[k] = a[--upper];
                                a[upper] = a[lower];
                            } else {
                                a[k] = a[lower];
                            }
                            a[lower] = ak;
                            continue block3;
                        }
                        continue;
                    }
                    if (!(ak > pivot2)) continue;
                    a[k] = a[--upper];
                    a[upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot1;
                a[end] = a[upper];
                a[upper] = pivot2;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, lower + 1, upper);
                    sorter.forkSorter(bits | 1, upper + 1, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, lower + 1, upper);
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper + 1, high);
                }
            } else {
                double pivot = a[e3];
                a[e3] = a[lower];
                int k = ++upper;
                while (--k > lower) {
                    double ak = a[k];
                    if (ak == pivot) continue;
                    a[k] = pivot;
                    if (ak < pivot) {
                        while (a[++lower] < pivot) {
                        }
                        if (a[lower] > pivot) {
                            a[--upper] = a[lower];
                        }
                        a[lower] = ak;
                        continue;
                    }
                    a[--upper] = ak;
                }
                a[low] = a[lower];
                a[lower] = pivot;
                if (size > 4096 && sorter != null) {
                    sorter.forkSorter(bits | 1, upper, high);
                } else {
                    DualPivotQuicksort.sort(sorter, a, bits | 1, upper, high);
                }
            }
            high = lower;
        }
    }

    private static void mixedInsertionSort(double[] a, int low, int end, int high) {
        if (end == high) {
            while (++low < end) {
                int i = low;
                double ai = a[i];
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
        } else {
            int i;
            double pin = a[end];
            int p = high;
            while (++low < end) {
                i = low;
                double ai = a[i];
                if (ai < a[i - 1]) {
                    a[i--] = a[i];
                    while (ai < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = ai;
                    continue;
                }
                if (p <= i || !(ai > pin)) continue;
                while (a[--p] > pin) {
                }
                if (p > i) {
                    ai = a[p];
                    a[p] = a[i];
                }
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                }
                a[i + 1] = ai;
            }
            while (low < high) {
                double a2;
                double a1;
                if ((a1 = a[i = low++]) > (a2 = a[low])) {
                    while (a1 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a1;
                    while (a2 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a2;
                } else if (a1 < a[i - 1]) {
                    while (a2 < a[--i]) {
                        a[i + 2] = a[i];
                    }
                    a[++i + 1] = a2;
                    while (a1 < a[--i]) {
                        a[i + 1] = a[i];
                    }
                    a[i + 1] = a1;
                }
                ++low;
            }
        }
    }

    private static void insertionSort(double[] a, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            double ai = a[i];
            if (!(ai < a[i - 1])) continue;
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
            }
            a[i + 1] = ai;
        }
    }

    private static void heapSort(double[] a, int low, int high) {
        int k = low + high >>> 1;
        while (k > low) {
            DualPivotQuicksort.pushDown(a, --k, a[k], low, high);
        }
        while (--high > low) {
            double max = a[low];
            DualPivotQuicksort.pushDown(a, low, a[high], low, high);
            a[high] = max;
        }
    }

    private static void pushDown(double[] a, int p, double value, int low, int high) {
        int k;
        while ((k = (p << 1) - low + 2) <= high) {
            if (k == high || a[k] < a[k - 1]) {
                --k;
            }
            if (a[k] <= value) break;
            int n = p;
            p = k;
            a[n] = a[p];
        }
        a[p] = value;
    }

    private static boolean tryMergeRuns(Sorter sorter, double[] a, int low, int size) {
        int[] run = null;
        int high = low + size;
        int count = 1;
        int last = low;
        int k = low + 1;
        while (k < high) {
            if (a[k - 1] < a[k]) {
                while (++k < high && a[k - 1] <= a[k]) {
                }
            } else if (a[k - 1] > a[k]) {
                while (++k < high && a[k - 1] >= a[k]) {
                }
                int i = last - 1;
                int j = k;
                while (++i < --j && a[i] > a[j]) {
                    double ai = a[i];
                    a[i] = a[j];
                    a[j] = ai;
                }
            } else {
                double ak = a[k];
                while (++k < high && ak == a[k]) {
                }
                if (k < high) continue;
            }
            if (run == null) {
                if (k == high) {
                    return true;
                }
                if (k - low < 16) {
                    return false;
                }
                run = new int[(size >> 10 | 0x7F) & 0x3FF];
                run[0] = low;
            } else if (a[last - 1] > a[last]) {
                if (count > k - low >> 7) {
                    return false;
                }
                if (++count == 5120) {
                    return false;
                }
                if (count == run.length) {
                    run = Arrays.copyOf(run, count << 1);
                }
            }
            run[count] = last = k;
        }
        if (count > 1) {
            double[] b;
            int offset = low;
            if (sorter == null || (b = (double[])sorter.b) == null) {
                b = new double[size];
            } else {
                offset = sorter.offset;
            }
            DualPivotQuicksort.mergeRuns(a, b, offset, 1, sorter != null, run, 0, count);
        }
        return true;
    }

    static double[] mergeRuns(double[] a, double[] b, int offset, int aim, boolean parallel, int[] run, int lo, int hi) {
        int hi2;
        double[] a2;
        double[] a1;
        if (hi - lo == 1) {
            if (aim >= 0) {
                return a;
            }
            int i = run[hi];
            int j = i - offset;
            int low = run[lo];
            while (i > low) {
                b[--j] = a[--i];
            }
            return b;
        }
        int mi = lo;
        int rmi = run[lo] + run[hi] >>> 1;
        while (run[++mi + 1] <= rmi) {
        }
        if (parallel && hi - lo > 4) {
            RunMerger merger = new RunMerger(a, b, offset, 0, run, mi, hi).forkMe();
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, true, run, lo, mi);
            a2 = (double[])merger.getDestination();
        } else {
            a1 = DualPivotQuicksort.mergeRuns(a, b, offset, -aim, false, run, lo, mi);
            a2 = DualPivotQuicksort.mergeRuns(a, b, offset, 0, false, run, mi, hi);
        }
        double[] dst = a1 == a ? b : a;
        int k = a1 == a ? run[lo] - offset : run[lo];
        int lo1 = a1 == b ? run[lo] - offset : run[lo];
        int hi1 = a1 == b ? run[mi] - offset : run[mi];
        int lo2 = a2 == b ? run[mi] - offset : run[mi];
        int n = hi2 = a2 == b ? run[hi] - offset : run[hi];
        if (parallel) {
            new Merger(null, dst, k, a1, lo1, hi1, a2, lo2, hi2).invoke();
        } else {
            DualPivotQuicksort.mergeParts(null, dst, k, a1, lo1, hi1, a2, lo2, hi2);
        }
        return dst;
    }

    static void mergeParts(Merger merger, double[] dst, int k, double[] a1, int lo1, int hi1, double[] a2, int lo2, int hi2) {
        if (merger != null && a1 == a2) {
            while (true) {
                if (hi1 - lo1 < hi2 - lo2) {
                    int lo = lo1;
                    lo1 = lo2;
                    lo2 = lo;
                    int hi = hi1;
                    hi1 = hi2;
                    hi2 = hi;
                }
                if (hi1 - lo1 < 4096) break;
                int mi1 = lo1 + hi1 >>> 1;
                double key = a1[mi1];
                int mi2 = hi2;
                int loo = lo2;
                while (loo < mi2) {
                    int t = loo + mi2 >>> 1;
                    if (key > a2[t]) {
                        loo = t + 1;
                        continue;
                    }
                    mi2 = t;
                }
                int d = mi2 - lo2 + mi1 - lo1;
                merger.forkMerger(dst, k + d, a1, mi1, hi1, a2, mi2, hi2);
                hi1 = mi1;
                hi2 = mi2;
            }
        }
        while (lo1 < hi1 && lo2 < hi2) {
            dst[k++] = a1[lo1] < a2[lo2] ? a1[lo1++] : a2[lo2++];
        }
        if (dst != a1 || k < lo1) {
            while (lo1 < hi1) {
                dst[k++] = a1[lo1++];
            }
        }
        if (dst != a2 || k < lo2) {
            while (lo2 < hi2) {
                dst[k++] = a2[lo2++];
            }
        }
    }

    private static final class RunMerger
    extends RecursiveTask<Object> {
        private static final long serialVersionUID = 20180818L;
        private final Object a;
        private final Object b;
        private final int[] run;
        private final int offset;
        private final int aim;
        private final int lo;
        private final int hi;

        RunMerger(Object a, Object b, int offset, int aim, int[] run, int lo, int hi) {
            this.a = a;
            this.b = b;
            this.offset = offset;
            this.aim = aim;
            this.run = run;
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        protected final Object compute() {
            if (this.a instanceof int[]) {
                return DualPivotQuicksort.mergeRuns((int[])this.a, (int[])this.b, this.offset, this.aim, true, this.run, this.lo, this.hi);
            }
            if (this.a instanceof long[]) {
                return DualPivotQuicksort.mergeRuns((long[])this.a, (long[])this.b, this.offset, this.aim, true, this.run, this.lo, this.hi);
            }
            if (this.a instanceof float[]) {
                return DualPivotQuicksort.mergeRuns((float[])this.a, (float[])this.b, this.offset, this.aim, true, this.run, this.lo, this.hi);
            }
            if (this.a instanceof double[]) {
                return DualPivotQuicksort.mergeRuns((double[])this.a, (double[])this.b, this.offset, this.aim, true, this.run, this.lo, this.hi);
            }
            throw new IllegalArgumentException("Unknown type of array: " + this.a.getClass().getName());
        }

        RunMerger forkMe() {
            this.fork();
            return this;
        }

        Object getDestination() {
            this.join();
            return this.getRawResult();
        }
    }

    private static final class Merger
    extends CountedCompleter<Void> {
        private static final long serialVersionUID = 20180818L;
        private final Object dst;
        private final Object a1;
        private final Object a2;
        private final int k;
        private final int lo1;
        private final int hi1;
        private final int lo2;
        private final int hi2;

        Merger(CountedCompleter<?> parent, Object dst, int k, Object a1, int lo1, int hi1, Object a2, int lo2, int hi2) {
            super(parent);
            this.dst = dst;
            this.k = k;
            this.a1 = a1;
            this.lo1 = lo1;
            this.hi1 = hi1;
            this.a2 = a2;
            this.lo2 = lo2;
            this.hi2 = hi2;
        }

        @Override
        public final void compute() {
            if (this.dst instanceof int[]) {
                DualPivotQuicksort.mergeParts(this, (int[])this.dst, this.k, (int[])this.a1, this.lo1, this.hi1, (int[])this.a2, this.lo2, this.hi2);
            } else if (this.dst instanceof long[]) {
                DualPivotQuicksort.mergeParts(this, (long[])this.dst, this.k, (long[])this.a1, this.lo1, this.hi1, (long[])this.a2, this.lo2, this.hi2);
            } else if (this.dst instanceof float[]) {
                DualPivotQuicksort.mergeParts(this, (float[])this.dst, this.k, (float[])this.a1, this.lo1, this.hi1, (float[])this.a2, this.lo2, this.hi2);
            } else if (this.dst instanceof double[]) {
                DualPivotQuicksort.mergeParts(this, (double[])this.dst, this.k, (double[])this.a1, this.lo1, this.hi1, (double[])this.a2, this.lo2, this.hi2);
            } else {
                throw new IllegalArgumentException("Unknown type of array: " + this.dst.getClass().getName());
            }
            this.propagateCompletion();
        }

        void forkMerger(Object dst, int k, Object a1, int lo1, int hi1, Object a2, int lo2, int hi2) {
            this.addToPendingCount(1);
            new Merger(this, dst, k, a1, lo1, hi1, a2, lo2, hi2).fork();
        }
    }

    private static final class Sorter
    extends CountedCompleter<Void> {
        private static final long serialVersionUID = 20180818L;
        final Object a;
        final Object b;
        final int low;
        final int size;
        final int offset;
        final int depth;

        Sorter(CountedCompleter<?> parent, Object a, Object b, int low, int size, int offset, int depth) {
            super(parent);
            this.a = a;
            this.b = b;
            this.low = low;
            this.size = size;
            this.offset = offset;
            this.depth = depth;
        }

        @Override
        public final void compute() {
            if (this.depth < 0) {
                this.setPendingCount(2);
                int half = this.size >> 1;
                new Sorter(this, this.b, this.a, this.low, half, this.offset, this.depth + 1).fork();
                new Sorter(this, this.b, this.a, this.low + half, this.size - half, this.offset, this.depth + 1).compute();
            } else if (this.a instanceof int[]) {
                DualPivotQuicksort.sort(this, (int[])this.a, this.depth, this.low, this.low + this.size);
            } else if (this.a instanceof long[]) {
                DualPivotQuicksort.sort(this, (long[])this.a, this.depth, this.low, this.low + this.size);
            } else if (this.a instanceof float[]) {
                DualPivotQuicksort.sort(this, (float[])this.a, this.depth, this.low, this.low + this.size);
            } else if (this.a instanceof double[]) {
                DualPivotQuicksort.sort(this, (double[])this.a, this.depth, this.low, this.low + this.size);
            } else {
                throw new IllegalArgumentException("Unknown type of array: " + this.a.getClass().getName());
            }
            this.tryComplete();
        }

        @Override
        public final void onCompletion(CountedCompleter<?> caller) {
            if (this.depth < 0) {
                int mi = this.low + (this.size >> 1);
                boolean src = (this.depth & 1) == 0;
                new Merger(null, this.a, src ? this.low : this.low - this.offset, this.b, src ? this.low - this.offset : this.low, src ? mi - this.offset : mi, this.b, src ? mi - this.offset : mi, src ? this.low + this.size - this.offset : this.low + this.size).invoke();
            }
        }

        void forkSorter(int depth, int low, int high) {
            this.addToPendingCount(1);
            Object a = this.a;
            new Sorter(this, a, this.b, low, high - low, this.offset, depth).fork();
        }
    }
}

