/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java8.util.concurrent.CountedCompleter;
import java8.util.concurrent.ForkJoinPool;
import java8.util.function.BinaryOperator;
import java8.util.function.DoubleBinaryOperator;
import java8.util.function.IntBinaryOperator;
import java8.util.function.LongBinaryOperator;

class ArrayPrefixHelpers {
    static final int CUMULATE = 1;
    static final int SUMMED = 2;
    static final int FINISHED = 4;
    static final int MIN_PARTITION = 16;

    private ArrayPrefixHelpers() {
    }

    static final class IntCumulateTask
    extends CountedCompleter<Void> {
        final int[] array;
        final IntBinaryOperator function;
        IntCumulateTask left;
        IntCumulateTask right;
        int in;
        int out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public IntCumulateTask(IntCumulateTask parent, IntBinaryOperator function, int[] array, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.lo = this.origin = lo;
            this.hi = this.fence = hi;
            int p = (hi - lo) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = p <= 16 ? 16 : p;
        }

        IntCumulateTask(IntCumulateTask parent, IntBinaryOperator function, int[] array, int origin, int fence, int threshold, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.origin = origin;
            this.fence = fence;
            this.threshold = threshold;
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        public final void compute() {
            int h2;
            int l;
            int[] a;
            IntBinaryOperator fn;
            block26: {
                block25: {
                    fn = this.function;
                    if (fn == null) break block25;
                    a = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int th = this.threshold;
            int org = this.origin;
            int fnc = this.fence;
            IntCumulateTask t = this;
            block0: while ((l = t.lo) >= 0 && (h2 = t.hi) <= a.length) {
                int b;
                if (h2 - l > th) {
                    IntCumulateTask f;
                    IntCumulateTask lt = t.left;
                    IntCumulateTask rt = t.right;
                    if (lt == null) {
                        int mid = l + h2 >>> 1;
                        rt = t.right = new IntCumulateTask(t, fn, a, org, fnc, th, mid, h2);
                        f = t.right;
                        lt = t.left = new IntCumulateTask(t, fn, a, org, fnc, th, l, mid);
                        t = t.left;
                    } else {
                        int c;
                        int pin;
                        lt.in = pin = t.in;
                        t = null;
                        f = null;
                        if (rt != null) {
                            int c2;
                            int lout = lt.out;
                            int n = rt.in = l == org ? lout : fn.applyAsInt(pin, lout);
                            while (((c2 = rt.getPendingCount()) & 1) == 0) {
                                if (!rt.compareAndSetPendingCount(c2, c2 | 1)) continue;
                                t = rt;
                                break;
                            }
                        }
                        while (((c = lt.getPendingCount()) & 1) == 0) {
                            if (!lt.compareAndSetPendingCount(c, c | 1)) continue;
                            if (t != null) {
                                f = t;
                            }
                            t = lt;
                            break;
                        }
                        if (t == null) break;
                    }
                    if (f == null) continue;
                    f.fork();
                    continue;
                }
                while (((b = t.getPendingCount()) & 4) == 0) {
                    int sum;
                    int state = (b & 1) != 0 ? 4 : (l > org ? 2 : 6);
                    if (!t.compareAndSetPendingCount(b, b | state)) continue;
                    if (state != 2) {
                        int first;
                        if (l == org) {
                            sum = a[org];
                            first = org + 1;
                        } else {
                            sum = t.in;
                            first = l;
                        }
                        for (int i = first; i < h2; ++i) {
                            a[i] = sum = fn.applyAsInt(sum, a[i]);
                        }
                    } else if (h2 < fnc) {
                        sum = a[l];
                        for (int i = l + 1; i < h2; ++i) {
                            sum = fn.applyAsInt(sum, a[i]);
                        }
                    } else {
                        sum = t.in;
                    }
                    t.out = sum;
                    while (true) {
                        IntCumulateTask par;
                        if ((par = (IntCumulateTask)t.getCompleter()) == null) {
                            if ((state & 4) == 0) break block0;
                            t.quietlyComplete();
                            break block0;
                        }
                        int b2 = par.getPendingCount();
                        if ((b2 & state & 4) != 0) {
                            t = par;
                            continue;
                        }
                        if ((b2 & state & 2) != 0) {
                            int refork;
                            int nextState;
                            IntCumulateTask rt;
                            IntCumulateTask lt = par.left;
                            if (lt != null && (rt = par.right) != null) {
                                int lout = lt.out;
                                par.out = rt.hi == fnc ? lout : fn.applyAsInt(lout, rt.out);
                            }
                            if ((nextState = b2 | state | (refork = (b2 & 1) == 0 && par.lo == org ? 1 : 0)) != b2 && !par.compareAndSetPendingCount(b2, nextState)) continue;
                            state = 2;
                            t = par;
                            if (refork == 0) continue;
                            par.fork();
                            continue;
                        }
                        if (par.compareAndSetPendingCount(b2, b2 | state)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }

    static final class DoubleCumulateTask
    extends CountedCompleter<Void> {
        final double[] array;
        final DoubleBinaryOperator function;
        DoubleCumulateTask left;
        DoubleCumulateTask right;
        double in;
        double out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public DoubleCumulateTask(DoubleCumulateTask parent, DoubleBinaryOperator function, double[] array, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.lo = this.origin = lo;
            this.hi = this.fence = hi;
            int p = (hi - lo) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = p <= 16 ? 16 : p;
        }

        DoubleCumulateTask(DoubleCumulateTask parent, DoubleBinaryOperator function, double[] array, int origin, int fence, int threshold, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.origin = origin;
            this.fence = fence;
            this.threshold = threshold;
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        public final void compute() {
            int h2;
            int l;
            double[] a;
            DoubleBinaryOperator fn;
            block26: {
                block25: {
                    fn = this.function;
                    if (fn == null) break block25;
                    a = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int th = this.threshold;
            int org = this.origin;
            int fnc = this.fence;
            DoubleCumulateTask t = this;
            block0: while ((l = t.lo) >= 0 && (h2 = t.hi) <= a.length) {
                int b;
                if (h2 - l > th) {
                    DoubleCumulateTask f;
                    DoubleCumulateTask lt = t.left;
                    DoubleCumulateTask rt = t.right;
                    if (lt == null) {
                        int mid = l + h2 >>> 1;
                        rt = t.right = new DoubleCumulateTask(t, fn, a, org, fnc, th, mid, h2);
                        f = t.right;
                        lt = t.left = new DoubleCumulateTask(t, fn, a, org, fnc, th, l, mid);
                        t = t.left;
                    } else {
                        int c;
                        double pin;
                        lt.in = pin = t.in;
                        t = null;
                        f = null;
                        if (rt != null) {
                            int c2;
                            double lout = lt.out;
                            double d = rt.in = l == org ? lout : fn.applyAsDouble(pin, lout);
                            while (((c2 = rt.getPendingCount()) & 1) == 0) {
                                if (!rt.compareAndSetPendingCount(c2, c2 | 1)) continue;
                                t = rt;
                                break;
                            }
                        }
                        while (((c = lt.getPendingCount()) & 1) == 0) {
                            if (!lt.compareAndSetPendingCount(c, c | 1)) continue;
                            if (t != null) {
                                f = t;
                            }
                            t = lt;
                            break;
                        }
                        if (t == null) break;
                    }
                    if (f == null) continue;
                    f.fork();
                    continue;
                }
                while (((b = t.getPendingCount()) & 4) == 0) {
                    double sum;
                    int state = (b & 1) != 0 ? 4 : (l > org ? 2 : 6);
                    if (!t.compareAndSetPendingCount(b, b | state)) continue;
                    if (state != 2) {
                        int first;
                        if (l == org) {
                            sum = a[org];
                            first = org + 1;
                        } else {
                            sum = t.in;
                            first = l;
                        }
                        for (int i = first; i < h2; ++i) {
                            a[i] = sum = fn.applyAsDouble(sum, a[i]);
                        }
                    } else if (h2 < fnc) {
                        sum = a[l];
                        for (int i = l + 1; i < h2; ++i) {
                            sum = fn.applyAsDouble(sum, a[i]);
                        }
                    } else {
                        sum = t.in;
                    }
                    t.out = sum;
                    while (true) {
                        DoubleCumulateTask par;
                        if ((par = (DoubleCumulateTask)t.getCompleter()) == null) {
                            if ((state & 4) == 0) break block0;
                            t.quietlyComplete();
                            break block0;
                        }
                        int b2 = par.getPendingCount();
                        if ((b2 & state & 4) != 0) {
                            t = par;
                            continue;
                        }
                        if ((b2 & state & 2) != 0) {
                            int refork;
                            int nextState;
                            DoubleCumulateTask rt;
                            DoubleCumulateTask lt = par.left;
                            if (lt != null && (rt = par.right) != null) {
                                double lout = lt.out;
                                par.out = rt.hi == fnc ? lout : fn.applyAsDouble(lout, rt.out);
                            }
                            if ((nextState = b2 | state | (refork = (b2 & 1) == 0 && par.lo == org ? 1 : 0)) != b2 && !par.compareAndSetPendingCount(b2, nextState)) continue;
                            state = 2;
                            t = par;
                            if (refork == 0) continue;
                            par.fork();
                            continue;
                        }
                        if (par.compareAndSetPendingCount(b2, b2 | state)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }

    static final class LongCumulateTask
    extends CountedCompleter<Void> {
        final long[] array;
        final LongBinaryOperator function;
        LongCumulateTask left;
        LongCumulateTask right;
        long in;
        long out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public LongCumulateTask(LongCumulateTask parent, LongBinaryOperator function, long[] array, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.lo = this.origin = lo;
            this.hi = this.fence = hi;
            int p = (hi - lo) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = p <= 16 ? 16 : p;
        }

        LongCumulateTask(LongCumulateTask parent, LongBinaryOperator function, long[] array, int origin, int fence, int threshold, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.origin = origin;
            this.fence = fence;
            this.threshold = threshold;
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        public final void compute() {
            int h2;
            int l;
            long[] a;
            LongBinaryOperator fn;
            block26: {
                block25: {
                    fn = this.function;
                    if (fn == null) break block25;
                    a = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int th = this.threshold;
            int org = this.origin;
            int fnc = this.fence;
            LongCumulateTask t = this;
            block0: while ((l = t.lo) >= 0 && (h2 = t.hi) <= a.length) {
                int b;
                if (h2 - l > th) {
                    LongCumulateTask f;
                    LongCumulateTask lt = t.left;
                    LongCumulateTask rt = t.right;
                    if (lt == null) {
                        int mid = l + h2 >>> 1;
                        rt = t.right = new LongCumulateTask(t, fn, a, org, fnc, th, mid, h2);
                        f = t.right;
                        lt = t.left = new LongCumulateTask(t, fn, a, org, fnc, th, l, mid);
                        t = t.left;
                    } else {
                        int c;
                        long pin;
                        lt.in = pin = t.in;
                        t = null;
                        f = null;
                        if (rt != null) {
                            int c2;
                            long lout = lt.out;
                            long l2 = rt.in = l == org ? lout : fn.applyAsLong(pin, lout);
                            while (((c2 = rt.getPendingCount()) & 1) == 0) {
                                if (!rt.compareAndSetPendingCount(c2, c2 | 1)) continue;
                                t = rt;
                                break;
                            }
                        }
                        while (((c = lt.getPendingCount()) & 1) == 0) {
                            if (!lt.compareAndSetPendingCount(c, c | 1)) continue;
                            if (t != null) {
                                f = t;
                            }
                            t = lt;
                            break;
                        }
                        if (t == null) break;
                    }
                    if (f == null) continue;
                    f.fork();
                    continue;
                }
                while (((b = t.getPendingCount()) & 4) == 0) {
                    long sum;
                    int state = (b & 1) != 0 ? 4 : (l > org ? 2 : 6);
                    if (!t.compareAndSetPendingCount(b, b | state)) continue;
                    if (state != 2) {
                        int first;
                        if (l == org) {
                            sum = a[org];
                            first = org + 1;
                        } else {
                            sum = t.in;
                            first = l;
                        }
                        for (int i = first; i < h2; ++i) {
                            a[i] = sum = fn.applyAsLong(sum, a[i]);
                        }
                    } else if (h2 < fnc) {
                        sum = a[l];
                        for (int i = l + 1; i < h2; ++i) {
                            sum = fn.applyAsLong(sum, a[i]);
                        }
                    } else {
                        sum = t.in;
                    }
                    t.out = sum;
                    while (true) {
                        LongCumulateTask par;
                        if ((par = (LongCumulateTask)t.getCompleter()) == null) {
                            if ((state & 4) == 0) break block0;
                            t.quietlyComplete();
                            break block0;
                        }
                        int b2 = par.getPendingCount();
                        if ((b2 & state & 4) != 0) {
                            t = par;
                            continue;
                        }
                        if ((b2 & state & 2) != 0) {
                            int refork;
                            int nextState;
                            LongCumulateTask rt;
                            LongCumulateTask lt = par.left;
                            if (lt != null && (rt = par.right) != null) {
                                long lout = lt.out;
                                par.out = rt.hi == fnc ? lout : fn.applyAsLong(lout, rt.out);
                            }
                            if ((nextState = b2 | state | (refork = (b2 & 1) == 0 && par.lo == org ? 1 : 0)) != b2 && !par.compareAndSetPendingCount(b2, nextState)) continue;
                            state = 2;
                            t = par;
                            if (refork == 0) continue;
                            par.fork();
                            continue;
                        }
                        if (par.compareAndSetPendingCount(b2, b2 | state)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }

    static final class CumulateTask<T>
    extends CountedCompleter<Void> {
        final T[] array;
        final BinaryOperator<T> function;
        CumulateTask<T> left;
        CumulateTask<T> right;
        T in;
        T out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public CumulateTask(CumulateTask<T> parent, BinaryOperator<T> function, T[] array, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.lo = this.origin = lo;
            this.hi = this.fence = hi;
            int p = (hi - lo) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = p <= 16 ? 16 : p;
        }

        CumulateTask(CumulateTask<T> parent, BinaryOperator<T> function, T[] array, int origin, int fence, int threshold, int lo, int hi) {
            super(parent);
            this.function = function;
            this.array = array;
            this.origin = origin;
            this.fence = fence;
            this.threshold = threshold;
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        public final void compute() {
            int h2;
            int l;
            T[] a;
            BinaryOperator<T> fn;
            block26: {
                block25: {
                    fn = this.function;
                    if (fn == null) break block25;
                    a = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int th = this.threshold;
            int org = this.origin;
            int fnc = this.fence;
            CumulateTask t = this;
            block0: while ((l = t.lo) >= 0 && (h2 = t.hi) <= a.length) {
                int b;
                if (h2 - l > th) {
                    CumulateTask f;
                    CumulateTask lt = t.left;
                    CumulateTask<T> rt = t.right;
                    if (lt == null) {
                        int mid = l + h2 >>> 1;
                        t.right = new CumulateTask(t, fn, a, org, fnc, th, mid, h2);
                        rt = t.right;
                        f = t.right;
                        t.left = new CumulateTask<T>(t, fn, a, org, fnc, th, l, mid);
                        lt = t.left;
                        t = t.left;
                    } else {
                        int c;
                        T pin;
                        lt.in = pin = t.in;
                        t = null;
                        f = null;
                        if (rt != null) {
                            int c2;
                            T lout = lt.out;
                            Object object = rt.in = l == org ? lout : fn.apply(pin, lout);
                            while (((c2 = rt.getPendingCount()) & 1) == 0) {
                                if (!rt.compareAndSetPendingCount(c2, c2 | 1)) continue;
                                t = rt;
                                break;
                            }
                        }
                        while (((c = lt.getPendingCount()) & 1) == 0) {
                            if (!lt.compareAndSetPendingCount(c, c | 1)) continue;
                            if (t != null) {
                                f = t;
                            }
                            t = lt;
                            break;
                        }
                        if (t == null) break;
                    }
                    if (f == null) continue;
                    f.fork();
                    continue;
                }
                while (((b = t.getPendingCount()) & 4) == 0) {
                    Object sum;
                    int state = (b & 1) != 0 ? 4 : (l > org ? 2 : 6);
                    if (!t.compareAndSetPendingCount(b, b | state)) continue;
                    if (state != 2) {
                        int first;
                        if (l == org) {
                            sum = a[org];
                            first = org + 1;
                        } else {
                            sum = t.in;
                            first = l;
                        }
                        for (int i = first; i < h2; ++i) {
                            sum = fn.apply(sum, a[i]);
                            a[i] = sum;
                        }
                    } else if (h2 < fnc) {
                        sum = a[l];
                        for (int i = l + 1; i < h2; ++i) {
                            sum = fn.apply(sum, a[i]);
                        }
                    } else {
                        sum = t.in;
                    }
                    t.out = sum;
                    while (true) {
                        CumulateTask partmp;
                        CumulateTask par;
                        if ((par = (partmp = (CumulateTask)t.getCompleter())) == null) {
                            if ((state & 4) == 0) break block0;
                            t.quietlyComplete();
                            break block0;
                        }
                        int b2 = par.getPendingCount();
                        if ((b2 & state & 4) != 0) {
                            t = par;
                            continue;
                        }
                        if ((b2 & state & 2) != 0) {
                            int refork;
                            int nextState;
                            CumulateTask<T> rt;
                            CumulateTask<T> lt = par.left;
                            if (lt != null && (rt = par.right) != null) {
                                T lout = lt.out;
                                par.out = rt.hi == fnc ? lout : fn.apply(lout, rt.out);
                            }
                            if ((nextState = b2 | state | (refork = (b2 & 1) == 0 && par.lo == org ? 1 : 0)) != b2 && !par.compareAndSetPendingCount(b2, nextState)) continue;
                            state = 2;
                            t = par;
                            if (refork == 0) continue;
                            par.fork();
                            continue;
                        }
                        if (par.compareAndSetPendingCount(b2, b2 | state)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }
}

