/*
 * Decompiled with CFR 0.152.
 */
package com.joemelsha.crypto.hash;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;

public final class Keccak
extends MessageDigest {
    private static final int MAX_STATE_SIZE = 1600;
    private static final int MAX_STATE_SIZE_WORDS = 25;
    private final int digestSizeBytes;
    private final transient int rateSizeBits;
    private final transient int rateSizeWords;
    private final long[] state = new long[25];
    private int rateBits;
    private transient ByteBuffer out;
    private static final long[] RC = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};

    public Keccak(int digestSizeBits) {
        super(Keccak.getAlgName(digestSizeBits));
        this.digestSizeBytes = digestSizeBits >>> 3;
        this.rateSizeBits = this.rateSizeBitsFor(digestSizeBits);
        this.rateSizeWords = this.rateSizeBits >>> 6;
    }

    private static String getAlgName(int digestSizeBits) {
        switch (digestSizeBits) {
            case 128: {
                return "Keccak-128";
            }
            case 224: {
                return "Keccak-224";
            }
            case 256: {
                return "Keccak-256";
            }
            case 288: {
                return "Keccak-288";
            }
            case 384: {
                return "Keccak-384";
            }
            case 512: {
                return "Keccak-512";
            }
        }
        throw new AssertionError();
    }

    private int rateSizeBitsFor(int digestSizeBits) {
        switch (digestSizeBits) {
            case 128: {
                return 1344;
            }
            case 224: {
                return 1152;
            }
            case 256: {
                return 1088;
            }
            case 288: {
                return 1024;
            }
            case 384: {
                return 832;
            }
            case 512: {
                return 576;
            }
        }
        throw new IllegalArgumentException("Invalid digestSizeBits: " + digestSizeBits + " \u2284 { 128, 224, 256, 288, 384, 512 }");
    }

    @Override
    protected void engineReset() {
        for (int i = 0; i < 25; ++i) {
            this.state[i] = 0L;
        }
        this.rateBits = 0;
        this.out = null;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestSizeBytes;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.updateBits((long)input & 0xFFL, 8);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.engineUpdate(ByteBuffer.wrap(input, offset, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineUpdate(ByteBuffer in) {
        long w;
        int remaining = in.remaining();
        if (remaining <= 0) {
            return;
        }
        int rateBits = this.rateBits;
        if ((rateBits & 7) != 0) {
            throw new IllegalStateException("Cannot update while in bit mode");
        }
        long[] state = this.state;
        int rateBytes = rateBits >>> 3;
        int rateBytesWord = rateBytes & 7;
        if (rateBytesWord > 0) {
            int c = 8 - rateBytesWord;
            if (c > remaining) {
                c = remaining;
            }
            int i = rateBytes >>> 3;
            w = state[i];
            rateBytes += c;
            remaining -= c;
            c = (rateBytesWord <<= 3) + (c << 3);
            do {
                w ^= ((long)in.get() & 0xFFL) << rateBytesWord;
            } while ((rateBytesWord += 8) < c);
            state[i] = w;
            this.rateBits = rateBytes << 3;
            if (remaining <= 0) {
                return;
            }
        }
        int rateWords = rateBytes >>> 3;
        int inWords = remaining >>> 3;
        if (inWords > 0) {
            ByteOrder order = in.order();
            try {
                in.order(ByteOrder.LITTLE_ENDIAN);
                do {
                    int c;
                    if (rateWords >= this.rateSizeWords) {
                        Keccak.keccak(state);
                        rateWords = 0;
                    }
                    if ((c = this.rateSizeWords - rateWords) > inWords) {
                        c = inWords;
                    }
                    inWords -= c;
                    c += rateWords;
                    do {
                        int n = rateWords++;
                        state[n] = state[n] ^ in.getLong();
                    } while (rateWords < c);
                } while (inWords > 0);
            }
            finally {
                in.order(order);
            }
            this.rateBits = rateWords << 6;
            remaining &= 7;
        }
        if (rateWords >= this.rateSizeWords) {
            Keccak.keccak(state);
            this.rateBits = 0;
            rateWords = 0;
        }
        if (remaining > 0) {
            w = state[rateWords];
            int shiftAmount = 0;
            switch (remaining) {
                case 7: {
                    w ^= (long)in.get() & 0xFFL;
                    shiftAmount = 8;
                }
                case 6: {
                    w ^= ((long)in.get() & 0xFFL) << shiftAmount;
                    shiftAmount += 8;
                }
                case 5: {
                    w ^= ((long)in.get() & 0xFFL) << shiftAmount;
                    shiftAmount += 8;
                }
                case 4: {
                    w ^= ((long)in.get() & 0xFFL) << shiftAmount;
                    shiftAmount += 8;
                }
                case 3: {
                    w ^= ((long)in.get() & 0xFFL) << shiftAmount;
                    shiftAmount += 8;
                }
                case 2: {
                    w ^= ((long)in.get() & 0xFFL) << shiftAmount;
                    shiftAmount += 8;
                }
                case 1: {
                    w ^= ((long)in.get() & 0xFFL) << shiftAmount;
                }
            }
            state[rateWords] = w;
            this.rateBits += remaining << 3;
        }
    }

    public void digest(ByteBuffer out, int len) {
        int prevLim = out.limit();
        out.limit(out.position() + len);
        this.digest(out);
        out.limit(prevLim);
    }

    public void digest(ByteBuffer out) {
        this.out = out;
        this.engineDigest();
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) {
        this.out = ByteBuffer.wrap(buf, offset, len);
        this.engineDigest();
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineDigest() {
        int remaining;
        this.pad();
        if (this.out != null) {
            remaining = this.out.remaining();
        } else {
            this.out = ByteBuffer.allocate(this.digestSizeBytes);
            remaining = this.digestSizeBytes;
        }
        int rateWords = 0;
        int outWords = remaining >>> 3;
        if (outWords > 0) {
            this.out.order(ByteOrder.LITTLE_ENDIAN);
            do {
                int c;
                if (rateWords >= this.rateSizeWords) {
                    Keccak.keccak(this.state);
                    rateWords = 0;
                }
                if ((c = this.rateSizeWords - rateWords) > outWords) {
                    c = outWords;
                }
                outWords -= c;
                c += rateWords;
                do {
                    this.out.putLong(this.state[rateWords]);
                } while (++rateWords < c);
            } while (outWords > 0);
            remaining &= 7;
        }
        if (remaining > 0) {
            if (rateWords >= this.rateSizeWords) {
                Keccak.keccak(this.state);
                rateWords = 0;
            }
            long w = this.state[rateWords];
            int shiftAmount = 0;
            switch (remaining) {
                case 7: {
                    this.out.put((byte)w);
                    shiftAmount = 8;
                }
                case 6: {
                    this.out.put((byte)(w >>> shiftAmount));
                    shiftAmount += 8;
                }
                case 5: {
                    this.out.put((byte)(w >>> shiftAmount));
                    shiftAmount += 8;
                }
                case 4: {
                    this.out.put((byte)(w >>> shiftAmount));
                    shiftAmount += 8;
                }
                case 3: {
                    this.out.put((byte)(w >>> shiftAmount));
                    shiftAmount += 8;
                }
                case 2: {
                    this.out.put((byte)(w >>> shiftAmount));
                    shiftAmount += 8;
                }
                case 1: {
                    this.out.put((byte)(w >>> shiftAmount));
                }
            }
        }
        try {
            byte[] byArray = this.out.array();
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    private void pad() {
        this.updateBits(1L, 1);
        if (this.rateBits >= this.rateSizeBits) {
            Keccak.keccak(this.state);
        }
        this.rateBits = this.rateSizeBits - 1;
        this.updateBits(1L, 1);
        Keccak.keccak(this.state);
    }

    void updateBits(long in, int inBits) {
        if (inBits < 0 || inBits > 64) {
            throw new IllegalArgumentException("Invalid valueBits: 0 < " + inBits + " > " + 64);
        }
        if (inBits <= 0) {
            return;
        }
        int rateBits = this.rateBits;
        int rateBitsWord = rateBits & 0x3F;
        if (rateBitsWord > 0) {
            int c = 64 - rateBitsWord;
            if (c > inBits) {
                c = inBits;
            }
            int n = rateBits >>> 6;
            this.state[n] = this.state[n] ^ (in & -1L >>> 64 - c) << rateBitsWord;
            rateBits += c;
            if ((inBits -= c) <= 0) {
                this.rateBits = rateBits;
                return;
            }
            in >>>= c;
        }
        if (rateBits >= this.rateSizeBits) {
            Keccak.keccak(this.state);
            this.state[0] = this.state[0] ^ in & -1L >>> inBits;
            this.rateBits = inBits;
            return;
        }
        int n = rateBits >>> 6;
        this.state[n] = this.state[n] ^ in & -1L >>> 64 - inBits;
        this.rateBits = rateBits + inBits;
    }

    private static void keccak(long[] a) {
        long[] rc = RC;
        int i = 0;
        do {
            long c0 = a[0] ^ a[5] ^ a[10] ^ a[15] ^ a[20];
            long c1 = a[1] ^ a[6] ^ a[11] ^ a[16] ^ a[21];
            long c2 = a[2] ^ a[7] ^ a[12] ^ a[17] ^ a[22];
            long c3 = a[3] ^ a[8] ^ a[13] ^ a[18] ^ a[23];
            long c4 = a[4] ^ a[9] ^ a[14] ^ a[19] ^ a[24];
            long t0 = c0 << 1 ^ c0 >>> 63 ^ c3;
            long t1 = c1 << 1 ^ c1 >>> 63 ^ c4;
            long t2 = c2 << 1 ^ c2 >>> 63 ^ c0;
            long t3 = c3 << 1 ^ c3 >>> 63 ^ c1;
            long t4 = c4 << 1 ^ c4 >>> 63 ^ c2;
            a[0] = a[0] ^ t1;
            long x = a[1] ^ t2;
            long a_10_ = x << 1 | x >>> 63;
            x = a[6] ^ t2;
            a[1] = x << 44 | x >>> 20;
            x = a[9] ^ t0;
            a[6] = x << 20 | x >>> 44;
            x = a[22] ^ t3;
            a[9] = x << 61 | x >>> 3;
            x = a[14] ^ t0;
            a[22] = x << 39 | x >>> 25;
            x = a[20] ^ t1;
            a[14] = x << 18 | x >>> 46;
            x = a[2] ^ t3;
            a[20] = x << 62 | x >>> 2;
            x = a[12] ^ t3;
            a[2] = x << 43 | x >>> 21;
            x = a[13] ^ t4;
            a[12] = x << 25 | x >>> 39;
            x = a[19] ^ t0;
            a[13] = x << 8 | x >>> 56;
            x = a[23] ^ t4;
            a[19] = x << 56 | x >>> 8;
            x = a[15] ^ t1;
            a[23] = x << 41 | x >>> 23;
            x = a[4] ^ t0;
            a[15] = x << 27 | x >>> 37;
            x = a[24] ^ t0;
            a[4] = x << 14 | x >>> 50;
            x = a[21] ^ t2;
            a[24] = x << 2 | x >>> 62;
            x = a[8] ^ t4;
            a[21] = x << 55 | x >>> 9;
            x = a[16] ^ t2;
            a[8] = x << 45 | x >>> 19;
            x = a[5] ^ t1;
            a[16] = x << 36 | x >>> 28;
            x = a[3] ^ t4;
            a[5] = x << 28 | x >>> 36;
            x = a[18] ^ t4;
            a[3] = x << 21 | x >>> 43;
            x = a[17] ^ t3;
            a[18] = x << 15 | x >>> 49;
            x = a[11] ^ t2;
            a[17] = x << 10 | x >>> 54;
            x = a[7] ^ t3;
            a[11] = x << 6 | x >>> 58;
            x = a[10] ^ t1;
            a[7] = x << 3 | x >>> 61;
            a[10] = a_10_;
            int c = 0;
            do {
                long x0 = a[c + 0];
                long x1 = a[c + 1];
                long x2 = a[c + 2];
                long x3 = a[c + 3];
                long x4 = a[c + 4];
                a[c + 0] = x0 ^ (x1 ^ 0xFFFFFFFFFFFFFFFFL) & x2;
                a[c + 1] = x1 ^ (x2 ^ 0xFFFFFFFFFFFFFFFFL) & x3;
                a[c + 2] = x2 ^ (x3 ^ 0xFFFFFFFFFFFFFFFFL) & x4;
                a[c + 3] = x3 ^ (x4 ^ 0xFFFFFFFFFFFFFFFFL) & x0;
                a[c + 4] = x4 ^ (x0 ^ 0xFFFFFFFFFFFFFFFFL) & x1;
            } while ((c += 5) < 25);
            a[0] = a[0] ^ rc[i];
        } while (++i < 24);
    }
}

