/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.threeten.bp.Duration;

public interface WithPing {
    public Duration getRequestTimeout();

    public CompletableFuture<Void> pingAsync(AccountId var1);

    default public void pingAsync(AccountId accountid, BiConsumer<Void, Throwable> callback) {
        this.pingAsync(accountid, this.getRequestTimeout(), callback);
    }

    default public void pingAsync(AccountId accountid, Duration timeout, BiConsumer<Void, Throwable> callback) {
        this.pingAsync(accountid).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((BiConsumer)callback);
    }

    default public void pingAsync(AccountId accountid, Consumer<Void> onSuccess, Consumer<Throwable> onFailure) {
        this.pingAsync(accountid, this.getRequestTimeout(), onSuccess, onFailure);
    }

    default public void pingAsync(AccountId accountid, Duration timeout, Consumer<Void> onSuccess, Consumer<Throwable> onFailure) {
        this.pingAsync(accountid).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((output, error) -> {
            if (error != null) {
                onFailure.accept((Throwable)error);
            } else {
                onSuccess.accept((Void)output);
            }
        });
    }

    default public Void ping(AccountId accountid) throws TimeoutException, PrecheckStatusException {
        return this.ping(accountid, this.getRequestTimeout());
    }

    default public Void ping(AccountId accountid, Duration timeout) throws TimeoutException, PrecheckStatusException {
        try {
            return this.pingAsync(accountid).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof PrecheckStatusException) {
                throw (PrecheckStatusException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

