/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TransactionRecord;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.threeten.bp.Duration;

public interface WithGetRecord {
    public CompletableFuture<TransactionRecord> getRecordAsync(Client var1);

    default public void getRecordAsync(Client client, BiConsumer<TransactionRecord, Throwable> callback) {
        this.getRecordAsync(client, client.getRequestTimeout(), callback);
    }

    default public void getRecordAsync(Client client, Duration timeout, BiConsumer<TransactionRecord, Throwable> callback) {
        this.getRecordAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((BiConsumer)callback);
    }

    default public void getRecordAsync(Client client, Consumer<TransactionRecord> onSuccess, Consumer<Throwable> onFailure) {
        this.getRecordAsync(client, client.getRequestTimeout(), onSuccess, onFailure);
    }

    default public void getRecordAsync(Client client, Duration timeout, Consumer<TransactionRecord> onSuccess, Consumer<Throwable> onFailure) {
        this.getRecordAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((output, error) -> {
            if (error != null) {
                onFailure.accept((Throwable)error);
            } else {
                onSuccess.accept((TransactionRecord)output);
            }
        });
    }

    default public TransactionRecord getRecord(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        return this.getRecord(client, client.getRequestTimeout());
    }

    default public TransactionRecord getRecord(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        try {
            return this.getRecordAsync(client).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof PrecheckStatusException) {
                throw (PrecheckStatusException)cause;
            }
            if (cause instanceof ReceiptStatusException) {
                throw (ReceiptStatusException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

