/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UInt32Value;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenNftTransfer;
import com.hedera.hashgraph.sdk.TokenTransfer;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.AccountAmount;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.CryptoTransferTransactionBody;
import com.hedera.hashgraph.sdk.proto.NftTransfer;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenTransferList;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.proto.TransferList;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TransferTransaction
extends com.hedera.hashgraph.sdk.Transaction<TransferTransaction> {
    private final ArrayList<TokenTransfer> tokenTransfers = new ArrayList();
    private final ArrayList<TokenNftTransfer> nftTransfers = new ArrayList();
    private final ArrayList<HbarTransfer> hbarTransfers = new ArrayList();

    public TransferTransaction() {
        this.defaultMaxTransactionFee = new Hbar(1L);
    }

    TransferTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TransferTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    public Map<TokenId, Integer> getTokenIdDecimals() {
        HashMap<TokenId, Integer> decimalsMap = new HashMap<TokenId, Integer>();
        for (TokenTransfer transfer : this.tokenTransfers) {
            decimalsMap.put(transfer.tokenId, transfer.expectedDecimals);
        }
        return decimalsMap;
    }

    public Map<TokenId, Map<AccountId, Long>> getTokenTransfers() {
        HashMap<TokenId, Map<AccountId, Long>> transfers = new HashMap<TokenId, Map<AccountId, Long>>();
        for (TokenTransfer transfer : this.tokenTransfers) {
            HashMap<AccountId, Long> current = transfers.get(transfer.tokenId) != null ? (Map)transfers.get(transfer.tokenId) : new HashMap<AccountId, Long>();
            current.put(transfer.accountId, transfer.amount);
            transfers.put(transfer.tokenId, current);
        }
        return transfers;
    }

    private TransferTransaction doAddTokenTransfer(TokenId tokenId, AccountId accountId, long value, boolean isApproved) {
        this.requireNotFrozen();
        for (TokenTransfer transfer : this.tokenTransfers) {
            if (!transfer.tokenId.equals(tokenId) || !transfer.accountId.equals(accountId) || transfer.isApproved != isApproved) continue;
            transfer.amount += value;
            return this;
        }
        this.tokenTransfers.add(new TokenTransfer(tokenId, accountId, value, isApproved));
        return this;
    }

    public TransferTransaction addTokenTransfer(TokenId tokenId, AccountId accountId, long value) {
        return this.doAddTokenTransfer(tokenId, accountId, value, false);
    }

    public TransferTransaction addApprovedTokenTransfer(TokenId tokenId, AccountId accountId, long value) {
        return this.doAddTokenTransfer(tokenId, accountId, value, true);
    }

    private TransferTransaction doAddTokenTransferWithDecimals(TokenId tokenId, AccountId accountId, long value, int decimals, boolean isApproved) {
        this.requireNotFrozen();
        boolean found = false;
        for (TokenTransfer transfer : this.tokenTransfers) {
            if (!transfer.tokenId.equals(tokenId)) continue;
            if (transfer.expectedDecimals != null && transfer.expectedDecimals != decimals) {
                throw new IllegalArgumentException("expected decimals for a token in a token transfer cannot be changed after being set");
            }
            transfer.expectedDecimals = decimals;
            if (!transfer.accountId.equals(accountId) || transfer.isApproved != isApproved) continue;
            transfer.amount += value;
            found = true;
        }
        if (found) {
            return this;
        }
        this.tokenTransfers.add(new TokenTransfer(tokenId, accountId, value, decimals, isApproved));
        return this;
    }

    public TransferTransaction addTokenTransferWithDecimals(TokenId tokenId, AccountId accountId, long value, int decimals) {
        return this.doAddTokenTransferWithDecimals(tokenId, accountId, value, decimals, false);
    }

    public TransferTransaction addApprovedTokenTransferWithDecimals(TokenId tokenId, AccountId accountId, long value, int decimals) {
        return this.doAddTokenTransferWithDecimals(tokenId, accountId, value, decimals, true);
    }

    @Deprecated
    public TransferTransaction setTokenTransferApproval(TokenId tokenId, AccountId accountId, boolean isApproved) {
        this.requireNotFrozen();
        for (TokenTransfer transfer : this.tokenTransfers) {
            if (!transfer.tokenId.equals(tokenId) || !transfer.accountId.equals(accountId)) continue;
            transfer.isApproved = isApproved;
            return this;
        }
        return this;
    }

    public Map<TokenId, List<TokenNftTransfer>> getTokenNftTransfers() {
        HashMap<TokenId, List<TokenNftTransfer>> transfers = new HashMap<TokenId, List<TokenNftTransfer>>();
        for (TokenNftTransfer transfer : this.nftTransfers) {
            ArrayList<TokenNftTransfer> current = transfers.get(transfer.tokenId) != null ? (List)transfers.get(transfer.tokenId) : new ArrayList<TokenNftTransfer>();
            current.add(transfer);
            transfers.put(transfer.tokenId, current);
        }
        return transfers;
    }

    private TransferTransaction doAddNftTransfer(NftId nftId, AccountId sender, AccountId receiver, boolean isApproved) {
        this.requireNotFrozen();
        this.nftTransfers.add(new TokenNftTransfer(nftId.tokenId, sender, receiver, nftId.serial, isApproved));
        return this;
    }

    public TransferTransaction addNftTransfer(NftId nftId, AccountId sender, AccountId receiver) {
        return this.doAddNftTransfer(nftId, sender, receiver, false);
    }

    public TransferTransaction addApprovedNftTransfer(NftId nftId, AccountId sender, AccountId receiver) {
        return this.doAddNftTransfer(nftId, sender, receiver, true);
    }

    @Deprecated
    public TransferTransaction setNftTransferApproval(NftId nftId, boolean isApproved) {
        this.requireNotFrozen();
        for (TokenNftTransfer transfer : this.nftTransfers) {
            if (!transfer.tokenId.equals(nftId.tokenId) || transfer.serial != nftId.serial) continue;
            transfer.isApproved = isApproved;
            return this;
        }
        return this;
    }

    public Map<AccountId, Hbar> getHbarTransfers() {
        HashMap<AccountId, Hbar> transfers = new HashMap<AccountId, Hbar>();
        for (HbarTransfer transfer : this.hbarTransfers) {
            transfers.put(transfer.accountId, transfer.amount);
        }
        return transfers;
    }

    private TransferTransaction doAddHbarTransfer(AccountId accountId, Hbar value, boolean isApproved) {
        this.requireNotFrozen();
        for (HbarTransfer transfer : this.hbarTransfers) {
            if (!transfer.accountId.equals(accountId) || transfer.isApproved != isApproved) continue;
            transfer.amount = Hbar.fromTinybars(transfer.amount.toTinybars() + value.toTinybars());
            return this;
        }
        this.hbarTransfers.add(new HbarTransfer(accountId, value, isApproved));
        return this;
    }

    public TransferTransaction addHbarTransfer(AccountId accountId, Hbar value) {
        return this.doAddHbarTransfer(accountId, value, false);
    }

    public TransferTransaction addApprovedHbarTransfer(AccountId accountId, Hbar value) {
        return this.doAddHbarTransfer(accountId, value, true);
    }

    @Deprecated
    public TransferTransaction setHbarTransferApproval(AccountId accountId, boolean isApproved) {
        this.requireNotFrozen();
        for (HbarTransfer transfer : this.hbarTransfers) {
            if (!transfer.accountId.equals(accountId)) continue;
            transfer.isApproved = isApproved;
            return this;
        }
        return this;
    }

    CryptoTransferTransactionBody.Builder build() {
        ArrayList<TokenTransferList> tokenTransfers = new ArrayList<TokenTransferList>();
        this.hbarTransfers.sort(Comparator.comparing(a -> a.accountId).thenComparing(a -> a.isApproved));
        this.tokenTransfers.sort(Comparator.comparing(a -> a.tokenId).thenComparing(a -> a.accountId).thenComparing(a -> a.isApproved));
        this.nftTransfers.sort(Comparator.comparing(a -> a.tokenId).thenComparing(a -> a.sender).thenComparing(a -> a.receiver).thenComparing(a -> a.serial));
        int i = 0;
        int j = 0;
        while (i < this.tokenTransfers.size() || j < this.nftTransfers.size()) {
            TokenId lastTokenId;
            TokenTransferList last;
            TokenId iTokenId;
            if (i < this.tokenTransfers.size() && j < this.nftTransfers.size()) {
                TokenId tokenId;
                iTokenId = this.tokenTransfers.get((int)i).tokenId;
                TokenId jTokenId = this.nftTransfers.get((int)j).tokenId;
                TokenTransferList last2 = !tokenTransfers.isEmpty() ? (TokenTransferList)tokenTransfers.get(tokenTransfers.size() - 1) : null;
                TokenId tokenId2 = tokenId = last2 != null ? last2.tokenId : null;
                if (last2 != null && iTokenId.compareTo(tokenId) == 0) {
                    last2.transfers.add(this.tokenTransfers.get(i++));
                    continue;
                }
                if (last2 != null && jTokenId.compareTo(tokenId) == 0) {
                    last2.nftTransfers.add(this.nftTransfers.get(j++));
                    continue;
                }
                int result = iTokenId.compareTo(jTokenId);
                if (result == 0) {
                    tokenTransfers.add(new TokenTransferList(iTokenId, this.tokenTransfers.get((int)i).expectedDecimals, this.tokenTransfers.get(i++), this.nftTransfers.get(j++)));
                    continue;
                }
                if (result < 0) {
                    tokenTransfers.add(new TokenTransferList(iTokenId, this.tokenTransfers.get((int)i).expectedDecimals, this.tokenTransfers.get(i++), null));
                    continue;
                }
                tokenTransfers.add(new TokenTransferList(jTokenId, null, null, this.nftTransfers.get(j++)));
                continue;
            }
            if (i < this.tokenTransfers.size()) {
                iTokenId = this.tokenTransfers.get((int)i).tokenId;
                last = !tokenTransfers.isEmpty() ? (TokenTransferList)tokenTransfers.get(tokenTransfers.size() - 1) : null;
                TokenId tokenId = lastTokenId = last != null ? last.tokenId : null;
                if (last != null && iTokenId.compareTo(lastTokenId) == 0) {
                    last.transfers.add(this.tokenTransfers.get(i++));
                    continue;
                }
                tokenTransfers.add(new TokenTransferList(iTokenId, this.tokenTransfers.get((int)i).expectedDecimals, this.tokenTransfers.get(i++), null));
                continue;
            }
            TokenId jTokenId = this.nftTransfers.get((int)j).tokenId;
            last = !tokenTransfers.isEmpty() ? (TokenTransferList)tokenTransfers.get(tokenTransfers.size() - 1) : null;
            TokenId tokenId = lastTokenId = last != null ? last.tokenId : null;
            if (last != null && jTokenId.compareTo(lastTokenId) == 0) {
                last.nftTransfers.add(this.nftTransfers.get(j++));
                continue;
            }
            tokenTransfers.add(new TokenTransferList(jTokenId, null, null, this.nftTransfers.get(j++)));
        }
        CryptoTransferTransactionBody.Builder builder = CryptoTransferTransactionBody.newBuilder();
        TransferList.Builder transfers = TransferList.newBuilder();
        for (HbarTransfer hbarTransfer : this.hbarTransfers) {
            transfers.addAccountAmounts(hbarTransfer.toProtobuf());
        }
        builder.setTransfers(transfers);
        for (TokenTransferList tokenTransferList : tokenTransfers) {
            builder.addTokenTransfers(tokenTransferList.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        for (HbarTransfer hbarTransfer : this.hbarTransfers) {
            hbarTransfer.accountId.validateChecksum(client);
        }
        for (TokenNftTransfer tokenNftTransfer : this.nftTransfers) {
            tokenNftTransfer.tokenId.validateChecksum(client);
            tokenNftTransfer.sender.validateChecksum(client);
            tokenNftTransfer.receiver.validateChecksum(client);
        }
        for (TokenTransfer tokenTransfer : this.tokenTransfers) {
            tokenTransfer.tokenId.validateChecksum(client);
            tokenTransfer.accountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getCryptoTransferMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoTransfer(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoTransfer(this.build());
    }

    void initFromTransactionBody() {
        CryptoTransferTransactionBody body = this.sourceTransactionBody.getCryptoTransfer();
        for (AccountAmount transfer : body.getTransfers().getAccountAmountsList()) {
            this.hbarTransfers.add(new HbarTransfer(AccountId.fromProtobuf(transfer.getAccountID()), Hbar.fromTinybars(transfer.getAmount()), transfer.getIsApproval()));
        }
        for (com.hedera.hashgraph.sdk.proto.TokenTransferList tokenTransferList : body.getTokenTransfersList()) {
            TokenId token = TokenId.fromProtobuf(tokenTransferList.getToken());
            for (AccountAmount accountAmount : tokenTransferList.getTransfersList()) {
                this.tokenTransfers.add(new TokenTransfer(token, AccountId.fromProtobuf(accountAmount.getAccountID()), accountAmount.getAmount(), tokenTransferList.hasExpectedDecimals() ? Integer.valueOf(tokenTransferList.getExpectedDecimals().getValue()) : null, accountAmount.getIsApproval()));
            }
            for (NftTransfer nftTransfer : tokenTransferList.getNftTransfersList()) {
                this.nftTransfers.add(new TokenNftTransfer(token, AccountId.fromProtobuf(nftTransfer.getSenderAccountID()), AccountId.fromProtobuf(nftTransfer.getReceiverAccountID()), nftTransfer.getSerialNumber(), nftTransfer.getIsApproval()));
            }
        }
    }

    private static class TokenTransferList {
        final TokenId tokenId;
        @Nullable
        final Integer expectDecimals;
        List<TokenTransfer> transfers = new ArrayList<TokenTransfer>();
        List<TokenNftTransfer> nftTransfers = new ArrayList<TokenNftTransfer>();

        TokenTransferList(TokenId tokenId, @Nullable Integer expectDecimals, @Nullable TokenTransfer transfer, @Nullable TokenNftTransfer nftTransfer) {
            this.tokenId = tokenId;
            this.expectDecimals = expectDecimals;
            if (transfer != null) {
                this.transfers.add(transfer);
            }
            if (nftTransfer != null) {
                this.nftTransfers.add(nftTransfer);
            }
        }

        com.hedera.hashgraph.sdk.proto.TokenTransferList toProtobuf() {
            ArrayList<AccountAmount> transfers = new ArrayList<AccountAmount>();
            ArrayList<NftTransfer> nftTransfers = new ArrayList<NftTransfer>();
            for (TokenTransfer tokenTransfer : this.transfers) {
                transfers.add(tokenTransfer.toProtobuf());
            }
            for (TokenNftTransfer tokenNftTransfer : this.nftTransfers) {
                nftTransfers.add(tokenNftTransfer.toProtobuf());
            }
            TokenTransferList.Builder builder = com.hedera.hashgraph.sdk.proto.TokenTransferList.newBuilder().setToken(this.tokenId.toProtobuf()).addAllTransfers(transfers).addAllNftTransfers(nftTransfers);
            if (this.expectDecimals != null) {
                builder.setExpectedDecimals((UInt32Value)UInt32Value.newBuilder().setValue(this.expectDecimals).build());
            }
            return (com.hedera.hashgraph.sdk.proto.TokenTransferList)builder.build();
        }
    }

    private static class HbarTransfer {
        final AccountId accountId;
        Hbar amount;
        boolean isApproved;

        HbarTransfer(AccountId accountId, Hbar amount, boolean isApproved) {
            this.accountId = accountId;
            this.amount = amount;
            this.isApproved = isApproved;
        }

        AccountAmount toProtobuf() {
            return (AccountAmount)AccountAmount.newBuilder().setAccountID(this.accountId.toProtobuf()).setAmount(this.amount.toTinybars()).setIsApproval(this.isApproved).build();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("accountId", this.accountId).add("amount", this.amount).add("isApproved", this.isApproved).toString();
        }
    }
}

