/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.proto.AccountAmount;

public final class Transfer {
    public final AccountId accountId;
    public final Hbar amount;

    Transfer(AccountId accountId, Hbar amount) {
        this.accountId = accountId;
        this.amount = amount;
    }

    static Transfer fromProtobuf(AccountAmount accountAmount) {
        return new Transfer(AccountId.fromProtobuf(accountAmount.getAccountID()), Hbar.fromTinybars(accountAmount.getAmount()));
    }

    AccountAmount toProtobuf() {
        return (AccountAmount)AccountAmount.newBuilder().setAccountID(this.accountId.toProtobuf()).setAmount(this.amount.toTinybars()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountId", this.accountId).add("amount", this.amount).toString();
    }
}

