/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.TransactionRecordQuery;
import com.hedera.hashgraph.sdk.WithGetReceipt;
import com.hedera.hashgraph.sdk.WithGetRecord;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class TransactionResponse
implements WithGetReceipt,
WithGetRecord {
    public final AccountId nodeId;
    public final byte[] transactionHash;
    public final TransactionId transactionId;
    @Nullable
    @Deprecated
    public final TransactionId scheduledTransactionId;

    TransactionResponse(AccountId nodeId, TransactionId transactionId, byte[] transactionHash, @Nullable TransactionId scheduledTransactionId) {
        this.nodeId = nodeId;
        this.transactionId = transactionId;
        this.transactionHash = transactionHash;
        this.scheduledTransactionId = scheduledTransactionId;
    }

    @Override
    public TransactionReceipt getReceipt(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        TransactionReceipt receipt = (TransactionReceipt)((TransactionReceiptQuery)new TransactionReceiptQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId))).execute(client);
        if (receipt.status != Status.SUCCESS) {
            throw new ReceiptStatusException(this.transactionId, receipt);
        }
        return receipt;
    }

    public TransactionReceiptQuery getReceiptQuery() {
        return (TransactionReceiptQuery)new TransactionReceiptQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId));
    }

    @Override
    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client client) {
        return ((TransactionReceiptQuery)new TransactionReceiptQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId))).executeAsync(client);
    }

    @Override
    public TransactionRecord getRecord(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        this.getReceipt(client);
        return (TransactionRecord)((TransactionRecordQuery)new TransactionRecordQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId))).execute(client);
    }

    public TransactionRecordQuery getRecordQuery() {
        return (TransactionRecordQuery)new TransactionRecordQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId));
    }

    @Override
    public CompletableFuture<TransactionRecord> getRecordAsync(Client client) {
        return this.getReceiptAsync(client).thenCompose(receipt -> ((TransactionRecordQuery)new TransactionRecordQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId))).executeAsync(client));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("nodeId", this.nodeId).add("transactionHash", Hex.toHexString(this.transactionHash)).add("transactionId", this.transactionId).toString();
    }
}

