/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.TransactionRecordQuery;
import com.hedera.hashgraph.sdk.WithGetReceipt;
import com.hedera.hashgraph.sdk.WithGetRecord;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.threeten.bp.Clock;
import org.threeten.bp.Instant;

public final class TransactionId
implements WithGetReceipt,
WithGetRecord,
Comparable<TransactionId> {
    @Nullable
    public final AccountId accountId;
    @Nullable
    public final Instant validStart;
    private boolean scheduled = false;
    @Nullable
    private Integer nonce = null;

    public TransactionId(@Nullable AccountId accountId, @Nullable Instant validStart) {
        this.accountId = accountId;
        this.validStart = validStart;
        this.scheduled = false;
    }

    public static TransactionId withValidStart(AccountId accountId, Instant validStart) {
        return new TransactionId(accountId, validStart);
    }

    public static TransactionId generate(AccountId accountId) {
        Instant instant = Clock.systemUTC().instant().minusNanos((long)(Math.random() * 5.0E9 + 8.0E9));
        return new TransactionId(accountId, instant);
    }

    static TransactionId fromProtobuf(TransactionID transactionID) {
        AccountId accountId = transactionID.hasAccountID() ? AccountId.fromProtobuf(transactionID.getAccountID()) : null;
        Instant validStart = transactionID.hasTransactionValidStart() ? InstantConverter.fromProtobuf(transactionID.getTransactionValidStart()) : null;
        return new TransactionId(accountId, validStart).setScheduled(transactionID.getScheduled()).setNonce(transactionID.getNonce() != 0 ? Integer.valueOf(transactionID.getNonce()) : null);
    }

    public static TransactionId fromString(String s2) {
        String[] parts = s2.split("/", 2);
        Integer nonce = parts.length == 2 ? Integer.valueOf(Integer.parseInt(parts[1])) : null;
        parts = parts[0].split("\\?", 2);
        boolean scheduled = parts.length == 2 && parts[1].equals("scheduled");
        if ((parts = parts[0].split("@", 2)).length != 2) {
            throw new IllegalArgumentException("expecting {account}@{seconds}.{nanos}[?scheduled][/nonce]");
        }
        AccountId accountId = AccountId.fromString(parts[0]);
        String[] validStartParts = parts[1].split("\\.", 2);
        if (validStartParts.length != 2) {
            throw new IllegalArgumentException("expecting {account}@{seconds}.{nanos}");
        }
        Instant validStart = Instant.ofEpochSecond(Long.parseLong(validStartParts[0]), Long.parseLong(validStartParts[1]));
        return new TransactionId(accountId, validStart).setScheduled(scheduled).setNonce(nonce);
    }

    public static TransactionId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TransactionId.fromProtobuf((TransactionID)((TransactionID.Builder)TransactionID.parseFrom(bytes).toBuilder()).build());
    }

    public boolean getScheduled() {
        return this.scheduled;
    }

    public TransactionId setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
        return this;
    }

    @Nullable
    public Integer getNonce() {
        return this.nonce;
    }

    public TransactionId setNonce(@Nullable Integer nonce) {
        this.nonce = nonce;
        return this;
    }

    @Override
    public TransactionReceipt getReceipt(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        TransactionReceipt receipt = (TransactionReceipt)new TransactionReceiptQuery().setTransactionId(this).execute(client);
        if (receipt.status != Status.SUCCESS) {
            throw new ReceiptStatusException(this, receipt);
        }
        return receipt;
    }

    @Override
    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client client) {
        return new TransactionReceiptQuery().setTransactionId(this).executeAsync(client).thenCompose(receipt -> {
            if (receipt.status != Status.SUCCESS) {
                return CompletableFuture.failedFuture(new ReceiptStatusException(this, (TransactionReceipt)receipt));
            }
            return CompletableFuture.completedFuture(receipt);
        });
    }

    @Override
    public TransactionRecord getRecord(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        this.getReceipt(client);
        return (TransactionRecord)new TransactionRecordQuery().setTransactionId(this).execute(client);
    }

    @Override
    public CompletableFuture<TransactionRecord> getRecordAsync(Client client) {
        return this.getReceiptAsync(client).thenCompose(receipt -> new TransactionRecordQuery().setTransactionId(this).executeAsync(client));
    }

    TransactionID toProtobuf() {
        TransactionID.Builder id = TransactionID.newBuilder().setScheduled(this.scheduled).setNonce(this.nonce != null ? this.nonce : 0);
        if (this.accountId != null) {
            id.setAccountID(this.accountId.toProtobuf());
        }
        if (this.validStart != null) {
            id.setTransactionValidStart(InstantConverter.toProtobuf(this.validStart));
        }
        return (TransactionID)id.build();
    }

    private String toStringPostfix() {
        Objects.requireNonNull(this.validStart);
        return "@" + this.validStart.getEpochSecond() + "." + this.validStart.getNano() + (this.scheduled ? "?scheduled" : "") + (String)(this.nonce != null ? "/" + this.nonce : "");
    }

    public String toString() {
        if (this.accountId != null && this.validStart != null) {
            return this.accountId + this.toStringPostfix();
        }
        throw new IllegalStateException("`TransactionId.toString()` is non-exhaustive");
    }

    public String toStringWithChecksum(Client client) {
        if (this.accountId != null && this.validStart != null) {
            return this.accountId.toStringWithChecksum(client) + this.toStringPostfix();
        }
        throw new IllegalStateException("`TransactionId.toStringWithChecksum()` is non-exhaustive");
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof TransactionId)) {
            return false;
        }
        TransactionId id = (TransactionId)object;
        if (this.accountId != null && this.validStart != null && id.accountId != null && id.validStart != null) {
            return id.accountId.equals(this.accountId) && id.validStart.equals(this.validStart) && this.scheduled == id.scheduled;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(TransactionId o) {
        boolean otherStartIsNull;
        int accountIdComparison;
        boolean otherAccountIdIsNull;
        Objects.requireNonNull(o);
        if (this.scheduled != o.scheduled) {
            return this.scheduled ? 1 : -1;
        }
        boolean thisAccountIdIsNull = this.accountId == null;
        boolean bl = otherAccountIdIsNull = o.accountId == null;
        if (thisAccountIdIsNull != otherAccountIdIsNull) {
            return thisAccountIdIsNull ? -1 : 1;
        }
        if (!thisAccountIdIsNull && (accountIdComparison = this.accountId.compareTo(o.accountId)) != 0) {
            return accountIdComparison;
        }
        boolean thisStartIsNull = this.validStart == null;
        boolean bl2 = otherStartIsNull = o.validStart == null;
        if (thisStartIsNull != otherStartIsNull) {
            return thisAccountIdIsNull ? -1 : 1;
        }
        if (!thisStartIsNull) {
            return this.validStart.compareTo(o.validStart);
        }
        return 0;
    }
}

