/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.FeeData;
import com.hedera.hashgraph.sdk.RequestType;
import com.hedera.hashgraph.sdk.proto.TransactionFeeSchedule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TransactionFeeSchedule {
    private RequestType requestType = RequestType.NONE;
    @Nullable
    private FeeData feeData = null;
    private List<FeeData> fees = new ArrayList<FeeData>();

    static TransactionFeeSchedule fromProtobuf(com.hedera.hashgraph.sdk.proto.TransactionFeeSchedule transactionFeeSchedule) {
        TransactionFeeSchedule returnFeeSchedule = new TransactionFeeSchedule().setRequestType(RequestType.valueOf(transactionFeeSchedule.getHederaFunctionality())).setFeeData(transactionFeeSchedule.hasFeeData() ? FeeData.fromProtobuf(transactionFeeSchedule.getFeeData()) : null);
        for (com.hedera.hashgraph.sdk.proto.FeeData feeData : transactionFeeSchedule.getFeesList()) {
            returnFeeSchedule.addFee(FeeData.fromProtobuf(feeData));
        }
        return returnFeeSchedule;
    }

    public static TransactionFeeSchedule fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TransactionFeeSchedule.fromProtobuf((com.hedera.hashgraph.sdk.proto.TransactionFeeSchedule)((TransactionFeeSchedule.Builder)com.hedera.hashgraph.sdk.proto.TransactionFeeSchedule.parseFrom(bytes).toBuilder()).build());
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public TransactionFeeSchedule setRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    @Deprecated
    @Nullable
    public FeeData getFeeData() {
        return this.feeData;
    }

    @Deprecated
    public TransactionFeeSchedule setFeeData(@Nullable FeeData feeData) {
        this.feeData = feeData;
        return this;
    }

    public List<FeeData> getFees() {
        return this.fees;
    }

    public TransactionFeeSchedule addFee(FeeData fee) {
        this.fees.add(Objects.requireNonNull(fee));
        return this;
    }

    com.hedera.hashgraph.sdk.proto.TransactionFeeSchedule toProtobuf() {
        TransactionFeeSchedule.Builder returnBuilder = com.hedera.hashgraph.sdk.proto.TransactionFeeSchedule.newBuilder().setHederaFunctionality(this.getRequestType().code);
        if (this.feeData != null) {
            returnBuilder.setFeeData(this.feeData.toProtobuf());
        }
        for (FeeData fee : this.fees) {
            returnBuilder.addFees(fee.toProtobuf());
        }
        return (com.hedera.hashgraph.sdk.proto.TransactionFeeSchedule)returnBuilder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("requestType", (Object)this.getRequestType()).add("feeData", this.getFeeData()).add("fees", this.getFees()).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

