/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ConsensusDeleteTopicTransactionBody;
import com.hedera.hashgraph.sdk.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TopicDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<TopicDeleteTransaction> {
    @Nullable
    private TopicId topicId = null;

    public TopicDeleteTransaction() {
    }

    TopicDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TopicDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TopicId getTopicId() {
        return this.topicId;
    }

    public TopicDeleteTransaction setTopicId(TopicId topicId) {
        Objects.requireNonNull(topicId);
        this.requireNotFrozen();
        this.topicId = topicId;
        return this;
    }

    void initFromTransactionBody() {
        ConsensusDeleteTopicTransactionBody body = this.sourceTransactionBody.getConsensusDeleteTopic();
        if (body.hasTopicID()) {
            this.topicId = TopicId.fromProtobuf(body.getTopicID());
        }
    }

    ConsensusDeleteTopicTransactionBody.Builder build() {
        ConsensusDeleteTopicTransactionBody.Builder builder = ConsensusDeleteTopicTransactionBody.newBuilder();
        if (this.topicId != null) {
            builder.setTopicID(this.topicId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.topicId != null) {
            this.topicId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ConsensusServiceGrpc.getDeleteTopicMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setConsensusDeleteTopic(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setConsensusDeleteTopic(this.build());
    }
}

