/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.TokenWipeAccountTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class TokenWipeTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenWipeTransaction> {
    @Nullable
    private TokenId tokenId = null;
    @Nullable
    private AccountId accountId = null;
    private long amount = 0L;
    private List<Long> serials = new ArrayList<Long>();

    public TokenWipeTransaction() {
    }

    TokenWipeTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenWipeTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenWipeTransaction setTokenId(TokenId tokenId) {
        Objects.requireNonNull(tokenId);
        this.requireNotFrozen();
        this.tokenId = tokenId;
        return this;
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public TokenWipeTransaction setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.accountId = accountId;
        return this;
    }

    public long getAmount() {
        return this.amount;
    }

    public TokenWipeTransaction setAmount(@Nonnegative long amount) {
        this.requireNotFrozen();
        this.amount = amount;
        return this;
    }

    public List<Long> getSerials() {
        return new ArrayList<Long>(this.serials);
    }

    public TokenWipeTransaction setSerials(List<Long> serials) {
        this.requireNotFrozen();
        Objects.requireNonNull(serials);
        this.serials = new ArrayList<Long>(serials);
        return this;
    }

    public TokenWipeTransaction addSerial(@Nonnegative long serial) {
        this.requireNotFrozen();
        this.serials.add(serial);
        return this;
    }

    void initFromTransactionBody() {
        TokenWipeAccountTransactionBody body = this.sourceTransactionBody.getTokenWipe();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
        if (body.hasAccount()) {
            this.accountId = AccountId.fromProtobuf(body.getAccount());
        }
        this.amount = body.getAmount();
        this.serials = body.getSerialNumbersList();
    }

    TokenWipeAccountTransactionBody.Builder build() {
        TokenWipeAccountTransactionBody.Builder builder = TokenWipeAccountTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        if (this.accountId != null) {
            builder.setAccount(this.accountId.toProtobuf());
        }
        builder.setAmount(this.amount);
        for (Long serial : this.serials) {
            builder.addSerialNumbers(serial);
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getWipeTokenAccountMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenWipe(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenWipe(this.build());
    }
}

