/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.TokenUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

public class TokenUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenUpdateTransaction> {
    @Nullable
    private TokenId tokenId = null;
    @Nullable
    private AccountId treasuryAccountId = null;
    @Nullable
    private AccountId autoRenewAccountId = null;
    private String tokenName = "";
    private String tokenSymbol = "";
    @Nullable
    private Key adminKey = null;
    @Nullable
    private Key kycKey = null;
    @Nullable
    private Key freezeKey = null;
    @Nullable
    private Key wipeKey = null;
    @Nullable
    private Key supplyKey = null;
    @Nullable
    private Key feeScheduleKey = null;
    @Nullable
    private Key pauseKey = null;
    @Nullable
    private Instant expirationTime = null;
    @Nullable
    private Duration autoRenewPeriod = null;
    @Nullable
    private String tokenMemo = null;

    public TokenUpdateTransaction() {
    }

    TokenUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenUpdateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenUpdateTransaction setTokenId(TokenId tokenId) {
        this.requireNotFrozen();
        Objects.requireNonNull(tokenId);
        this.tokenId = tokenId;
        return this;
    }

    @Nullable
    public String getTokenName() {
        return this.tokenName;
    }

    public TokenUpdateTransaction setTokenName(String name) {
        Objects.requireNonNull(name);
        this.requireNotFrozen();
        this.tokenName = name;
        return this;
    }

    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public TokenUpdateTransaction setTokenSymbol(String symbol) {
        Objects.requireNonNull(symbol);
        this.requireNotFrozen();
        this.tokenSymbol = symbol;
        return this;
    }

    @Nullable
    public AccountId getTreasuryAccountId() {
        return this.treasuryAccountId;
    }

    public TokenUpdateTransaction setTreasuryAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.treasuryAccountId = accountId;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public TokenUpdateTransaction setAdminKey(Key key) {
        this.requireNotFrozen();
        Objects.requireNonNull(key);
        this.adminKey = key;
        return this;
    }

    @Nullable
    public Key getKycKey() {
        return this.kycKey;
    }

    public TokenUpdateTransaction setKycKey(Key key) {
        this.requireNotFrozen();
        this.kycKey = key;
        return this;
    }

    @Nullable
    public Key getFreezeKey() {
        return this.freezeKey;
    }

    public TokenUpdateTransaction setFreezeKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.freezeKey = key;
        return this;
    }

    @Nullable
    public Key getWipeKey() {
        return this.wipeKey;
    }

    public TokenUpdateTransaction setWipeKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.wipeKey = key;
        return this;
    }

    @Nullable
    public Key getSupplyKey() {
        return this.supplyKey;
    }

    public TokenUpdateTransaction setSupplyKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.supplyKey = key;
        return this;
    }

    @Nullable
    public Key getFeeScheduleKey() {
        return this.feeScheduleKey;
    }

    public TokenUpdateTransaction setFeeScheduleKey(Key key) {
        this.requireNotFrozen();
        Objects.requireNonNull(key);
        this.feeScheduleKey = key;
        return this;
    }

    @Nullable
    public Key getPauseKey() {
        return this.pauseKey;
    }

    public TokenUpdateTransaction setPauseKey(Key key) {
        this.requireNotFrozen();
        Objects.requireNonNull(key);
        this.pauseKey = key;
        return this;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public TokenUpdateTransaction setExpirationTime(Instant expirationTime) {
        Objects.requireNonNull(expirationTime);
        this.requireNotFrozen();
        this.autoRenewPeriod = null;
        this.expirationTime = expirationTime;
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public TokenUpdateTransaction setAutoRenewAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.autoRenewAccountId = accountId;
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public TokenUpdateTransaction setAutoRenewPeriod(Duration period) {
        Objects.requireNonNull(period);
        this.requireNotFrozen();
        this.autoRenewPeriod = period;
        return this;
    }

    @Nullable
    public String getTokenMemo() {
        return this.tokenMemo;
    }

    public TokenUpdateTransaction setTokenMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.tokenMemo = memo;
        return this;
    }

    public TokenUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.tokenMemo = "";
        return this;
    }

    void initFromTransactionBody() {
        TokenUpdateTransactionBody body = this.sourceTransactionBody.getTokenUpdate();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
        if (body.hasTreasury()) {
            this.treasuryAccountId = AccountId.fromProtobuf(body.getTreasury());
        }
        if (body.hasAutoRenewAccount()) {
            this.autoRenewAccountId = AccountId.fromProtobuf(body.getAutoRenewAccount());
        }
        this.tokenName = body.getName();
        this.tokenSymbol = body.getSymbol();
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        if (body.hasKycKey()) {
            this.kycKey = Key.fromProtobufKey(body.getKycKey());
        }
        if (body.hasFreezeKey()) {
            this.freezeKey = Key.fromProtobufKey(body.getFreezeKey());
        }
        if (body.hasWipeKey()) {
            this.wipeKey = Key.fromProtobufKey(body.getWipeKey());
        }
        if (body.hasSupplyKey()) {
            this.supplyKey = Key.fromProtobufKey(body.getSupplyKey());
        }
        if (body.hasFeeScheduleKey()) {
            this.feeScheduleKey = Key.fromProtobufKey(body.getFeeScheduleKey());
        }
        if (body.hasPauseKey()) {
            this.pauseKey = Key.fromProtobufKey(body.getPauseKey());
        }
        if (body.hasExpiry()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpiry());
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        if (body.hasMemo()) {
            this.tokenMemo = body.getMemo().getValue();
        }
    }

    TokenUpdateTransactionBody.Builder build() {
        TokenUpdateTransactionBody.Builder builder = TokenUpdateTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        if (this.treasuryAccountId != null) {
            builder.setTreasury(this.treasuryAccountId.toProtobuf());
        }
        if (this.autoRenewAccountId != null) {
            builder.setAutoRenewAccount(this.autoRenewAccountId.toProtobuf());
        }
        builder.setName(this.tokenName);
        builder.setSymbol(this.tokenSymbol);
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.kycKey != null) {
            builder.setKycKey(this.kycKey.toProtobufKey());
        }
        if (this.freezeKey != null) {
            builder.setFreezeKey(this.freezeKey.toProtobufKey());
        }
        if (this.wipeKey != null) {
            builder.setWipeKey(this.wipeKey.toProtobufKey());
        }
        if (this.supplyKey != null) {
            builder.setSupplyKey(this.supplyKey.toProtobufKey());
        }
        if (this.feeScheduleKey != null) {
            builder.setFeeScheduleKey(this.feeScheduleKey.toProtobufKey());
        }
        if (this.pauseKey != null) {
            builder.setPauseKey(this.pauseKey.toProtobufKey());
        }
        if (this.expirationTime != null) {
            builder.setExpiry(InstantConverter.toProtobuf(this.expirationTime));
        }
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        if (this.tokenMemo != null) {
            builder.setMemo(StringValue.of(this.tokenMemo));
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
        if (this.treasuryAccountId != null) {
            this.treasuryAccountId.validateChecksum(client);
        }
        if (this.autoRenewAccountId != null) {
            this.autoRenewAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getUpdateTokenMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenUpdate(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenUpdate(this.build());
    }
}

