/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.AccountAmount;
import com.hedera.hashgraph.sdk.proto.TokenTransferList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class TokenTransfer {
    final TokenId tokenId;
    final AccountId accountId;
    @Nullable
    Integer expectedDecimals;
    long amount;
    boolean isApproved;

    TokenTransfer(TokenId tokenId, AccountId accountId, long amount, boolean isApproved) {
        this(tokenId, accountId, amount, null, isApproved);
    }

    TokenTransfer(TokenId tokenId, AccountId accountId, long amount, @Nullable Integer expectedDecimals, boolean isApproved) {
        this.tokenId = tokenId;
        this.accountId = accountId;
        this.amount = amount;
        this.expectedDecimals = expectedDecimals;
        this.isApproved = isApproved;
    }

    static List<TokenTransfer> fromProtobuf(List<TokenTransferList> tokenTransferLists) {
        ArrayList<TokenTransfer> transfers = new ArrayList<TokenTransfer>();
        for (TokenTransferList tokenTransferList : tokenTransferLists) {
            TokenId tokenId = TokenId.fromProtobuf(tokenTransferList.getToken());
            for (AccountAmount transfer : tokenTransferList.getTransfersList()) {
                transfers.add(new TokenTransfer(tokenId, AccountId.fromProtobuf(transfer.getAccountID()), transfer.getAmount(), tokenTransferList.hasExpectedDecimals() ? Integer.valueOf(tokenTransferList.getExpectedDecimals().getValue()) : null, transfer.getIsApproval()));
            }
        }
        return transfers;
    }

    AccountAmount toProtobuf() {
        return (AccountAmount)AccountAmount.newBuilder().setAccountID(this.accountId.toProtobuf()).setAmount(this.amount).setIsApproval(this.isApproved).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tokenId", this.tokenId).add("accountId", this.accountId).add("amount", this.amount).add("expectedDecimals", this.expectedDecimals).add("isApproved", this.isApproved).toString();
    }
}

