/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.TokenFreezeStatus;
import com.hedera.hashgraph.sdk.proto.TokenKycStatus;
import com.hedera.hashgraph.sdk.proto.TokenRelationship;
import javax.annotation.Nullable;

public class TokenRelationship {
    public final TokenId tokenId;
    public final String symbol;
    public final long balance;
    @Nullable
    public final Boolean kycStatus;
    @Nullable
    public final Boolean freezeStatus;
    public final boolean automaticAssociation;

    TokenRelationship(TokenId tokenId, String symbol, long balance, @Nullable Boolean kycStatus, @Nullable Boolean freezeStatus, boolean automaticAssociation) {
        this.tokenId = tokenId;
        this.symbol = symbol;
        this.balance = balance;
        this.kycStatus = kycStatus;
        this.freezeStatus = freezeStatus;
        this.automaticAssociation = automaticAssociation;
    }

    @Nullable
    static Boolean freezeStatusFromProtobuf(TokenFreezeStatus freezeStatus) {
        return freezeStatus == TokenFreezeStatus.FreezeNotApplicable ? null : Boolean.valueOf(freezeStatus == TokenFreezeStatus.Frozen);
    }

    @Nullable
    static Boolean kycStatusFromProtobuf(TokenKycStatus kycStatus) {
        return kycStatus == TokenKycStatus.KycNotApplicable ? null : Boolean.valueOf(kycStatus == TokenKycStatus.Granted);
    }

    static TokenRelationship fromProtobuf(com.hedera.hashgraph.sdk.proto.TokenRelationship tokenRelationship) {
        return new TokenRelationship(TokenId.fromProtobuf(tokenRelationship.getTokenId()), tokenRelationship.getSymbol(), tokenRelationship.getBalance(), TokenRelationship.kycStatusFromProtobuf(tokenRelationship.getKycStatus()), TokenRelationship.freezeStatusFromProtobuf(tokenRelationship.getFreezeStatus()), tokenRelationship.getAutomaticAssociation());
    }

    public static TokenRelationship fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenRelationship.fromProtobuf((com.hedera.hashgraph.sdk.proto.TokenRelationship)((TokenRelationship.Builder)com.hedera.hashgraph.sdk.proto.TokenRelationship.parseFrom(bytes).toBuilder()).build());
    }

    static TokenFreezeStatus freezeStatusToProtobuf(@Nullable Boolean freezeStatus) {
        return freezeStatus == null ? TokenFreezeStatus.FreezeNotApplicable : (freezeStatus != false ? TokenFreezeStatus.Frozen : TokenFreezeStatus.Unfrozen);
    }

    static TokenKycStatus kycStatusToProtobuf(@Nullable Boolean kycStatus) {
        return kycStatus == null ? TokenKycStatus.KycNotApplicable : (kycStatus != false ? TokenKycStatus.Granted : TokenKycStatus.Revoked);
    }

    com.hedera.hashgraph.sdk.proto.TokenRelationship toProtobuf() {
        return (com.hedera.hashgraph.sdk.proto.TokenRelationship)com.hedera.hashgraph.sdk.proto.TokenRelationship.newBuilder().setTokenId(this.tokenId.toProtobuf()).setSymbol(this.symbol).setBalance(this.balance).setKycStatus(TokenRelationship.kycStatusToProtobuf(this.kycStatus)).setFreezeStatus(TokenRelationship.freezeStatusToProtobuf(this.freezeStatus)).setAutomaticAssociation(this.automaticAssociation).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tokenId", this.tokenId).add("symbol", this.symbol).add("balance", this.balance).add("kycStatus", this.kycStatus).add("freezeStatus", this.freezeStatus).add("automaticAssociation", this.automaticAssociation).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

