/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenMintTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class TokenMintTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenMintTransaction> {
    @Nullable
    private TokenId tokenId = null;
    private List<byte[]> metadataList = new ArrayList<byte[]>();
    private long amount = 0L;

    public TokenMintTransaction() {
    }

    TokenMintTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenMintTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenMintTransaction setTokenId(@Nullable TokenId tokenId) {
        Objects.requireNonNull(tokenId);
        this.requireNotFrozen();
        this.tokenId = tokenId;
        return this;
    }

    public long getAmount() {
        return this.amount;
    }

    public TokenMintTransaction setAmount(@Nonnegative long amount) {
        this.requireNotFrozen();
        this.amount = amount;
        return this;
    }

    public TokenMintTransaction addMetadata(byte[] metadata) {
        this.requireNotFrozen();
        Objects.requireNonNull(metadata);
        this.metadataList.add(metadata);
        return this;
    }

    public List<byte[]> getMetadata() {
        return new ArrayList<byte[]>(this.metadataList);
    }

    public TokenMintTransaction setMetadata(List<byte[]> metadataList) {
        this.requireNotFrozen();
        this.metadataList = new ArrayList<byte[]>(metadataList);
        return this;
    }

    void initFromTransactionBody() {
        TokenMintTransactionBody body = this.sourceTransactionBody.getTokenMint();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
        this.amount = body.getAmount();
        for (ByteString metadata : body.getMetadataList()) {
            this.metadataList.add(metadata.toByteArray());
        }
    }

    TokenMintTransactionBody.Builder build() {
        TokenMintTransactionBody.Builder builder = TokenMintTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        builder.setAmount(this.amount);
        for (byte[] metadata : this.metadataList) {
            builder.addMetadata(ByteString.copyFrom(metadata));
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getMintTokenMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenMint(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenMint(this.build());
    }
}

