/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.proto.TokenID;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class TokenId
implements Comparable<TokenId> {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    @Nullable
    private final String checksum;

    public TokenId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public TokenId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this(shard, realm, num, null);
    }

    TokenId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
    }

    public static TokenId fromString(String id) {
        return EntityIdHelper.fromString(id, TokenId::new);
    }

    static TokenId fromProtobuf(TokenID tokenId) {
        Objects.requireNonNull(tokenId);
        return new TokenId(tokenId.getShardNum(), tokenId.getRealmNum(), tokenId.getTokenNum());
    }

    public static TokenId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenId.fromProtobuf((TokenID)((TokenID.Builder)TokenID.parseFrom(bytes).toBuilder()).build());
    }

    public static TokenId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, TokenId::new);
    }

    public NftId nft(@Nonnegative long serial) {
        return new NftId(this, serial);
    }

    public String toSolidityAddress() {
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    TokenID toProtobuf() {
        return (TokenID)TokenID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setTokenNum(this.num).build();
    }

    @Deprecated
    public void validate(Client client) throws BadEntityIdException {
        this.validateChecksum(client);
    }

    public void validateChecksum(Client client) throws BadEntityIdException {
        EntityIdHelper.validate(this.shard, this.realm, this.num, client, this.checksum);
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return EntityIdHelper.toString(this.shard, this.realm, this.num);
    }

    public String toStringWithChecksum(Client client) {
        return EntityIdHelper.toStringWithChecksum(this.shard, this.realm, this.num, client, this.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenId)) {
            return false;
        }
        TokenId otherId = (TokenId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }

    @Override
    public int compareTo(TokenId o) {
        Objects.requireNonNull(o);
        int shardComparison = Long.compare(this.shard, o.shard);
        if (shardComparison != 0) {
            return shardComparison;
        }
        int realmComparison = Long.compare(this.realm, o.realm);
        if (realmComparison != 0) {
            return realmComparison;
        }
        return Long.compare(this.num, o.num);
    }
}

