/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenDeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenDeleteTransaction> {
    @Nullable
    private TokenId tokenId = null;

    public TokenDeleteTransaction() {
    }

    TokenDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenDeleteTransaction setTokenId(TokenId tokenId) {
        Objects.requireNonNull(tokenId);
        this.requireNotFrozen();
        this.tokenId = tokenId;
        return this;
    }

    void initFromTransactionBody() {
        TokenDeleteTransactionBody body = this.sourceTransactionBody.getTokenDeletion();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
    }

    TokenDeleteTransactionBody.Builder build() {
        TokenDeleteTransactionBody.Builder builder = TokenDeleteTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getDeleteTokenMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenDeletion(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenDeletion(this.build());
    }
}

