/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenBurnTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class TokenBurnTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenBurnTransaction> {
    @Nullable
    private TokenId tokenId = null;
    private long amount = 0L;
    private List<Long> serials = new ArrayList<Long>();

    public TokenBurnTransaction() {
    }

    TokenBurnTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenBurnTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenBurnTransaction setTokenId(TokenId tokenId) {
        Objects.requireNonNull(tokenId);
        this.requireNotFrozen();
        this.tokenId = tokenId;
        return this;
    }

    public long getAmount() {
        return this.amount;
    }

    public TokenBurnTransaction setAmount(@Nonnegative long amount) {
        this.requireNotFrozen();
        this.amount = amount;
        return this;
    }

    public List<Long> getSerials() {
        return new ArrayList<Long>(this.serials);
    }

    public TokenBurnTransaction setSerials(List<Long> serials) {
        this.requireNotFrozen();
        Objects.requireNonNull(serials);
        this.serials = new ArrayList<Long>(serials);
        return this;
    }

    public TokenBurnTransaction addSerial(@Nonnegative long serial) {
        this.requireNotFrozen();
        this.serials.add(serial);
        return this;
    }

    TokenBurnTransactionBody.Builder build() {
        TokenBurnTransactionBody.Builder builder = TokenBurnTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        builder.setAmount(this.amount);
        for (Long serial : this.serials) {
            builder.addSerialNumbers(serial);
        }
        return builder;
    }

    void initFromTransactionBody() {
        TokenBurnTransactionBody body = this.sourceTransactionBody.getTokenBurn();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
        this.amount = body.getAmount();
        this.serials = body.getSerialNumbersList();
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getBurnTokenMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenBurn(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenBurn(this.build());
    }
}

