/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.proto.StakingInfo;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

public class StakingInfo {
    public final boolean declineStakingReward;
    public final Instant stakePeriodStart;
    public final Hbar pendingReward;
    public final Hbar stakedToMe;
    @Nullable
    public final AccountId stakedAccountId;
    @Nullable
    public final Long stakedNodeId;

    public StakingInfo(boolean declineStakingReward, Instant stakePeriodStart, Hbar pendingReward, Hbar stakedToMe, @Nullable AccountId stakedAccountId, @Nullable Long stakedNodeId) {
        this.declineStakingReward = declineStakingReward;
        this.stakePeriodStart = stakePeriodStart;
        this.pendingReward = pendingReward;
        this.stakedToMe = stakedToMe;
        this.stakedAccountId = stakedAccountId;
        this.stakedNodeId = stakedNodeId;
    }

    static StakingInfo fromProtobuf(com.hedera.hashgraph.sdk.proto.StakingInfo info) {
        return new StakingInfo(info.getDeclineReward(), InstantConverter.fromProtobuf(info.getStakePeriodStart()), Hbar.fromTinybars(info.getPendingReward()), Hbar.fromTinybars(info.getStakedToMe()), info.hasStakedAccountId() ? AccountId.fromProtobuf(info.getStakedAccountId()) : null, info.hasStakedNodeId() ? Long.valueOf(info.getStakedNodeId()) : null);
    }

    public static StakingInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return StakingInfo.fromProtobuf(com.hedera.hashgraph.sdk.proto.StakingInfo.parseFrom(bytes));
    }

    com.hedera.hashgraph.sdk.proto.StakingInfo toProtobuf() {
        StakingInfo.Builder builder = com.hedera.hashgraph.sdk.proto.StakingInfo.newBuilder().setDeclineReward(this.declineStakingReward).setStakePeriodStart(InstantConverter.toProtobuf(this.stakePeriodStart)).setPendingReward(this.pendingReward.toTinybars()).setStakedToMe(this.stakedToMe.toTinybars());
        if (this.stakedAccountId != null) {
            builder.setStakedAccountId(this.stakedAccountId.toProtobuf());
        }
        if (this.stakedNodeId != null) {
            builder.setStakedNodeId(this.stakedNodeId);
        }
        return (com.hedera.hashgraph.sdk.proto.StakingInfo)builder.build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("declineStakingReward", this.declineStakingReward).add("stakePeriodStart", this.stakePeriodStart).add("pendingReward", this.pendingReward).add("stakedToMe", this.stakedToMe).add("stakedAccountId", this.stakedAccountId).add("stakedNodeId", this.stakedNodeId).toString();
    }
}

