/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.ScheduleID;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class ScheduleId
implements Comparable<ScheduleId> {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    @Nullable
    private final String checksum;

    public ScheduleId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public ScheduleId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this(shard, realm, num, null);
    }

    ScheduleId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
    }

    public static ScheduleId fromString(String id) {
        return EntityIdHelper.fromString(id, ScheduleId::new);
    }

    static ScheduleId fromProtobuf(ScheduleID scheduleId) {
        Objects.requireNonNull(scheduleId);
        return new ScheduleId(scheduleId.getShardNum(), scheduleId.getRealmNum(), scheduleId.getScheduleNum());
    }

    public static ScheduleId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ScheduleId.fromProtobuf((ScheduleID)((ScheduleID.Builder)ScheduleID.parseFrom(bytes).toBuilder()).build());
    }

    ScheduleID toProtobuf() {
        return (ScheduleID)ScheduleID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setScheduleNum(this.num).build();
    }

    @Deprecated
    public void validate(Client client) throws BadEntityIdException {
        this.validateChecksum(client);
    }

    public void validateChecksum(Client client) throws BadEntityIdException {
        EntityIdHelper.validate(this.shard, this.realm, this.num, client, this.checksum);
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return EntityIdHelper.toString(this.shard, this.realm, this.num);
    }

    public String toStringWithChecksum(Client client) {
        return EntityIdHelper.toStringWithChecksum(this.shard, this.realm, this.num, client, this.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleId)) {
            return false;
        }
        ScheduleId otherId = (ScheduleId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }

    @Override
    public int compareTo(ScheduleId o) {
        Objects.requireNonNull(o);
        int shardComparison = Long.compare(this.shard, o.shard);
        if (shardComparison != 0) {
            return shardComparison;
        }
        int realmComparison = Long.compare(this.realm, o.realm);
        if (realmComparison != 0) {
            return realmComparison;
        }
        return Long.compare(this.num, o.num);
    }
}

