/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BadKeyException;
import com.hedera.hashgraph.sdk.Crypto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

final class Pem {
    private static final String TYPE_PRIVATE_KEY = "PRIVATE KEY";
    private static final String TYPE_ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";

    private Pem() {
    }

    static void writeEncryptedPrivateKey(PrivateKeyInfo pkInfo, Writer out, String passphrase) throws IOException {
        byte[] salt = Crypto.randomBytes(32);
        KeyParameter derivedKey = Crypto.deriveKeySha256(passphrase, salt, 262144, 16);
        byte[] iv = Crypto.randomBytes(16);
        Cipher cipher = Crypto.initAesCbc128Encrypt(derivedKey, iv);
        byte[] encryptedKey = Crypto.runCipher(cipher, pkInfo.getEncoded());
        PBES2Parameters parameters = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(salt, 262144, 16, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256))), new EncryptionScheme(NISTObjectIdentifiers.id_aes128_CBC, ASN1Primitive.fromByteArray(cipher.getParameters().getEncoded())));
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, parameters), encryptedKey);
        PemWriter writer = new PemWriter(out);
        writer.writeObject(new PemObject(TYPE_ENCRYPTED_PRIVATE_KEY, encryptedPrivateKeyInfo.getEncoded()));
        writer.flush();
    }

    static PrivateKeyInfo readPrivateKey(Reader input, @Nullable String passphrase) throws IOException {
        PemObject nextObject;
        PemReader pemReader = new PemReader(input);
        PemObject readObject = null;
        while ((nextObject = pemReader.readPemObject()) != null) {
            readObject = nextObject;
            String objType = readObject.getType();
            if (passphrase != null && !passphrase.isEmpty() && objType.equals(TYPE_ENCRYPTED_PRIVATE_KEY)) {
                return Pem.decryptPrivateKey(readObject.getContent(), passphrase);
            }
            if (!objType.equals(TYPE_PRIVATE_KEY)) continue;
            return PrivateKeyInfo.getInstance(readObject.getContent());
        }
        if (readObject != null && readObject.getType().equals(TYPE_ENCRYPTED_PRIVATE_KEY)) {
            throw new BadKeyException("PEM file contained an encrypted private key but no passphrase was given");
        }
        throw new BadKeyException("PEM file did not contain a private key");
    }

    private static PrivateKeyInfo decryptPrivateKey(byte[] encodedStruct, String passphrase) throws IOException {
        AlgorithmParameters aesParams;
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(encodedStruct));
        AlgorithmIdentifier encryptAlg = encryptedPrivateKeyInfo.getEncryptionAlgorithm();
        if (!encryptAlg.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBES2)) {
            throw new BadKeyException("unsupported PEM key encryption: " + encryptAlg);
        }
        PBES2Parameters params = PBES2Parameters.getInstance(encryptAlg.getParameters());
        KeyDerivationFunc kdf = params.getKeyDerivationFunc();
        EncryptionScheme encScheme = params.getEncryptionScheme();
        if (!kdf.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBKDF2)) {
            throw new BadKeyException("unsupported KDF: " + kdf.getAlgorithm());
        }
        if (!encScheme.getAlgorithm().equals(NISTObjectIdentifiers.id_aes128_CBC)) {
            throw new BadKeyException("unsupported encryption: " + encScheme.getAlgorithm());
        }
        PBKDF2Params kdfParams = PBKDF2Params.getInstance(kdf.getParameters());
        if (!kdfParams.getPrf().getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA256)) {
            throw new BadKeyException("unsupported PRF: " + kdfParams.getPrf());
        }
        int keyLength = kdfParams.getKeyLength() != null ? kdfParams.getKeyLength().intValue() : 16;
        KeyParameter derivedKey = Crypto.deriveKeySha256(passphrase, kdfParams.getSalt(), kdfParams.getIterationCount().intValue(), keyLength);
        try {
            aesParams = AlgorithmParameters.getInstance("AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        aesParams.init(encScheme.getParameters().toASN1Primitive().getEncoded());
        Cipher cipher = Crypto.initAesCbc128Decrypt(derivedKey, aesParams);
        byte[] decrypted = Crypto.runCipher(cipher, encryptedPrivateKeyInfo.getEncryptedData());
        ASN1InputStream inputStream = new ASN1InputStream(new ByteArrayInputStream(decrypted));
        return PrivateKeyInfo.getInstance(inputStream.readObject());
    }
}

