/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Endpoint;
import com.hedera.hashgraph.sdk.proto.NodeAddress;
import com.hedera.hashgraph.sdk.proto.ServiceEndpoint;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class NodeAddress {
    @Nullable
    String publicKey;
    @Nullable
    AccountId accountId;
    long nodeId;
    @Nullable
    ByteString certHash;
    List<Endpoint> addresses = Collections.emptyList();
    @Nullable
    String description = null;
    long stake;

    NodeAddress() {
    }

    static NodeAddress fromProtobuf(com.hedera.hashgraph.sdk.proto.NodeAddress nodeAddress) {
        ArrayList<Endpoint> address = new ArrayList<Endpoint>(nodeAddress.getServiceEndpointCount());
        if (!nodeAddress.getIpAddress().isEmpty()) {
            address.add(Endpoint.fromProtobuf((ServiceEndpoint)ServiceEndpoint.newBuilder().setIpAddressV4(nodeAddress.getIpAddress()).setPort(nodeAddress.getPortno()).build()));
        }
        for (ServiceEndpoint endpoint : nodeAddress.getServiceEndpointList()) {
            address.add(Endpoint.fromProtobuf(endpoint));
        }
        NodeAddress node = new NodeAddress().setPublicKey(nodeAddress.getRSAPubKey()).setNodeId(nodeAddress.getNodeId()).setCertHash(nodeAddress.getNodeCertHash()).setAddresses(address).setDescription(nodeAddress.getDescription()).setStake(nodeAddress.getStake());
        if (nodeAddress.hasNodeAccountId()) {
            node.setAccountId(AccountId.fromProtobuf(nodeAddress.getNodeAccountId()));
        }
        return node;
    }

    @Nullable
    public String getPublicKey() {
        return this.publicKey;
    }

    public NodeAddress setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public NodeAddress setAccountId(AccountId accountId) {
        this.accountId = accountId;
        return this;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public NodeAddress setNodeId(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Nullable
    public ByteString getCertHash() {
        return this.certHash;
    }

    public NodeAddress setCertHash(ByteString certHash) {
        this.certHash = certHash;
        return this;
    }

    public List<Endpoint> getAddresses() {
        return this.addresses;
    }

    public NodeAddress setAddresses(List<Endpoint> addresses) {
        this.addresses = addresses;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public NodeAddress setDescription(String description) {
        this.description = description;
        return this;
    }

    public long getStake() {
        return this.stake;
    }

    public NodeAddress setStake(long stake) {
        this.stake = stake;
        return this;
    }

    com.hedera.hashgraph.sdk.proto.NodeAddress toProtobuf() {
        NodeAddress.Builder builder = com.hedera.hashgraph.sdk.proto.NodeAddress.newBuilder().setNodeId(this.nodeId);
        if (this.certHash != null) {
            builder.setNodeCertHash(this.certHash);
        }
        if (this.publicKey != null) {
            builder.setRSAPubKey(this.publicKey);
        }
        if (this.accountId != null) {
            builder.setNodeAccountId(this.accountId.toProtobuf());
        }
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        for (Endpoint address : this.addresses) {
            builder.addServiceEndpoint(address.toProtobuf());
        }
        return (com.hedera.hashgraph.sdk.proto.NodeAddress)builder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("publicKey", this.publicKey).add("accountId", this.accountId).add("nodeId", this.nodeId).add("certHash", this.certHash != null ? new String(this.certHash.toByteArray(), StandardCharsets.UTF_8) : null).add("addresses", this.addresses).add("description", this.description).add("stake", this.stake).toString();
    }
}

