/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.HederaTrustManager;
import com.hedera.hashgraph.sdk.ManagedNode;
import com.hedera.hashgraph.sdk.ManagedNodeAddress;
import com.hedera.hashgraph.sdk.NodeAddress;
import io.grpc.ChannelCredentials;
import io.grpc.TlsChannelCredentials;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

class Node
extends ManagedNode<Node, AccountId> {
    private final AccountId accountId;
    @Nullable
    private NodeAddress addressBook;
    private boolean verifyCertificates;

    Node(AccountId accountId, ManagedNodeAddress address, ExecutorService executor) {
        super(address, executor);
        this.accountId = accountId;
    }

    Node(AccountId accountId, String address, ExecutorService executor) {
        this(accountId, ManagedNodeAddress.fromString(address), executor);
    }

    Node(Node node, ManagedNodeAddress address) {
        super(node, address);
        this.accountId = node.accountId;
        this.verifyCertificates = node.verifyCertificates;
        this.addressBook = node.addressBook;
    }

    @Override
    Node toInsecure() {
        return new Node(this, this.address.toInsecure());
    }

    @Override
    Node toSecure() {
        return new Node(this, this.address.toSecure());
    }

    @Override
    AccountId getKey() {
        return this.accountId;
    }

    AccountId getAccountId() {
        return this.accountId;
    }

    NodeAddress getAddressBook() {
        return this.addressBook;
    }

    Node setAddressBook(@Nullable NodeAddress addressBook) {
        this.addressBook = addressBook;
        return this;
    }

    boolean isVerifyCertificates() {
        return this.verifyCertificates;
    }

    Node setVerifyCertificates(boolean verifyCertificates) {
        this.verifyCertificates = verifyCertificates;
        return this;
    }

    @Override
    ChannelCredentials getChannelCredentials() {
        return TlsChannelCredentials.newBuilder().trustManager(new HederaTrustManager(this.addressBook == null ? null : this.addressBook.certHash, this.verifyCertificates)).build();
    }

    public String toString() {
        return this.accountId.toString();
    }
}

