/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.ManagedNetwork;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.NodeAddress;
import com.hedera.hashgraph.sdk.NodeAddressBook;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

class Network
extends ManagedNetwork<Network, AccountId, Node> {
    @Nullable
    private Integer maxNodesPerRequest;
    @Nullable
    Map<AccountId, NodeAddress> addressBook;
    private boolean verifyCertificates = true;

    private Network(ExecutorService executor, Map<String, AccountId> network) {
        super(executor);
        try {
            this.setNetwork(network);
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
    }

    static Network forNetwork(ExecutorService executor, Map<String, AccountId> network) {
        return new Network(executor, network);
    }

    static Network forMainnet(ExecutorService executor) {
        HashMap<String, AccountId> network = new HashMap<String, AccountId>();
        network.put("35.237.200.180:50211", new AccountId(3L));
        network.put("34.239.82.6:50211", new AccountId(3L));
        network.put("13.82.40.153:50211", new AccountId(3L));
        network.put("13.124.142.126:50211", new AccountId(3L));
        network.put("15.164.44.66:50211", new AccountId(3L));
        network.put("15.165.118.251:50211", new AccountId(3L));
        network.put("35.186.191.247:50211", new AccountId(4L));
        network.put("3.130.52.236:50211", new AccountId(4L));
        network.put("137.116.36.18:50211", new AccountId(4L));
        network.put("35.192.2.25:50211", new AccountId(5L));
        network.put("3.18.18.254:50211", new AccountId(5L));
        network.put("104.43.194.202:50211", new AccountId(5L));
        network.put("23.111.186.250:50211", new AccountId(5L));
        network.put("74.50.117.35:50211", new AccountId(5L));
        network.put("107.155.64.98:50211", new AccountId(5L));
        network.put("35.199.161.108:50211", new AccountId(6L));
        network.put("13.52.108.243:50211", new AccountId(6L));
        network.put("13.64.151.232:50211", new AccountId(6L));
        network.put("13.235.15.32:50211", new AccountId(6L));
        network.put("104.211.205.124:50211", new AccountId(6L));
        network.put("13.71.90.154:50211", new AccountId(6L));
        network.put("35.203.82.240:50211", new AccountId(7L));
        network.put("3.114.54.4:50211", new AccountId(7L));
        network.put("23.102.74.34:50211", new AccountId(7L));
        network.put("35.236.5.219:50211", new AccountId(8L));
        network.put("35.183.66.150:50211", new AccountId(8L));
        network.put("23.96.185.18:50211", new AccountId(8L));
        network.put("35.197.192.225:50211", new AccountId(9L));
        network.put("35.181.158.250:50211", new AccountId(9L));
        network.put("23.97.237.125:50211", new AccountId(9L));
        network.put("31.214.8.131:50211", new AccountId(9L));
        network.put("35.242.233.154:50211", new AccountId(10L));
        network.put("3.248.27.48:50211", new AccountId(10L));
        network.put("65.52.68.254:50211", new AccountId(10L));
        network.put("179.190.33.184:50211", new AccountId(10L));
        network.put("35.240.118.96:50211", new AccountId(11L));
        network.put("13.53.119.185:50211", new AccountId(11L));
        network.put("23.97.247.27:50211", new AccountId(11L));
        network.put("69.87.222.61:50211", new AccountId(11L));
        network.put("96.126.72.172:50211", new AccountId(11L));
        network.put("69.87.221.231:50211", new AccountId(11L));
        network.put("35.204.86.32:50211", new AccountId(12L));
        network.put("35.177.162.180:50211", new AccountId(12L));
        network.put("51.140.102.228:50211", new AccountId(12L));
        network.put("35.234.132.107:50211", new AccountId(13L));
        network.put("34.215.192.104:50211", new AccountId(13L));
        network.put("13.77.158.252:50211", new AccountId(13L));
        network.put("35.236.2.27:50211", new AccountId(14L));
        network.put("52.8.21.141:50211", new AccountId(14L));
        network.put("40.114.107.85:50211", new AccountId(14L));
        network.put("35.228.11.53:50211", new AccountId(15L));
        network.put("3.121.238.26:50211", new AccountId(15L));
        network.put("40.89.139.247:50211", new AccountId(15L));
        network.put("34.91.181.183:50211", new AccountId(16L));
        network.put("18.157.223.230:50211", new AccountId(16L));
        network.put("13.69.120.73:50211", new AccountId(16L));
        network.put("50.7.176.235:50211", new AccountId(16L));
        network.put("198.16.99.40:50211", new AccountId(16L));
        network.put("50.7.124.46:50211", new AccountId(16L));
        network.put("34.86.212.247:50211", new AccountId(17L));
        network.put("18.232.251.19:50211", new AccountId(17L));
        network.put("40.114.92.39:50211", new AccountId(17L));
        network.put("172.105.247.67:50211", new AccountId(18L));
        network.put("172.104.150.132:50211", new AccountId(18L));
        network.put("139.162.156.222:50211", new AccountId(18L));
        network.put("34.89.87.138:50211", new AccountId(19L));
        network.put("18.168.4.59:50211", new AccountId(19L));
        network.put("51.140.43.81:50211", new AccountId(19L));
        network.put("34.82.78.255:50211", new AccountId(20L));
        network.put("13.77.151.212:50211", new AccountId(20L));
        network.put("34.76.140.109:50211", new AccountId(21L));
        network.put("13.36.123.209:50211", new AccountId(21L));
        network.put("34.64.141.166:50211", new AccountId(22L));
        network.put("52.78.202.34:50211", new AccountId(22L));
        network.put("35.232.244.145:50211", new AccountId(23L));
        network.put("3.18.91.176:50211", new AccountId(23L));
        network.put("34.89.103.38:50211", new AccountId(24L));
        network.put("18.135.7.211:50211", new AccountId(24L));
        network.put("34.93.112.7:50211", new AccountId(25L));
        network.put("13.232.240.207:50211", new AccountId(25L));
        network.put("34.87.150.174:50211", new AccountId(26L));
        network.put("13.228.103.14:50211", new AccountId(26L));
        return new Network(executor, network).setLedgerId(LedgerId.MAINNET);
    }

    static Network forTestnet(ExecutorService executor) {
        HashMap<String, AccountId> network = new HashMap<String, AccountId>();
        network.put("0.testnet.hedera.com:50211", new AccountId(3L));
        network.put("34.94.106.61:50211", new AccountId(3L));
        network.put("50.18.132.211:50211", new AccountId(3L));
        network.put("138.91.142.219:50211", new AccountId(3L));
        network.put("1.testnet.hedera.com:50211", new AccountId(4L));
        network.put("35.237.119.55:50211", new AccountId(4L));
        network.put("3.212.6.13:50211", new AccountId(4L));
        network.put("52.168.76.241:50211", new AccountId(4L));
        network.put("2.testnet.hedera.com:50211", new AccountId(5L));
        network.put("35.245.27.193:50211", new AccountId(5L));
        network.put("52.20.18.86:50211", new AccountId(5L));
        network.put("40.79.83.124:50211", new AccountId(5L));
        network.put("3.testnet.hedera.com:50211", new AccountId(6L));
        network.put("34.83.112.116:50211", new AccountId(6L));
        network.put("54.70.192.33:50211", new AccountId(6L));
        network.put("52.183.45.65:50211", new AccountId(6L));
        network.put("4.testnet.hedera.com:50211", new AccountId(7L));
        network.put("34.94.160.4:50211", new AccountId(7L));
        network.put("54.176.199.109:50211", new AccountId(7L));
        network.put("13.64.181.136:50211", new AccountId(7L));
        network.put("5.testnet.hedera.com:50211", new AccountId(8L));
        network.put("34.106.102.218:50211", new AccountId(8L));
        network.put("35.155.49.147:50211", new AccountId(8L));
        network.put("13.78.238.32:50211", new AccountId(8L));
        network.put("6.testnet.hedera.com:50211", new AccountId(9L));
        network.put("34.133.197.230:50211", new AccountId(9L));
        network.put("52.14.252.207:50211", new AccountId(9L));
        network.put("52.165.17.231:50211", new AccountId(9L));
        return new Network(executor, network).setLedgerId(LedgerId.TESTNET);
    }

    static Network forPreviewnet(ExecutorService executor) {
        HashMap<String, AccountId> network = new HashMap<String, AccountId>();
        network.put("0.previewnet.hedera.com:50211", new AccountId(3L));
        network.put("35.231.208.148:50211", new AccountId(3L));
        network.put("3.211.248.172:50211", new AccountId(3L));
        network.put("40.121.64.48:50211", new AccountId(3L));
        network.put("1.previewnet.hedera.com:50211", new AccountId(4L));
        network.put("35.199.15.177:50211", new AccountId(4L));
        network.put("3.133.213.146:50211", new AccountId(4L));
        network.put("40.70.11.202:50211", new AccountId(4L));
        network.put("2.previewnet.hedera.com:50211", new AccountId(5L));
        network.put("35.225.201.195:50211", new AccountId(5L));
        network.put("52.15.105.130:50211", new AccountId(5L));
        network.put("104.43.248.63:50211", new AccountId(5L));
        network.put("3.previewnet.hedera.com:50211", new AccountId(6L));
        network.put("35.247.109.135:50211", new AccountId(6L));
        network.put("54.241.38.1:50211", new AccountId(6L));
        network.put("13.88.22.47:50211", new AccountId(6L));
        network.put("4.previewnet.hedera.com:50211", new AccountId(7L));
        network.put("35.235.65.51:50211", new AccountId(7L));
        network.put("54.177.51.127:50211", new AccountId(7L));
        network.put("13.64.170.40:50211", new AccountId(7L));
        network.put("5.previewnet.hedera.com:50211", new AccountId(8L));
        network.put("34.106.247.65:50211", new AccountId(8L));
        network.put("35.83.89.171:50211", new AccountId(8L));
        network.put("13.78.232.192:50211", new AccountId(8L));
        network.put("6.previewnet.hedera.com:50211", new AccountId(9L));
        network.put("34.125.23.49:50211", new AccountId(9L));
        network.put("50.18.17.93:50211", new AccountId(9L));
        network.put("20.150.136.89:50211", new AccountId(9L));
        return new Network(executor, network).setLedgerId(LedgerId.PREVIEWNET);
    }

    boolean isVerifyCertificates() {
        return this.verifyCertificates;
    }

    Network setVerifyCertificates(boolean verifyCertificates) {
        this.verifyCertificates = verifyCertificates;
        for (Node node : this.nodes) {
            node.setVerifyCertificates(verifyCertificates);
        }
        return this;
    }

    @Override
    synchronized Network setLedgerId(@Nullable LedgerId ledgerId) {
        super.setLedgerId(ledgerId);
        this.addressBook = ledgerId == null || !ledgerId.isKnownNetwork() ? null : Network.readAddressBookResource("addressbook/" + ledgerId + ".pb");
        for (Node node : this.nodes) {
            node.setAddressBook(this.addressBook == null ? null : this.addressBook.get(node.getAccountId()));
        }
        return this;
    }

    static Map<AccountId, NodeAddress> readAddressBookResource(String fileName) {
        HashMap<AccountId, NodeAddress> hashMap;
        block9: {
            InputStream inputStream = Resources.getResource(fileName).openStream();
            try {
                byte[] contents = ByteStreams.toByteArray(inputStream);
                NodeAddressBook nodeAddressBook = NodeAddressBook.fromBytes(ByteString.copyFrom(contents));
                HashMap<AccountId, NodeAddress> map = new HashMap<AccountId, NodeAddress>();
                for (NodeAddress nodeAddress : nodeAddressBook.nodeAddresses) {
                    if (nodeAddress.accountId == null) continue;
                    map.put(nodeAddress.accountId, nodeAddress);
                }
                hashMap = map;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return hashMap;
    }

    Map<String, AccountId> getNetwork() {
        HashMap<String, AccountId> returnMap = new HashMap<String, AccountId>();
        for (Node node : this.nodes) {
            returnMap.put(node.address.toString(), node.getAccountId());
        }
        return returnMap;
    }

    @Override
    protected Node createNodeFromNetworkEntry(Map.Entry<String, AccountId> entry) {
        return new Node(entry.getValue(), entry.getKey(), this.executor).setVerifyCertificates(this.verifyCertificates);
    }

    synchronized List<AccountId> getNodeAccountIdsForExecute() throws InterruptedException {
        List nodes = this.getNumberOfMostHealthyNodes(this.getNumberOfNodesForRequest());
        ArrayList<AccountId> nodeAccountIds = new ArrayList<AccountId>(nodes.size());
        for (Node node : nodes) {
            nodeAccountIds.add(node.getAccountId());
        }
        return nodeAccountIds;
    }

    Network setMaxNodesPerRequest(int maxNodesPerRequest) {
        this.maxNodesPerRequest = maxNodesPerRequest;
        return this;
    }

    int getNumberOfNodesForRequest() {
        if (this.maxNodesPerRequest != null) {
            return Math.min(this.maxNodesPerRequest, this.network.size());
        }
        return (this.network.size() + 3 - 1) / 3;
    }
}

