/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.ManagedNetwork;
import com.hedera.hashgraph.sdk.ManagedNodeAddress;
import com.hedera.hashgraph.sdk.MirrorNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;

class MirrorNetwork
extends ManagedNetwork<MirrorNetwork, ManagedNodeAddress, MirrorNode> {
    private MirrorNetwork(ExecutorService executor, List<String> addresses) {
        super(executor);
        try {
            this.setNetwork(addresses);
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
    }

    static MirrorNetwork forNetwork(ExecutorService executor, List<String> addresses) {
        return new MirrorNetwork(executor, addresses);
    }

    static MirrorNetwork forMainnet(ExecutorService executor) {
        return new MirrorNetwork(executor, List.of("hcs.mainnet.mirrornode.hedera.com:5600"));
    }

    static MirrorNetwork forTestnet(ExecutorService executor) {
        return new MirrorNetwork(executor, List.of("hcs.testnet.mirrornode.hedera.com:5600"));
    }

    static MirrorNetwork forPreviewnet(ExecutorService executor) {
        return new MirrorNetwork(executor, List.of("hcs.previewnet.mirrornode.hedera.com:5600"));
    }

    synchronized MirrorNetwork setNetwork(List<String> network) throws TimeoutException, InterruptedException {
        HashMap<String, ManagedNodeAddress> map = new HashMap<String, ManagedNodeAddress>(network.size());
        for (String address : network) {
            map.put(address, ManagedNodeAddress.fromString(address));
        }
        return (MirrorNetwork)super.setNetwork(map);
    }

    List<String> getNetwork() {
        ArrayList<String> retval = new ArrayList<String>(this.network.size());
        for (ManagedNodeAddress address : this.network.keySet()) {
            retval.add(address.toString());
        }
        return retval;
    }

    @Override
    protected MirrorNode createNodeFromNetworkEntry(Map.Entry<String, ManagedNodeAddress> entry) {
        return new MirrorNode(entry.getKey(), this.executor);
    }

    synchronized MirrorNode getNextMirrorNode() throws InterruptedException {
        return (MirrorNode)this.getNumberOfMostHealthyNodes(1).get(0);
    }
}

