/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Delayer;
import com.hedera.hashgraph.sdk.ManagedNodeAddress;
import io.grpc.ChannelCredentials;
import io.grpc.ConnectivityState;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

abstract class ManagedNode<N extends ManagedNode<N, KeyT>, KeyT> {
    private static final int GET_STATE_INTERVAL_MILLIS = 50;
    private static final int GET_STATE_TIMEOUT_MILLIS = 10000;
    private static final int GET_STATE_MAX_ATTEMPTS = 200;
    private boolean hasConnected = false;
    protected final ExecutorService executor;
    protected final ManagedNodeAddress address;
    protected Instant readmitTime;
    protected Duration currentBackoff;
    protected Duration minBackoff;
    protected Duration maxBackoff;
    protected long badGrpcStatusCount;
    @Nullable
    protected ManagedChannel channel = null;

    protected ManagedNode(ManagedNodeAddress address, ExecutorService executor) {
        this.executor = executor;
        this.address = address;
        this.currentBackoff = Client.DEFAULT_MIN_NODE_BACKOFF;
        this.minBackoff = Client.DEFAULT_MIN_NODE_BACKOFF;
        this.maxBackoff = Client.DEFAULT_MAX_NODE_BACKOFF;
        this.readmitTime = Instant.now();
    }

    protected ManagedNode(N node, ManagedNodeAddress address) {
        this.address = address;
        this.executor = ((ManagedNode)node).executor;
        this.minBackoff = ((ManagedNode)node).minBackoff;
        this.maxBackoff = ((ManagedNode)node).maxBackoff;
        this.readmitTime = ((ManagedNode)node).readmitTime;
        this.currentBackoff = ((ManagedNode)node).currentBackoff;
        this.badGrpcStatusCount = ((ManagedNode)node).badGrpcStatusCount;
    }

    protected String getAuthority() {
        return "127.0.0.1";
    }

    abstract N toInsecure();

    abstract N toSecure();

    abstract KeyT getKey();

    ManagedNodeAddress getAddress() {
        return this.address;
    }

    Duration getMinBackoff() {
        return this.minBackoff;
    }

    N setMinBackoff(Duration minBackoff) {
        if (this.currentBackoff == this.minBackoff) {
            this.currentBackoff = minBackoff;
        }
        this.minBackoff = minBackoff;
        return (N)this;
    }

    Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    N setMaxBackoff(Duration maxBackoff) {
        this.maxBackoff = maxBackoff;
        return (N)this;
    }

    long getBadGrpcStatusCount() {
        return this.badGrpcStatusCount;
    }

    long unhealthyBackoffRemaining() {
        return Math.max(0L, this.readmitTime.toEpochMilli() - System.currentTimeMillis());
    }

    boolean isHealthy() {
        return this.readmitTime.toEpochMilli() < Instant.now().toEpochMilli();
    }

    synchronized void increaseBackoff() {
        ++this.badGrpcStatusCount;
        this.readmitTime = Instant.now().plus(this.currentBackoff);
        this.currentBackoff = this.currentBackoff.multipliedBy(2L);
        this.currentBackoff = this.currentBackoff.compareTo(this.maxBackoff) < 0 ? this.currentBackoff : this.maxBackoff;
    }

    synchronized void decreaseBackoff() {
        this.currentBackoff = this.currentBackoff.dividedBy(2L);
        this.currentBackoff = this.currentBackoff.compareTo(this.minBackoff) > 0 ? this.currentBackoff : this.minBackoff;
    }

    long getRemainingTimeForBackoff() {
        return this.readmitTime.toEpochMilli() - System.currentTimeMillis();
    }

    ChannelCredentials getChannelCredentials() {
        return TlsChannelCredentials.create();
    }

    synchronized ManagedChannel getChannel() {
        ManagedChannelBuilder channelBuilder;
        if (this.channel != null) {
            return this.channel;
        }
        if (this.address.isInProcess()) {
            channelBuilder = InProcessChannelBuilder.forName(Objects.requireNonNull(this.address.getName()));
        } else if (this.address.isTransportSecurity()) {
            channelBuilder = Grpc.newChannelBuilder(this.address.toString(), this.getChannelCredentials());
            String authority = this.getAuthority();
            if (authority != null) {
                channelBuilder = ((ManagedChannelBuilder)channelBuilder).overrideAuthority(authority);
            }
        } else {
            channelBuilder = ManagedChannelBuilder.forTarget(this.address.toString()).usePlaintext();
        }
        this.channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)channelBuilder).keepAliveTimeout(10L, TimeUnit.SECONDS)).userAgent(this.getUserAgent())).executor(this.executor)).build();
        return this.channel;
    }

    boolean channelFailedToConnect() {
        if (this.hasConnected) {
            return false;
        }
        this.hasConnected = this.getChannel().getState(true) == ConnectivityState.READY;
        try {
            for (int i = 0; i < 200 && !this.hasConnected; ++i) {
                TimeUnit.MILLISECONDS.sleep(50L);
                this.hasConnected = this.getChannel().getState(true) == ConnectivityState.READY;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return !this.hasConnected;
    }

    private CompletableFuture<Boolean> channelFailedToConnectAsync(int i, ConnectivityState state) {
        boolean bl = this.hasConnected = state == ConnectivityState.READY;
        if (i >= 200 || this.hasConnected) {
            return CompletableFuture.completedFuture(!this.hasConnected);
        }
        return Delayer.delayFor(50L, this.executor).thenCompose(ignored -> this.channelFailedToConnectAsync(i + 1, this.getChannel().getState(true)));
    }

    CompletableFuture<Boolean> channelFailedToConnectAsync() {
        if (this.hasConnected) {
            return CompletableFuture.completedFuture(false);
        }
        return this.channelFailedToConnectAsync(0, this.getChannel().getState(true));
    }

    synchronized void close(Duration timeout) throws InterruptedException {
        if (this.channel != null) {
            this.channel.shutdown();
            this.channel.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS);
            this.channel = null;
        }
    }

    private String getUserAgent() {
        Package thePackage = this.getClass().getPackage();
        String implementationVersion = thePackage != null ? thePackage.getImplementationVersion() : null;
        return "hedera-sdk-java/" + (String)(implementationVersion != null ? "v" + implementationVersion : "DEV");
    }
}

