/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.ManagedNode;
import com.hedera.hashgraph.sdk.ManagedNodeAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

abstract class ManagedNetwork<ManagedNetworkT extends ManagedNetwork<ManagedNetworkT, KeyT, ManagedNodeT>, KeyT, ManagedNodeT extends ManagedNode<ManagedNodeT, KeyT>> {
    protected static final Integer DEFAULT_MAX_NODE_ATTEMPTS = -1;
    protected static final Random random = new Random();
    protected final ExecutorService executor;
    protected Map<KeyT, List<ManagedNodeT>> network = new ConcurrentHashMap<KeyT, List<ManagedNodeT>>();
    protected List<ManagedNodeT> nodes = new ArrayList<ManagedNodeT>();
    protected List<ManagedNodeT> healthyNodes = new ArrayList<ManagedNodeT>();
    protected Duration minNodeBackoff = Client.DEFAULT_MIN_NODE_BACKOFF;
    protected Duration maxNodeBackoff = Client.DEFAULT_MAX_NODE_BACKOFF;
    protected Duration closeTimeout = Client.DEFAULT_CLOSE_TIMEOUT;
    protected int maxNodeAttempts = DEFAULT_MAX_NODE_ATTEMPTS;
    protected boolean transportSecurity;
    protected Duration minNodeReadmitTime = Client.DEFAULT_MIN_NODE_BACKOFF;
    protected Duration maxNodeReadmitTime = Client.DEFAULT_MAX_NODE_BACKOFF;
    protected Instant earliestReadmitTime;
    @Nullable
    private LedgerId ledgerId;

    protected ManagedNetwork(ExecutorService executor) {
        this.executor = executor;
        this.earliestReadmitTime = Instant.now().plus(this.minNodeReadmitTime);
    }

    @Nullable
    LedgerId getLedgerId() {
        return this.ledgerId;
    }

    synchronized ManagedNetworkT setLedgerId(@Nullable LedgerId ledgerId) {
        this.ledgerId = ledgerId;
        return (ManagedNetworkT)this;
    }

    int getMaxNodeAttempts() {
        return this.maxNodeAttempts;
    }

    synchronized ManagedNetworkT setMaxNodeAttempts(int maxNodeAttempts) {
        this.maxNodeAttempts = maxNodeAttempts;
        return (ManagedNetworkT)this;
    }

    Duration getMinNodeBackoff() {
        return this.minNodeBackoff;
    }

    synchronized ManagedNetworkT setMinNodeBackoff(Duration minNodeBackoff) {
        this.minNodeBackoff = minNodeBackoff;
        for (ManagedNode node : this.nodes) {
            node.setMinBackoff(minNodeBackoff);
        }
        return (ManagedNetworkT)this;
    }

    Duration getMaxNodeBackoff() {
        return this.maxNodeBackoff;
    }

    synchronized ManagedNetworkT setMaxNodeBackoff(Duration maxNodeBackoff) {
        this.maxNodeBackoff = maxNodeBackoff;
        for (ManagedNode node : this.nodes) {
            node.setMaxBackoff(maxNodeBackoff);
        }
        return (ManagedNetworkT)this;
    }

    public Duration getMinNodeReadmitTime() {
        return this.minNodeReadmitTime;
    }

    public void setMinNodeReadmitTime(Duration minNodeReadmitTime) {
        this.minNodeReadmitTime = minNodeReadmitTime;
        for (ManagedNode node : this.nodes) {
            node.readmitTime = Instant.now();
        }
    }

    public Duration getMaxNodeReadmitTime() {
        return this.maxNodeReadmitTime;
    }

    public void setMaxNodeReadmitTime(Duration maxNodeReadmitTime) {
        this.maxNodeReadmitTime = maxNodeReadmitTime;
    }

    boolean isTransportSecurity() {
        return this.transportSecurity;
    }

    synchronized ManagedNetworkT setTransportSecurity(boolean transportSecurity) throws InterruptedException {
        if (this.transportSecurity != transportSecurity) {
            this.network.clear();
            for (int i = 0; i < this.nodes.size(); ++i) {
                ManagedNode node = (ManagedNode)this.nodes.get(i);
                node.close(this.closeTimeout);
                node = transportSecurity ? node.toSecure() : node.toInsecure();
                this.nodes.set(i, node);
                this.getNodesForKey(node.getKey()).add(node);
            }
        }
        this.transportSecurity = transportSecurity;
        return (ManagedNetworkT)this;
    }

    Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    synchronized ManagedNetworkT setCloseTimeout(Duration closeTimeout) {
        this.closeTimeout = closeTimeout;
        return (ManagedNetworkT)this;
    }

    protected abstract ManagedNodeT createNodeFromNetworkEntry(Map.Entry<String, KeyT> var1);

    protected List<Integer> getNodesToRemove(Map<String, KeyT> network) {
        ArrayList<Integer> nodes = new ArrayList<Integer>(this.nodes.size());
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            ManagedNode node = (ManagedNode)this.nodes.get(i);
            if (this.nodeIsInGivenNetwork(node, network)) continue;
            nodes.add(i);
        }
        return nodes;
    }

    private boolean nodeIsInGivenNetwork(ManagedNodeT node, Map<String, KeyT> network) {
        for (Map.Entry<String, KeyT> entry : network.entrySet()) {
            if (!((ManagedNode)node).getKey().equals(entry.getValue()) || !((ManagedNode)node).address.equals(ManagedNodeAddress.fromString(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    synchronized ManagedNetworkT setNetwork(Map<String, KeyT> network) throws TimeoutException, InterruptedException {
        ArrayList<ManagedNodeT> newNodes = new ArrayList<ManagedNodeT>();
        ArrayList<ManagedNodeT> newHealthyNodes = new ArrayList<ManagedNodeT>(newNodes.size());
        HashMap<KeyT, List<ManagedNodeT>> newNetwork = new HashMap<KeyT, List<ManagedNodeT>>(newNodes.size());
        HashSet newNodeKeys = new HashSet();
        HashSet<String> newNodeAddresses = new HashSet<String>();
        for (Integer n : this.getNodesToRemove(network)) {
            long stopAt = Instant.now().getEpochSecond() + this.closeTimeout.getSeconds();
            long remainingTime = stopAt - Instant.now().getEpochSecond();
            ManagedNode node = (ManagedNode)this.nodes.get(n);
            if (remainingTime <= 0L) {
                throw new TimeoutException("Failed to properly shutdown all channels");
            }
            this.removeNodeFromNetwork(node);
            node.close(Duration.ofSeconds(remainingTime));
            this.nodes.remove(n);
        }
        for (ManagedNode managedNode : this.nodes) {
            newNodes.add(managedNode);
            newNodeKeys.add(managedNode.getKey());
            newNodeAddresses.add(managedNode.address.toString());
        }
        for (Map.Entry entry : network.entrySet()) {
            ManagedNodeT node = this.createNodeFromNetworkEntry(entry);
            if (newNodeKeys.contains(((ManagedNode)node).getKey()) && newNodeAddresses.contains(((ManagedNode)node).getAddress().toString())) continue;
            newNodes.add(node);
        }
        for (ManagedNode managedNode : newNodes) {
            if (newNetwork.containsKey(managedNode.getKey())) {
                newNetwork.get(managedNode.getKey()).add(managedNode);
            } else {
                ArrayList<ManagedNode> list = new ArrayList<ManagedNode>();
                list.add(managedNode);
                newNetwork.put(managedNode.getKey(), list);
            }
            newHealthyNodes.add(managedNode);
        }
        this.nodes = newNodes;
        this.network = newNetwork;
        this.healthyNodes = newHealthyNodes;
        return (ManagedNetworkT)this;
    }

    void increaseBackoff(ManagedNodeT node) {
        ((ManagedNode)node).increaseBackoff();
        this.healthyNodes.remove(node);
    }

    void decreaseBackoff(ManagedNodeT node) {
        ((ManagedNode)node).decreaseBackoff();
    }

    private void removeNodeFromNetwork(ManagedNodeT node) {
        List<ManagedNodeT> nodesForKey = this.network.get(((ManagedNode)node).getKey());
        nodesForKey.remove(node);
        if (nodesForKey.isEmpty()) {
            this.network.remove(((ManagedNode)node).getKey());
        }
    }

    private List<ManagedNodeT> getNodesForKey(KeyT key) {
        if (this.network.containsKey(key)) {
            return this.network.get(key);
        }
        ArrayList newList = new ArrayList();
        this.network.put(key, newList);
        return newList;
    }

    private boolean addressIsInNodeList(String addressString, List<ManagedNodeT> nodes) {
        ManagedNodeAddress address = ManagedNodeAddress.fromString(addressString);
        for (ManagedNode node : nodes) {
            if (!node.address.equals(address)) continue;
            return true;
        }
        return false;
    }

    protected void removeDeadNodes() throws InterruptedException {
        if (this.maxNodeAttempts > 0) {
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                ManagedNode node = Objects.requireNonNull((ManagedNode)this.nodes.get(i));
                if (node.getBadGrpcStatusCount() < (long)this.maxNodeAttempts) continue;
                node.close(this.closeTimeout);
                this.removeNodeFromNetwork(node);
                this.nodes.remove(i);
            }
        }
    }

    synchronized void readmitNodes() {
        Instant now = Instant.now();
        if (now.toEpochMilli() > this.earliestReadmitTime.toEpochMilli()) {
            Instant nextEarliestReadmitTime = now.plus(this.maxNodeReadmitTime);
            for (ManagedNode node : this.nodes) {
                if (!node.readmitTime.isAfter(now) || !node.readmitTime.isBefore(nextEarliestReadmitTime)) continue;
                nextEarliestReadmitTime = node.readmitTime;
            }
            this.earliestReadmitTime = nextEarliestReadmitTime;
            if (this.earliestReadmitTime.isBefore(now.plus(this.minNodeReadmitTime))) {
                this.earliestReadmitTime = now.plus(this.minNodeReadmitTime);
            }
            block1: for (int i = 0; i < this.nodes.size(); ++i) {
                for (int j = 0; j < this.healthyNodes.size(); ++j) {
                    if (this.nodes.get(i) == this.healthyNodes.get(j)) continue block1;
                }
                if (!((ManagedNode)this.nodes.get((int)i)).readmitTime.isBefore(now)) continue;
                this.healthyNodes.add((ManagedNode)this.nodes.get(i));
            }
        }
    }

    synchronized ManagedNodeT getNode(@Nullable KeyT key) {
        this.readmitNodes();
        if (key == null) {
            if (this.healthyNodes.isEmpty()) {
                throw new IllegalStateException("No healthy node was found");
            }
            return (ManagedNodeT)((ManagedNode)this.healthyNodes.get(random.nextInt(this.healthyNodes.size())));
        }
        List<ManagedNodeT> list = this.network.get(key);
        return (ManagedNodeT)((ManagedNode)list.get(random.nextInt(list.size())));
    }

    protected synchronized List<ManagedNodeT> getNumberOfMostHealthyNodes(int count) throws InterruptedException {
        this.readmitNodes();
        this.removeDeadNodes();
        HashMap returnNodes = new HashMap(count);
        for (int i = 0; i < count; ++i) {
            ManagedNodeT node = this.getNode(null);
            if (returnNodes.containsKey(((ManagedNode)node).getKey())) continue;
            returnNodes.put(((ManagedNode)node).getKey(), node);
        }
        ArrayList returnList = new ArrayList();
        returnList.addAll(returnNodes.values());
        return returnList;
    }

    synchronized void close() throws TimeoutException, InterruptedException {
        this.close(this.closeTimeout);
    }

    synchronized void close(Duration timeout) throws TimeoutException, InterruptedException {
        long stopAt = Instant.now().getEpochSecond() + timeout.getSeconds();
        for (ManagedNode node : this.nodes) {
            if (node.channel == null) continue;
            node.channel = node.channel.shutdown();
        }
        for (ManagedNode node : this.nodes) {
            if (stopAt - Instant.now().getEpochSecond() == 0L) {
                throw new TimeoutException("Failed to properly shutdown all channels");
            }
            if (node.channel == null) continue;
            try {
                node.channel.awaitTermination(stopAt - Instant.now().getEpochSecond(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.nodes.clear();
        this.network.clear();
    }
}

