/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.proto.KeyList;
import com.hedera.hashgraph.sdk.proto.LiveHash;
import org.threeten.bp.Duration;

public class LiveHash {
    public final AccountId accountId;
    public final ByteString hash;
    public final com.hedera.hashgraph.sdk.KeyList keys;
    public final Duration duration;

    private LiveHash(AccountId accountId, ByteString hash, com.hedera.hashgraph.sdk.KeyList keys, Duration duration) {
        this.accountId = accountId;
        this.hash = hash;
        this.keys = keys;
        this.duration = duration;
    }

    protected static LiveHash fromProtobuf(com.hedera.hashgraph.sdk.proto.LiveHash liveHash) {
        return new LiveHash(AccountId.fromProtobuf(liveHash.getAccountId()), liveHash.getHash(), com.hedera.hashgraph.sdk.KeyList.fromProtobuf(liveHash.getKeys(), null), DurationConverter.fromProtobuf(liveHash.getDuration()));
    }

    public static LiveHash fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return LiveHash.fromProtobuf((com.hedera.hashgraph.sdk.proto.LiveHash)((LiveHash.Builder)com.hedera.hashgraph.sdk.proto.LiveHash.parseFrom(bytes).toBuilder()).build());
    }

    protected com.hedera.hashgraph.sdk.proto.LiveHash toProtobuf() {
        KeyList.Builder keyList = KeyList.newBuilder();
        for (Key key : this.keys) {
            keyList.addKeys(key.toProtobufKey());
        }
        return (com.hedera.hashgraph.sdk.proto.LiveHash)com.hedera.hashgraph.sdk.proto.LiveHash.newBuilder().setAccountId(this.accountId.toProtobuf()).setHash(this.hash).setKeys(keyList).setDuration(DurationConverter.toProtobuf(this.duration)).build();
    }

    public ByteString toBytes() {
        return this.toProtobuf().toByteString();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountId", this.accountId).add("hash", this.hash.toByteArray()).add("keys", this.keys).add("duration", this.duration).toString();
    }
}

