/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

final class FutureConverter {
    private FutureConverter() {
    }

    static <T> CompletableFuture<T> toCompletableFuture(ListenableFuture<T> listenableFuture) {
        return Java8FutureUtils.createCompletableFuture(GuavaFutureUtils.createValueSourceFuture(listenableFuture));
    }

    private static class Java8FutureUtils {
        private Java8FutureUtils() {
        }

        public static <T> CompletableFuture<T> createCompletableFuture(ValueSource<T> valueSource) {
            if (valueSource instanceof CompletableFutureBackedValueSource) {
                return ((CompletableFutureBackedValueSource)valueSource).getWrappedFuture();
            }
            return new ValueSourceBackedCompletableFuture<T>(valueSource);
        }

        private static final class CompletableFutureBackedValueSource<T>
        extends ValueSourceFuture<T> {
            private CompletableFutureBackedValueSource(CompletableFuture<T> completableFuture) {
                super(completableFuture);
            }

            @Override
            public void addCallbacks(Consumer<T> successCallback, Consumer<Throwable> failureCallback) {
                ((CompletableFuture)this.getWrappedFuture()).whenComplete((v, t) -> {
                    if (t == null) {
                        successCallback.accept(v);
                    } else {
                        failureCallback.accept((Throwable)t);
                    }
                });
            }

            @Override
            CompletableFuture<T> getWrappedFuture() {
                return (CompletableFuture)super.getWrappedFuture();
            }
        }

        private static final class ValueSourceBackedCompletableFuture<T>
        extends CompletableFuture<T> {
            private final ValueSource<T> valueSource;

            private ValueSourceBackedCompletableFuture(ValueSource<T> valueSource) {
                this.valueSource = valueSource;
                valueSource.addCallbacks(this::complete, this::completeExceptionally);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.isDone()) {
                    return false;
                }
                boolean result = this.valueSource.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        }
    }

    private static class GuavaFutureUtils {
        private GuavaFutureUtils() {
        }

        public static <T> ValueSourceFuture<T> createValueSourceFuture(ListenableFuture<T> listenableFuture) {
            if (listenableFuture instanceof ValueSourceFutureBackedListenableFuture) {
                return ((ValueSourceFutureBackedListenableFuture)listenableFuture).getWrappedFuture();
            }
            return new ListenableFutureBackedValueSourceFuture<T>(listenableFuture);
        }

        private static class ListenableFutureBackedValueSourceFuture<T>
        extends ValueSourceFuture<T> {
            private ListenableFutureBackedValueSourceFuture(ListenableFuture<T> wrappedFuture) {
                super(wrappedFuture);
            }

            @Override
            public void addCallbacks(final Consumer<T> successCallback, final Consumer<Throwable> failureCallback) {
                Futures.addCallback(this.getWrappedFuture(), new FutureCallback<T>(){

                    @Override
                    public void onSuccess(T result) {
                        successCallback.accept(result);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        failureCallback.accept(t);
                    }
                }, MoreExecutors.directExecutor());
            }

            @Override
            ListenableFuture<T> getWrappedFuture() {
                return (ListenableFuture)super.getWrappedFuture();
            }
        }

        private static class ValueSourceFutureBackedListenableFuture<T>
        extends FutureWrapper<T>
        implements ListenableFuture<T> {
            ValueSourceFutureBackedListenableFuture(ValueSourceFuture<T> valueSourceFuture) {
                super(valueSourceFuture);
            }

            @Override
            ValueSourceFuture<T> getWrappedFuture() {
                return (ValueSourceFuture)super.getWrappedFuture();
            }

            @Override
            public void addListener(Runnable listener, Executor executor) {
                this.getWrappedFuture().addCallbacks(value -> executor.execute(listener), ex -> executor.execute(listener));
            }
        }
    }

    private static class FutureWrapper<T>
    implements Future<T> {
        private final Future<T> wrappedFuture;

        FutureWrapper(Future<T> wrappedFuture) {
            this.wrappedFuture = wrappedFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.wrappedFuture.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.wrappedFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.wrappedFuture.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.wrappedFuture.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.wrappedFuture.get(timeout, unit);
        }

        Future<T> getWrappedFuture() {
            return this.wrappedFuture;
        }
    }

    private static abstract class ValueSourceFuture<T>
    extends FutureWrapper<T>
    implements ValueSource<T> {
        ValueSourceFuture(Future<T> wrappedFuture) {
            super(wrappedFuture);
        }
    }

    private static interface ValueSource<T> {
        public void addCallbacks(Consumer<T> var1, Consumer<Throwable> var2);

        public boolean cancel(boolean var1);
    }
}

