/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.proto.FileGetInfoResponse;
import com.hedera.hashgraph.sdk.proto.KeyList;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

public final class FileInfo {
    public final FileId fileId;
    public final long size;
    public final Instant expirationTime;
    public final boolean isDeleted;
    @Nullable
    public final com.hedera.hashgraph.sdk.KeyList keys;
    public final String fileMemo;
    public final LedgerId ledgerId;

    private FileInfo(FileId fileId, long size, Instant expirationTime, boolean isDeleted, @Nullable com.hedera.hashgraph.sdk.KeyList keys, String fileMemo, LedgerId ledgerId) {
        this.fileId = fileId;
        this.size = size;
        this.expirationTime = expirationTime;
        this.isDeleted = isDeleted;
        this.keys = keys;
        this.fileMemo = fileMemo;
        this.ledgerId = ledgerId;
    }

    static FileInfo fromProtobuf(FileGetInfoResponse.FileInfo fileInfo) {
        com.hedera.hashgraph.sdk.KeyList keys = fileInfo.hasKeys() ? com.hedera.hashgraph.sdk.KeyList.fromProtobuf(fileInfo.getKeys(), null) : null;
        return new FileInfo(FileId.fromProtobuf(fileInfo.getFileID()), fileInfo.getSize(), InstantConverter.fromProtobuf(fileInfo.getExpirationTime()), fileInfo.getDeleted(), keys, fileInfo.getMemo(), LedgerId.fromByteString(fileInfo.getLedgerId()));
    }

    public static FileInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return FileInfo.fromProtobuf((FileGetInfoResponse.FileInfo)((FileGetInfoResponse.FileInfo.Builder)FileGetInfoResponse.FileInfo.parseFrom(bytes).toBuilder()).build());
    }

    FileGetInfoResponse.FileInfo toProtobuf() {
        FileGetInfoResponse.FileInfo.Builder fileInfoBuilder = FileGetInfoResponse.FileInfo.newBuilder().setFileID(this.fileId.toProtobuf()).setSize(this.size).setExpirationTime(InstantConverter.toProtobuf(this.expirationTime)).setDeleted(this.isDeleted).setMemo(this.fileMemo).setLedgerId(this.ledgerId.toByteString());
        if (this.keys != null) {
            KeyList.Builder keyList = KeyList.newBuilder();
            for (Key key : this.keys) {
                keyList.addKeys(key.toProtobufKey());
            }
            fileInfoBuilder.setKeys(keyList);
        }
        return (FileGetInfoResponse.FileInfo)fileInfoBuilder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("fileId", this.fileId).add("size", this.size).add("expirationTime", this.expirationTime).add("isDeleted", this.isDeleted).add("keys", this.keys).add("fileMemo", this.fileMemo).add("ledgerId", this.ledgerId).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

