/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.FileID;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class FileId
implements Comparable<FileId> {
    public static final FileId ADDRESS_BOOK = new FileId(0L, 0L, 102L);
    public static final FileId FEE_SCHEDULE = new FileId(0L, 0L, 111L);
    public static final FileId EXCHANGE_RATES = new FileId(0L, 0L, 112L);
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    @Nullable
    private final String checksum;

    public FileId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public FileId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this(shard, realm, num, null);
    }

    FileId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
    }

    public static FileId fromString(String id) {
        return EntityIdHelper.fromString(id, FileId::new);
    }

    public static FileId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return FileId.fromProtobuf((FileID)((FileID.Builder)FileID.parseFrom(bytes).toBuilder()).build());
    }

    static FileId fromProtobuf(FileID fileId) {
        Objects.requireNonNull(fileId);
        return new FileId(fileId.getShardNum(), fileId.getRealmNum(), fileId.getFileNum());
    }

    public static FileId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, FileId::new);
    }

    public String toSolidityAddress() {
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    FileID toProtobuf() {
        return (FileID)FileID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setFileNum(this.num).build();
    }

    @Deprecated
    public void validate(Client client) throws BadEntityIdException {
        this.validateChecksum(client);
    }

    public void validateChecksum(Client client) throws BadEntityIdException {
        EntityIdHelper.validate(this.shard, this.realm, this.num, client, this.checksum);
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return EntityIdHelper.toString(this.shard, this.realm, this.num);
    }

    public String toStringWithChecksum(Client client) {
        return EntityIdHelper.toStringWithChecksum(this.shard, this.realm, this.num, client, this.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileId)) {
            return false;
        }
        FileId otherId = (FileId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }

    @Override
    public int compareTo(FileId o) {
        Objects.requireNonNull(o);
        int shardComparison = Long.compare(this.shard, o.shard);
        if (shardComparison != 0) {
            return shardComparison;
        }
        int realmComparison = Long.compare(this.realm, o.realm);
        if (realmComparison != 0) {
            return realmComparison;
        }
        return Long.compare(this.num, o.num);
    }
}

