/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.MessageLite;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Delayer;
import com.hedera.hashgraph.sdk.ExecutionState;
import com.hedera.hashgraph.sdk.FutureConverter;
import com.hedera.hashgraph.sdk.LockableList;
import com.hedera.hashgraph.sdk.MaxAttemptsExceededException;
import com.hedera.hashgraph.sdk.Network;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.WithExecute;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

abstract class Executable<SdkRequestT, ProtoRequestT extends MessageLite, ResponseT extends MessageLite, O>
implements WithExecute<O> {
    static final Pattern RST_STREAM = Pattern.compile(".*\\brst[^0-9a-zA-Z]stream\\b.*", 34);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    protected Integer maxAttempts = null;
    @Nullable
    protected Duration maxBackoff = null;
    @Nullable
    protected Duration minBackoff = null;
    protected LockableList<AccountId> nodeAccountIds = new LockableList();
    protected List<Node> nodes = new ArrayList<Node>();
    protected boolean attemptedAllNodes = false;
    @VisibleForTesting
    Function<GrpcRequest, ResponseT> blockingUnaryCall = grpcRequest -> (MessageLite)ClientCalls.blockingUnaryCall(grpcRequest.createCall(), grpcRequest.getRequest());
    @Nullable
    protected Duration grpcDeadline;
    private Function<ProtoRequestT, ProtoRequestT> requestListener = request -> {
        this.logger.trace("Sent protobuf {}", (Object)Hex.toHexString(request.toByteArray()));
        return request;
    };
    private Function<ResponseT, ResponseT> responseListener = response -> {
        this.logger.trace("Received protobuf {}", (Object)Hex.toHexString(response.toByteArray()));
        return response;
    };

    Executable() {
    }

    @Nullable
    public final Duration grpcDeadline() {
        return this.grpcDeadline;
    }

    public final SdkRequestT setGrpcDeadline(Duration grpcDeadline) {
        this.grpcDeadline = Objects.requireNonNull(grpcDeadline);
        return (SdkRequestT)this;
    }

    public final Duration getMaxBackoff() {
        return this.maxBackoff != null ? this.maxBackoff : Client.DEFAULT_MAX_BACKOFF;
    }

    public final SdkRequestT setMaxBackoff(Duration maxBackoff) {
        if (maxBackoff == null || maxBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("maxBackoff must be a positive duration");
        }
        if (maxBackoff.compareTo(this.getMinBackoff()) < 0) {
            throw new IllegalArgumentException("maxBackoff must be greater than or equal to minBackoff");
        }
        this.maxBackoff = maxBackoff;
        return (SdkRequestT)this;
    }

    public final Duration getMinBackoff() {
        return this.minBackoff != null ? this.minBackoff : Client.DEFAULT_MIN_BACKOFF;
    }

    public final SdkRequestT setMinBackoff(Duration minBackoff) {
        if (minBackoff == null || minBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("minBackoff must be a positive duration");
        }
        if (minBackoff.compareTo(this.getMaxBackoff()) > 0) {
            throw new IllegalArgumentException("minBackoff must be less than or equal to maxBackoff");
        }
        this.minBackoff = minBackoff;
        return (SdkRequestT)this;
    }

    @Deprecated
    public final int getMaxRetry() {
        return this.getMaxAttempts();
    }

    @Deprecated
    public final SdkRequestT setMaxRetry(int count) {
        return this.setMaxAttempts(count);
    }

    public final int getMaxAttempts() {
        return this.maxAttempts != null ? this.maxAttempts : 10;
    }

    public final SdkRequestT setMaxAttempts(int maxAttempts) {
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be greater than zero");
        }
        this.maxAttempts = maxAttempts;
        return (SdkRequestT)this;
    }

    @Nullable
    public final List<AccountId> getNodeAccountIds() {
        if (!this.nodeAccountIds.isEmpty()) {
            return new ArrayList<AccountId>(this.nodeAccountIds.getList());
        }
        return null;
    }

    public SdkRequestT setNodeAccountIds(List<AccountId> nodeAccountIds) {
        this.nodeAccountIds.setList(nodeAccountIds).setLocked(true);
        return (SdkRequestT)this;
    }

    public final SdkRequestT setRequestListener(Function<ProtoRequestT, ProtoRequestT> requestListener) {
        this.requestListener = Objects.requireNonNull(requestListener);
        return (SdkRequestT)this;
    }

    public final SdkRequestT setResponseListener(Function<ResponseT, ResponseT> responseListener) {
        this.responseListener = Objects.requireNonNull(responseListener);
        return (SdkRequestT)this;
    }

    void checkNodeAccountIds() {
        if (this.nodeAccountIds.isEmpty()) {
            throw new IllegalStateException("Request node account IDs were not set before executing");
        }
    }

    abstract void onExecute(Client var1) throws TimeoutException, PrecheckStatusException;

    abstract CompletableFuture<Void> onExecuteAsync(Client var1);

    void mergeFromClient(Client client) {
        if (this.maxAttempts == null) {
            this.maxAttempts = client.getMaxAttempts();
        }
        if (this.maxBackoff == null) {
            this.maxBackoff = client.getMaxBackoff();
        }
        if (this.minBackoff == null) {
            this.minBackoff = client.getMinBackoff();
        }
    }

    private void delay(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public O execute(Client client) throws TimeoutException, PrecheckStatusException {
        return this.execute(client, client.getRequestTimeout());
    }

    @Override
    public O execute(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException {
        Throwable lastException = null;
        this.mergeFromClient(client);
        this.onExecute(client);
        this.checkNodeAccountIds();
        this.setNodesFromNodeAccountIds(client);
        Instant timeoutTime = Instant.now().plus(timeout);
        int attempt = 1;
        while (true) {
            if (attempt > this.maxAttempts) {
                throw new MaxAttemptsExceededException(lastException);
            }
            if (Instant.now().isAfter(timeoutTime)) {
                throw new TimeoutException();
            }
            GrpcRequest grpcRequest = new GrpcRequest(client.network, attempt);
            Node node = grpcRequest.getNode();
            MessageLite response = null;
            if (!node.isHealthy()) {
                this.delay(node.getRemainingTimeForBackoff());
            }
            if (node.channelFailedToConnect()) {
                this.logger.trace("Failed to connect channel for node {} for request #{}", (Object)node.getAccountId(), (Object)attempt);
                lastException = grpcRequest.reactToConnectionFailure();
            } else {
                try {
                    response = (MessageLite)this.blockingUnaryCall.apply(grpcRequest);
                }
                catch (Throwable e) {
                    lastException = e;
                }
                if (response == null) {
                    if (!grpcRequest.shouldRetryExceptionally(lastException)) {
                        throw new RuntimeException(lastException);
                    }
                } else {
                    switch (grpcRequest.getStatus(response)) {
                        case ServerError: {
                            lastException = grpcRequest.mapStatusException();
                            break;
                        }
                        case Retry: {
                            lastException = grpcRequest.mapStatusException();
                            if (attempt >= this.maxAttempts) break;
                            this.delay(grpcRequest.getDelay());
                            break;
                        }
                        case RequestError: {
                            throw grpcRequest.mapStatusException();
                        }
                        default: {
                            return grpcRequest.mapResponse();
                        }
                    }
                }
            }
            ++attempt;
        }
    }

    @Override
    public CompletableFuture<O> executeAsync(Client client) {
        CompletableFuture retval = new CompletableFuture().orTimeout(client.getRequestTimeout().toMillis(), TimeUnit.MILLISECONDS);
        this.mergeFromClient(client);
        ((CompletableFuture)this.onExecuteAsync(client).thenRun(() -> {
            this.checkNodeAccountIds();
            this.setNodesFromNodeAccountIds(client);
            this.executeAsyncInternal(client, 1, null, retval);
        })).exceptionally(error -> {
            retval.completeExceptionally((Throwable)error);
            return null;
        });
        return retval;
    }

    @VisibleForTesting
    void setNodesFromNodeAccountIds(Client client) {
        for (AccountId accountId : this.nodeAccountIds) {
            Node node = (Node)client.network.getNode(accountId);
            if (node == null) {
                throw new IllegalStateException("Some node account IDs did not map to valid nodes in the client's network");
            }
            this.nodes.add(Objects.requireNonNull(node));
        }
    }

    @VisibleForTesting
    Node getNodeForExecute(int attempt) {
        Node node = null;
        Node candidate = null;
        long smallestDelay = Long.MAX_VALUE;
        for (int i = 0; i < this.nodes.size() && !(node = this.nodes.get(this.nodeAccountIds.getIndex())).isHealthy(); ++i) {
            long backoff = node.getRemainingTimeForBackoff();
            if (backoff < smallestDelay) {
                candidate = node;
                smallestDelay = backoff;
            }
            node = null;
            this.advanceRequest();
        }
        if (node == null) {
            node = candidate;
            this.nodeAccountIds.setIndex(Math.max(0, this.nodeAccountIds.getIndex()));
        }
        if (node != null) {
            this.logger.trace("Using node {} for request #{}: {}", node.getAccountId(), attempt, this);
        }
        return node;
    }

    private ProtoRequestT getRequestForExecute() {
        ProtoRequestT request = this.makeRequest();
        this.advanceRequest();
        return request;
    }

    private void executeAsyncInternal(Client client, int attempt, @Nullable Throwable lastException, CompletableFuture<O> returnFuture) {
        if (returnFuture.isCancelled() || returnFuture.isCompletedExceptionally() || returnFuture.isDone()) {
            return;
        }
        if (attempt > this.maxAttempts) {
            returnFuture.completeExceptionally(new CompletionException(new MaxAttemptsExceededException(lastException)));
            return;
        }
        GrpcRequest grpcRequest = new GrpcRequest(client.network, attempt);
        if (!grpcRequest.getNode().isHealthy()) {
            Delayer.delayFor(grpcRequest.getNode().getRemainingTimeForBackoff(), client.executor).thenRun(() -> this.executeAsyncInternal(client, attempt, lastException, returnFuture));
            return;
        }
        ((CompletableFuture)grpcRequest.getNode().channelFailedToConnectAsync().thenAccept(connectionFailed -> {
            if (connectionFailed.booleanValue()) {
                Throwable connectionException = grpcRequest.reactToConnectionFailure();
                this.executeAsyncInternal(client, attempt + 1, connectionException, returnFuture);
                return;
            }
            ((CompletableFuture)FutureConverter.toCompletableFuture(ClientCalls.futureUnaryCall(grpcRequest.createCall(), grpcRequest.getRequest())).handle((response, error) -> {
                if (grpcRequest.shouldRetryExceptionally((Throwable)error)) {
                    this.executeAsyncInternal(client, attempt + 1, (Throwable)error, returnFuture);
                    return null;
                }
                if (error != null) {
                    returnFuture.completeExceptionally(new CompletionException((Throwable)error));
                    return null;
                }
                switch (grpcRequest.getStatus(response)) {
                    case ServerError: {
                        this.executeAsyncInternal(client, attempt + 1, grpcRequest.mapStatusException(), returnFuture);
                        break;
                    }
                    case Retry: {
                        Delayer.delayFor(attempt < this.maxAttempts ? grpcRequest.getDelay() : 0L, client.executor).thenRun(() -> this.executeAsyncInternal(client, attempt + 1, grpcRequest.mapStatusException(), returnFuture));
                        break;
                    }
                    case RequestError: {
                        returnFuture.completeExceptionally(new CompletionException(grpcRequest.mapStatusException()));
                        break;
                    }
                    default: {
                        returnFuture.complete(grpcRequest.mapResponse());
                    }
                }
                return null;
            })).exceptionally(error -> {
                returnFuture.completeExceptionally((Throwable)error);
                return null;
            });
        })).exceptionally(error -> {
            returnFuture.completeExceptionally((Throwable)error);
            return null;
        });
    }

    abstract ProtoRequestT makeRequest();

    GrpcRequest getGrpcRequest(int attempt) {
        return new GrpcRequest(null, attempt);
    }

    void advanceRequest() {
        if (this.nodeAccountIds.getIndex() + 1 == this.nodes.size() - 1) {
            this.attemptedAllNodes = true;
        }
        this.nodeAccountIds.advance();
    }

    abstract O mapResponse(ResponseT var1, AccountId var2, ProtoRequestT var3);

    abstract Status mapResponseStatus(ResponseT var1);

    abstract MethodDescriptor<ProtoRequestT, ResponseT> getMethodDescriptor();

    @Nullable
    abstract TransactionId getTransactionIdInternal();

    boolean shouldRetryExceptionally(@Nullable Throwable error) {
        if (error instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)error;
            Status.Code status = statusException.getStatus().getCode();
            String description = statusException.getStatus().getDescription();
            return status == Status.Code.UNAVAILABLE || status == Status.Code.RESOURCE_EXHAUSTED || status == Status.Code.INTERNAL && description != null && RST_STREAM.matcher(description).matches();
        }
        return false;
    }

    ExecutionState shouldRetry(Status status, ResponseT response) {
        switch (status) {
            case PLATFORM_TRANSACTION_NOT_CREATED: 
            case PLATFORM_NOT_ACTIVE: 
            case BUSY: {
                return ExecutionState.ServerError;
            }
            case OK: {
                return ExecutionState.Success;
            }
        }
        return ExecutionState.RequestError;
    }

    @VisibleForTesting
    class GrpcRequest {
        @Nullable
        private final Network network;
        private final Node node;
        private final int attempt;
        private final ProtoRequestT request;
        private final long startAt;
        private final long delay;
        private ResponseT response;
        private double latency;
        private Status responseStatus;

        GrpcRequest(Network network, int attempt) {
            this.network = network;
            this.attempt = attempt;
            this.node = Executable.this.getNodeForExecute(attempt);
            this.request = Executable.this.getRequestForExecute();
            this.startAt = System.nanoTime();
            this.delay = (long)Math.min((double)Objects.requireNonNull(Executable.this.minBackoff).toMillis() * Math.pow(2.0, attempt - 1), (double)Objects.requireNonNull(Executable.this.maxBackoff).toMillis());
        }

        public CallOptions getCallOptions() {
            CallOptions options = CallOptions.DEFAULT;
            if (Executable.this.grpcDeadline != null) {
                return options.withDeadlineAfter(Executable.this.grpcDeadline.toMillis(), TimeUnit.MILLISECONDS);
            }
            return options;
        }

        public Node getNode() {
            return this.node;
        }

        public ClientCall<ProtoRequestT, ResponseT> createCall() {
            this.verboseLog(this.node);
            return this.node.getChannel().newCall(Executable.this.getMethodDescriptor(), this.getCallOptions());
        }

        public ProtoRequestT getRequest() {
            return (MessageLite)Executable.this.requestListener.apply(this.request);
        }

        public long getDelay() {
            return this.delay;
        }

        Throwable reactToConnectionFailure() {
            Objects.requireNonNull(this.network).increaseBackoff(this.node);
            Executable.this.logger.warn("Retrying node {} in {} ms after channel connection failure during attempt #{}", this.node.getAccountId(), this.node.getRemainingTimeForBackoff(), this.attempt);
            this.verboseLog(this.node);
            return new IllegalStateException("Failed to connect to node " + this.node.getAccountId());
        }

        boolean shouldRetryExceptionally(@Nullable Throwable e) {
            this.latency = (double)(System.nanoTime() - this.startAt) / 1.0E9;
            boolean retry = Executable.this.shouldRetryExceptionally(e);
            if (retry) {
                Objects.requireNonNull(this.network).increaseBackoff(this.node);
                Executable.this.logger.warn("Retrying node {} in {} ms after failure during attempt #{}: {}", this.node.getAccountId(), this.node.getRemainingTimeForBackoff(), this.attempt, e != null ? e.getMessage() : "NULL");
                this.verboseLog(this.node);
            }
            return retry;
        }

        PrecheckStatusException mapStatusException() {
            return new PrecheckStatusException(this.responseStatus, Executable.this.getTransactionIdInternal());
        }

        O mapResponse() {
            return Executable.this.mapResponse(this.response, this.node.getAccountId(), this.request);
        }

        ExecutionState getStatus(ResponseT response) {
            this.node.decreaseBackoff();
            this.response = (MessageLite)Executable.this.responseListener.apply(response);
            this.responseStatus = Executable.this.mapResponseStatus(response);
            Executable.this.logger.trace("Received {} response in {} s from node {} during attempt #{}: {}", new Object[]{this.responseStatus, this.latency, this.node.getAccountId(), this.attempt, response});
            ExecutionState executionState = Executable.this.shouldRetry(this.responseStatus, response);
            if (executionState == ExecutionState.ServerError && Executable.this.attemptedAllNodes) {
                executionState = ExecutionState.Retry;
                Executable.this.attemptedAllNodes = false;
            }
            switch (executionState) {
                case Retry: {
                    Executable.this.logger.warn("Retrying node {} in {} ms after failure during attempt #{}: {}", new Object[]{this.node.getAccountId(), this.delay, this.attempt, this.responseStatus});
                    this.verboseLog(this.node);
                    break;
                }
                case ServerError: {
                    Executable.this.logger.warn("Problem submitting request to node {} for attempt #{}, retry with new node: {}", new Object[]{this.node.getAccountId(), this.attempt, this.responseStatus});
                    break;
                }
            }
            return executionState;
        }

        void verboseLog(Node node) {
            String ipAddress = node.address == null ? "NULL" : (node.address.getAddress() == null ? "NULL" : node.address.getAddress());
            Executable.this.logger.trace("Node IP {} Timestamp {} Transaction Type {}", ipAddress, System.currentTimeMillis(), this.getClass() != null ? this.getClass().getSimpleName() : "NULL");
        }
    }
}

