/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.Key;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class EvmAddress
extends Key {
    private final byte[] bytes;

    public EvmAddress(byte[] bytes) {
        this.bytes = bytes;
    }

    public static EvmAddress fromString(String text) {
        return new EvmAddress(Hex.decode(text));
    }

    @Nullable
    static EvmAddress fromAliasBytes(ByteString aliasBytes) {
        if (!aliasBytes.isEmpty()) {
            try {
                Key key = Key.fromProtobufKey(com.hedera.hashgraph.sdk.proto.Key.parseFrom(aliasBytes));
                return key instanceof EvmAddress ? (EvmAddress)key : null;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return null;
    }

    public static EvmAddress fromBytes(byte[] bytes) {
        return new EvmAddress(bytes);
    }

    @Override
    com.hedera.hashgraph.sdk.proto.Key toProtobufKey() {
        return (com.hedera.hashgraph.sdk.proto.Key)com.hedera.hashgraph.sdk.proto.Key.newBuilder().setEd25519(ByteString.copyFrom(this.bytes)).build();
    }

    @Override
    public byte[] toBytes() {
        return this.bytes;
    }

    public String toString() {
        return Hex.toHexString(this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvmAddress)) {
            return false;
        }
        EvmAddress other = (EvmAddress)o;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

