/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.EthereumTransactionData;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class EthereumTransactionDataLegacy
extends EthereumTransactionData {
    public byte[] chainId = new byte[0];
    public byte[] nonce;
    public byte[] gasPrice;
    public byte[] gasLimit;
    public byte[] to;
    public byte[] value;
    public byte[] v;
    public int recoveryId;
    public byte[] r;
    public byte[] s;

    EthereumTransactionDataLegacy(byte[] nonce, byte[] gasPrice, byte[] gasLimit, byte[] to, byte[] value, byte[] callData, byte[] v, byte[] r, byte[] s2) {
        super(callData);
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.v = v;
        this.r = r;
        this.s = s2;
        BigInteger vBI = new BigInteger(1, this.v);
        int n = this.recoveryId = vBI.testBit(0) ? 0 : 1;
        if (vBI.compareTo(BigInteger.valueOf(34L)) > 0) {
            this.chainId = vBI.subtract(BigInteger.valueOf(35L)).shiftRight(1).toByteArray();
        }
    }

    public static EthereumTransactionDataLegacy fromBytes(byte[] bytes) {
        Iterator<RLPItem> decoder = RLPDecoder.RLP_STRICT.sequenceIterator(bytes);
        RLPItem rlpItem = decoder.next();
        List<RLPItem> rlpList = rlpItem.asRLPList().elements();
        if (rlpList.size() != 9) {
            throw new IllegalArgumentException("expected 9 RLP encoded elements, found " + rlpList.size());
        }
        return new EthereumTransactionDataLegacy(rlpList.get(0).data(), rlpList.get(1).asBytes(), rlpList.get(2).data(), rlpList.get(3).data(), rlpList.get(4).data(), rlpList.get(5).data(), rlpList.get(6).asBytes(), rlpList.get(7).data(), rlpList.get(8).data());
    }

    @Override
    public byte[] toBytes() {
        return RLPEncoder.encodeAsList(this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.callData, this.v, this.r, this.s);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("chainId", Hex.toHexString(this.chainId)).add("nonce", Hex.toHexString(this.nonce)).add("gasPrice", Hex.toHexString(this.gasPrice)).add("gasLimit", Hex.toHexString(this.gasLimit)).add("to", Hex.toHexString(this.to)).add("value", Hex.toHexString(this.value)).add("recoveryId", this.recoveryId).add("v", Hex.toHexString(this.v)).add("r", Hex.toHexString(this.r)).add("s", Hex.toHexString(this.s)).toString();
    }
}

