/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.util.Integers;
import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.EthereumTransactionData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class EthereumTransactionDataEip1559
extends EthereumTransactionData {
    public byte[] chainId;
    public byte[] nonce;
    public byte[] maxPriorityGas;
    public byte[] maxGas;
    public byte[] gasLimit;
    public byte[] to;
    public byte[] value;
    public byte[] accessList;
    public byte[] recoveryId;
    public byte[] r;
    public byte[] s;

    EthereumTransactionDataEip1559(byte[] chainId, byte[] nonce, byte[] maxPriorityGas, byte[] maxGas, byte[] gasLimit, byte[] to, byte[] value, byte[] callData, byte[] accessList, byte[] recoveryId, byte[] r, byte[] s2) {
        super(callData);
        this.chainId = chainId;
        this.nonce = nonce;
        this.maxPriorityGas = maxPriorityGas;
        this.maxGas = maxGas;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.accessList = accessList;
        this.recoveryId = recoveryId;
        this.r = r;
        this.s = s2;
    }

    public static EthereumTransactionDataEip1559 fromBytes(byte[] bytes) {
        Iterator<RLPItem> decoder = RLPDecoder.RLP_STRICT.sequenceIterator(bytes);
        RLPItem rlpItem = decoder.next();
        byte typeByte = rlpItem.asByte();
        if (typeByte != 2) {
            throw new IllegalArgumentException("rlp type byte " + typeByte + "is not supported");
        }
        rlpItem = decoder.next();
        if (!rlpItem.isList()) {
            throw new IllegalArgumentException("expected RLP element list");
        }
        List<RLPItem> rlpList = rlpItem.asRLPList().elements();
        if (rlpList.size() != 12) {
            throw new IllegalArgumentException("expected 12 RLP encoded elements, found " + rlpList.size());
        }
        return new EthereumTransactionDataEip1559(rlpList.get(0).data(), rlpList.get(1).data(), rlpList.get(2).data(), rlpList.get(3).data(), rlpList.get(4).data(), rlpList.get(5).data(), rlpList.get(6).data(), rlpList.get(7).data(), rlpList.get(8).data(), rlpList.get(9).data(), rlpList.get(10).data(), rlpList.get(11).data());
    }

    @Override
    public byte[] toBytes() {
        return RLPEncoder.encodeSequentially(Integers.toBytes(2), List.of(this.chainId, this.nonce, this.maxPriorityGas, this.maxGas, this.gasLimit, this.to, this.value, this.callData, new ArrayList(), this.recoveryId, this.r, this.s));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("chainId", Hex.toHexString(this.chainId)).add("nonce", Hex.toHexString(this.nonce)).add("maxPriorityGas", Hex.toHexString(this.maxPriorityGas)).add("maxGas", Hex.toHexString(this.maxGas)).add("gasLimit", Hex.toHexString(this.gasLimit)).add("to", Hex.toHexString(this.to)).add("value", Hex.toHexString(this.value)).add("accessList", Hex.toHexString(this.accessList)).add("recoveryId", Hex.toHexString(this.recoveryId)).add("r", Hex.toHexString(this.r)).add("s", Hex.toHexString(this.s)).toString();
    }
}

