/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.hedera.hashgraph.sdk.EthereumTransactionDataEip1559;
import com.hedera.hashgraph.sdk.EthereumTransactionDataLegacy;
import java.util.Iterator;

public abstract class EthereumTransactionData {
    public byte[] callData;

    EthereumTransactionData(byte[] callData) {
        this.callData = callData;
    }

    static EthereumTransactionData fromBytes(byte[] bytes) {
        Iterator<RLPItem> decoder = RLPDecoder.RLP_STRICT.sequenceIterator(bytes);
        RLPItem rlpItem = decoder.next();
        if (rlpItem.isList()) {
            return EthereumTransactionDataLegacy.fromBytes(bytes);
        }
        return EthereumTransactionDataEip1559.fromBytes(bytes);
    }

    public abstract byte[] toBytes();

    public abstract String toString();
}

