/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EthereumTransaction;
import com.hedera.hashgraph.sdk.EthereumTransactionData;
import com.hedera.hashgraph.sdk.FileAppendTransaction;
import com.hedera.hashgraph.sdk.FileCreateTransaction;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TransactionResponse;
import com.hedera.hashgraph.sdk.WithExecute;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class EthereumFlow
implements WithExecute<TransactionResponse> {
    static int MAX_ETHEREUM_DATA_SIZE = 5120;
    @Nullable
    private EthereumTransactionData ethereumData;
    @Nullable
    private FileId callDataFileId;
    @Nullable
    private Hbar maxGasAllowance;

    @Nullable
    public EthereumTransactionData getEthereumData() {
        return this.ethereumData;
    }

    public EthereumFlow setEthereumData(byte[] ethereumData) {
        this.ethereumData = EthereumTransactionData.fromBytes(ethereumData);
        return this;
    }

    @Nullable
    public Hbar getMaxGasAllowance() {
        return this.maxGasAllowance;
    }

    public EthereumFlow setMaxGasAllowance(Hbar maxGasAllowance) {
        this.maxGasAllowance = maxGasAllowance;
        return this;
    }

    private static FileId createFile(byte[] callData, Client client) throws PrecheckStatusException, TimeoutException {
        try {
            TransactionResponse transaction = (TransactionResponse)new FileCreateTransaction().setContents(Arrays.copyOfRange(callData, 0, Math.min(FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length))).execute(client);
            FileId fileId = transaction.getReceipt((Client)client).fileId;
            if (callData.length > FileAppendTransaction.DEFAULT_CHUNK_SIZE) {
                new FileAppendTransaction().setFileId(fileId).setContents(Arrays.copyOfRange(callData, FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length)).execute(client);
            }
            return fileId;
        }
        catch (ReceiptStatusException e) {
            throw new RuntimeException(e);
        }
    }

    private static CompletableFuture<FileId> createFileAsync(byte[] callData, Client client) {
        return ((CompletableFuture)new FileCreateTransaction().setContents(Arrays.copyOfRange(callData, 0, Math.min(FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length))).executeAsync(client).thenCompose(response -> response.getReceiptAsync(client))).thenCompose(receipt -> {
            if (callData.length > FileAppendTransaction.DEFAULT_CHUNK_SIZE) {
                return new FileAppendTransaction().setFileId(receipt.fileId).setContents(Arrays.copyOfRange(callData, FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length)).executeAsync(client).thenApply(r -> receipt.fileId);
            }
            return CompletableFuture.completedFuture(receipt.fileId);
        });
    }

    @Override
    public TransactionResponse execute(Client client) throws PrecheckStatusException, TimeoutException {
        if (this.ethereumData == null) {
            throw new IllegalStateException("Cannot execute a ethereum flow when ethereum data was not provided");
        }
        EthereumTransaction ethereumTransaction = new EthereumTransaction();
        byte[] ethereumDataBytes = this.ethereumData.toBytes();
        if (this.maxGasAllowance != null) {
            ethereumTransaction.setMaxGasAllowanceHbar(this.maxGasAllowance);
        }
        if (ethereumDataBytes.length <= MAX_ETHEREUM_DATA_SIZE) {
            ethereumTransaction.setEthereumData(ethereumDataBytes);
        } else {
            FileId callDataFileId = EthereumFlow.createFile(this.ethereumData.callData, client);
            this.ethereumData.callData = new byte[0];
            ethereumTransaction.setEthereumData(this.ethereumData.toBytes()).setCallDataFileId(callDataFileId);
        }
        return (TransactionResponse)ethereumTransaction.execute(client);
    }

    @Override
    public CompletableFuture<TransactionResponse> executeAsync(Client client) {
        if (this.ethereumData == null) {
            CompletableFuture.failedFuture(new IllegalStateException("Cannot execute a ethereum flow when ethereum data was not provided"));
        }
        EthereumTransaction ethereumTransaction = new EthereumTransaction();
        byte[] ethereumDataBytes = this.ethereumData.toBytes();
        if (this.maxGasAllowance != null) {
            ethereumTransaction.setMaxGasAllowanceHbar(this.maxGasAllowance);
        }
        if (ethereumDataBytes.length <= MAX_ETHEREUM_DATA_SIZE) {
            return ethereumTransaction.setEthereumData(ethereumDataBytes).executeAsync(client);
        }
        return EthereumFlow.createFileAsync(this.ethereumData.callData, client).thenCompose(callDataFileId -> {
            this.ethereumData.callData = new byte[0];
            return ethereumTransaction.setEthereumData(this.ethereumData.toBytes()).setCallDataFileId((FileId)callDataFileId).executeAsync(client);
        });
    }
}

