/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.CustomFee;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.FixedFee;
import javax.annotation.Nullable;

public class CustomFixedFee
extends CustomFee {
    private long amount = 0L;
    @Nullable
    private TokenId denominatingTokenId = null;

    static CustomFixedFee clonedFrom(CustomFixedFee source) {
        CustomFixedFee returnFee = new CustomFixedFee();
        returnFee.amount = source.amount;
        returnFee.denominatingTokenId = source.denominatingTokenId;
        returnFee.feeCollectorAccountId = source.feeCollectorAccountId;
        return returnFee;
    }

    static CustomFixedFee fromProtobuf(FixedFee fixedFee) {
        CustomFixedFee returnFee = new CustomFixedFee().setAmount(fixedFee.getAmount());
        if (fixedFee.hasDenominatingTokenId()) {
            returnFee.setDenominatingTokenId(TokenId.fromProtobuf(fixedFee.getDenominatingTokenId()));
        }
        return returnFee;
    }

    static CustomFixedFee fromProtobuf(com.hedera.hashgraph.sdk.proto.CustomFee customFee) {
        CustomFixedFee returnFee = CustomFixedFee.fromProtobuf(customFee.getFixedFee());
        if (customFee.hasFeeCollectorAccountId()) {
            returnFee.setFeeCollectorAccountId(AccountId.fromProtobuf(customFee.getFeeCollectorAccountId()));
        }
        return returnFee;
    }

    public CustomFixedFee setFeeCollectorAccountId(AccountId feeCollectorAccountId) {
        this.doSetFeeCollectorAccountId(feeCollectorAccountId);
        return this;
    }

    public long getAmount() {
        return this.amount;
    }

    public CustomFixedFee setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public Hbar getHbarAmount() {
        return Hbar.fromTinybars(this.amount);
    }

    public CustomFixedFee setHbarAmount(Hbar amount) {
        this.denominatingTokenId = null;
        this.amount = amount.toTinybars();
        return this;
    }

    @Nullable
    public TokenId getDenominatingTokenId() {
        return this.denominatingTokenId;
    }

    public CustomFixedFee setDenominatingTokenId(@Nullable TokenId tokenId) {
        this.denominatingTokenId = tokenId;
        return this;
    }

    public CustomFixedFee setDenominatingTokenToSameToken() {
        this.denominatingTokenId = new TokenId(0L, 0L, 0L);
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        super.validateChecksums(client);
        if (this.denominatingTokenId != null) {
            this.denominatingTokenId.validateChecksum(client);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("feeCollectorAccountId", this.getFeeCollectorAccountId()).add("amount", this.getAmount()).add("demoninatingTokenId", this.getDenominatingTokenId()).toString();
    }

    FixedFee toFixedFeeProtobuf() {
        FixedFee.Builder fixedFeeBuilder = FixedFee.newBuilder().setAmount(this.getAmount());
        if (this.getDenominatingTokenId() != null) {
            fixedFeeBuilder.setDenominatingTokenId(this.getDenominatingTokenId().toProtobuf());
        }
        return (FixedFee)fixedFeeBuilder.build();
    }

    @Override
    com.hedera.hashgraph.sdk.proto.CustomFee toProtobuf() {
        CustomFee.Builder customFeeBuilder = com.hedera.hashgraph.sdk.proto.CustomFee.newBuilder().setFixedFee(this.toFixedFeeProtobuf());
        return this.finishToProtobuf(customFeeBuilder);
    }
}

